/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.stereo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class RectifiedPairPanel
extends JPanel
implements MouseListener {
    BufferedImage image1;
    BufferedImage image2;
    int mouseY = -10;
    int mouseX;
    boolean scaleToWindow;

    public RectifiedPairPanel(boolean scaleToWindow) {
        this.addMouseListener(this);
        this.scaleToWindow = scaleToWindow;
    }

    public RectifiedPairPanel(boolean scaleToWindow, BufferedImage image1, BufferedImage image2) {
        this(scaleToWindow);
        this.setImages(image1, image2);
        int h = Math.max(image1.getHeight(), image2.getHeight());
        int w = image1.getWidth() + image2.getWidth();
        this.setPreferredSize(new Dimension(w, h));
        this.setMinimumSize(new Dimension(w, h));
    }

    public void setImages(BufferedImage image1, BufferedImage image2) {
        this.image1 = image1;
        this.image2 = image2;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.image1 == null || this.image2 == null) {
            return;
        }
        double scale = 1.0;
        if (this.scaleToWindow) {
            double scaleY;
            int h = Math.max(this.image1.getHeight(), this.image2.getHeight());
            int w = this.image1.getWidth() + this.image2.getWidth();
            double scaleX = (double)this.getWidth() / (double)w;
            scale = Math.min(scaleX, scaleY = (double)this.getHeight() / (double)h);
            if (scale > 1.0) {
                scale = 1.0;
            }
            AffineTransform orig = g2.getTransform();
            AffineTransform combined = (AffineTransform)orig.clone();
            combined.concatenate(AffineTransform.getScaleInstance(scale, scale));
            g2.setTransform(combined);
            g2.drawImage((Image)this.image1, 0, 0, null);
            g2.drawImage((Image)this.image2, this.image1.getWidth(), 0, null);
            g2.setTransform(orig);
        } else {
            g2.drawImage((Image)this.image1, 0, 0, null);
            g2.drawImage((Image)this.image2, this.image1.getWidth(), 0, null);
        }
        if (this.mouseY >= 0) {
            int x = this.mouseX >= this.image1.getWidth() ? this.mouseX - this.image1.getWidth() : this.mouseX;
            x = (int)((double)x * scale);
            g2.setStroke(new BasicStroke(1.0f));
            g2.setColor(Color.RED);
            g2.drawLine(x, 0, x, this.getHeight());
            g2.drawLine(x += this.image1.getWidth(), 0, x, this.getHeight());
        }
        g2.setColor(Color.RED);
        g2.setStroke(new BasicStroke(3.0f));
        g2.drawLine(0, this.mouseY, this.getWidth(), this.mouseY);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.mouseY = e.getY();
        this.mouseX = e.getX();
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

