/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.abst.fiducial.calib.RenderCalibrationTargets;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class RenderCalibrationTargetsGraphics2D
extends RenderCalibrationTargets {
    int padding;
    double unitsToPixels;
    BufferedImage bufferred;
    Graphics2D g2;
    double paperWidth;
    double paperHeight;
    int offsetX;
    int offsetY;

    public RenderCalibrationTargetsGraphics2D(int padding, double unitsToPixels) {
        this.padding = padding;
        this.unitsToPixels = unitsToPixels;
    }

    public void setPaperSize(double widthUnits, double heightUnits) {
        this.paperWidth = widthUnits;
        this.paperHeight = heightUnits;
    }

    public void specifySize(double width, double height) {
        int w = (int)(this.unitsToPixels * width + 0.5);
        int h = (int)(this.unitsToPixels * height + 0.5);
        if (this.paperWidth <= 0.0 || this.paperHeight <= 0.0) {
            this.offsetX = this.offsetY = this.padding;
        } else {
            this.offsetX = ((int)(this.unitsToPixels * this.paperWidth + 0.5) - w) / 2;
            this.offsetY = ((int)(this.unitsToPixels * this.paperHeight + 0.5) - h) / 2;
        }
        this.bufferred = this.offsetX <= 0 || this.offsetY <= 0 ? new BufferedImage(w, h, 1) : new BufferedImage(w + 2 * this.offsetX, h + 2 * this.offsetY, 1);
        this.g2 = this.bufferred.createGraphics();
        this.g2.setColor(Color.WHITE);
        this.g2.fillRect(0, 0, this.bufferred.getWidth(), this.bufferred.getHeight());
        this.g2.setColor(Color.BLACK);
        this.g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public void drawSquare(double x, double y, double width) {
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.x = (double)this.offsetX + x * this.unitsToPixels;
        r.y = (double)this.offsetY + y * this.unitsToPixels;
        r.height = r.width = width * this.unitsToPixels;
        this.g2.fill(r);
    }

    public void drawCircle(double cx, double cy, double diameter) {
        Ellipse2D.Double ellipse = new Ellipse2D.Double();
        ellipse.x = (double)this.offsetX + (cx - diameter / 2.0) * this.unitsToPixels;
        ellipse.y = (double)this.offsetY + (cy - diameter / 2.0) * this.unitsToPixels;
        ellipse.width = diameter * this.unitsToPixels;
        ellipse.height = diameter * this.unitsToPixels;
        this.g2.fill(ellipse);
    }

    public double getWidthWorld() {
        return (double)this.bufferred.getWidth() / this.unitsToPixels;
    }

    public double getHeightWorld() {
        return (double)this.bufferred.getHeight() / this.unitsToPixels;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public GrayU8 getGrayU8() {
        GrayU8 gray = new GrayU8(this.bufferred.getWidth(), this.bufferred.getHeight());
        ConvertBufferedImage.convertFrom((BufferedImage)this.bufferred, (GrayU8)gray);
        return gray;
    }

    public GrayF32 getGrayF32() {
        GrayF32 gray = new GrayF32(this.bufferred.getWidth(), this.bufferred.getHeight());
        ConvertBufferedImage.convertFrom((BufferedImage)this.bufferred, (GrayF32)gray);
        return gray;
    }

    public BufferedImage getBufferred() {
        return this.bufferred;
    }
}

