/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.calibration;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.distort.LensDistortionWideFOV;
import boofcv.alg.distort.NarrowToWidePtoP_F32;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.distort.pinhole.LensDistortionPinhole;
import boofcv.alg.distort.universal.LensDistortionUniversalOmni;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.gui.BoofSwingUtil;
import boofcv.gui.calibration.DisplayCalibrationPanel;
import boofcv.gui.calibration.DisplayPinholeCalibrationPanel;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.border.BorderType;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraUniversalOmni;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.geometry.ConvertRotation3D_F32;
import georegression.geometry.GeometryMath_F32;
import georegression.geometry.UtilVector3D_F32;
import georegression.struct.GeoTuple3D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.so.Rodrigues_F32;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.List;
import org.ejml.data.FMatrixRMaj;

public class DisplayFisheyeCalibrationPanel
extends DisplayCalibrationPanel<CameraUniversalOmni> {
    NarrowToWidePtoP_F32 distorter;
    LensDistortionWideFOV fisheyeDistort;
    ImageDistort<Planar<GrayF32>, Planar<GrayF32>> distortImage;
    Planar<GrayF32> imageFisheye = new Planar(GrayF32.class, 1, 1, 3);
    Planar<GrayF32> imageRendered = new Planar(GrayF32.class, 1, 1, 3);
    BufferedImage bufferedRendered;
    CameraPinhole pinholeModel = new CameraPinhole(200.0, 200.0, 0.0, 200.0, 200.0, 400, 400);
    double pixelX;
    double pixelY;
    AffineTransform renderTran = new AffineTransform();

    public DisplayFisheyeCalibrationPanel() {
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                this.changeFocus(e);
            }

            private void changeFocus(MouseEvent e) {
                double omniY;
                double omniX = (double)e.getX() / DisplayFisheyeCalibrationPanel.this.scale;
                if (!DisplayFisheyeCalibrationPanel.this.imageFisheye.isInBounds((int)omniX, (int)(omniY = (double)e.getY() / DisplayFisheyeCalibrationPanel.this.scale))) {
                    return;
                }
                DisplayFisheyeCalibrationPanel.this.setPinholeCenter(omniX, omniY);
                DisplayFisheyeCalibrationPanel.this.renderPinhole();
                DisplayFisheyeCalibrationPanel.this.repaint();
            }
        };
        this.panel.addMouseMotionListener(adapter);
    }

    @Override
    public void setBufferedImage(BufferedImage image) {
        BoofSwingUtil.checkGuiThread();
        super.setBufferedImage(image);
        ConvertBufferedImage.convertFrom((BufferedImage)image, this.imageFisheye, (boolean)true);
        if (this.imageFisheye.getNumBands() != this.imageRendered.getNumBands()) {
            this.imageRendered = this.imageFisheye.createNew(1, 1);
        }
        this.renderPinhole();
    }

    @Override
    public void setCalibration(CameraUniversalOmni fisheyeModel) {
        BoofSwingUtil.checkGuiThread();
        LensDistortionPinhole pinholeDistort = new LensDistortionPinhole(this.pinholeModel);
        this.fisheyeDistort = new LensDistortionUniversalOmni(fisheyeModel);
        this.distorter = new NarrowToWidePtoP_F32((LensDistortionNarrowFOV)pinholeDistort, this.fisheyeDistort);
        InterpolatePixel interp = FactoryInterpolation.createPixel((double)0.0, (double)255.0, (InterpolationType)InterpolationType.BILINEAR, (BorderType)BorderType.ZERO, (ImageType)this.imageFisheye.getImageType());
        this.distortImage = FactoryDistort.distort((boolean)false, (InterpolatePixel)interp, (ImageType)this.imageFisheye.getImageType());
        this.distortImage.setModel((PixelTransform)new PointToPixelTransform_F32((Point2Transform2_F32)this.distorter));
        this.setPinholeCenter(fisheyeModel.width / 2, fisheyeModel.height / 2);
        this.renderPinhole();
    }

    public void setPinholeCenter(double pixelX, double pixelY) {
        this.pixelX = pixelX;
        this.pixelY = pixelY;
        Point3D_F32 norm = new Point3D_F32();
        this.fisheyeDistort.undistortPtoS_F32().compute((float)pixelX, (float)pixelY, norm);
        Rodrigues_F32 rotation = new Rodrigues_F32();
        Vector3D_F32 canonical = new Vector3D_F32(0.0f, 0.0f, 1.0f);
        rotation.theta = UtilVector3D_F32.acute((GeoTuple3D_F32)new Vector3D_F32((GeoTuple3D_F32)norm), (GeoTuple3D_F32)canonical);
        GeometryMath_F32.cross((GeoTuple3D_F32)canonical, (GeoTuple3D_F32)norm, (GeoTuple3D_F32)rotation.unitAxisRotation);
        rotation.unitAxisRotation.normalize();
        FMatrixRMaj R = ConvertRotation3D_F32.rodriguesToMatrix((Rodrigues_F32)rotation, null);
        this.distorter.setRotationWideToNarrow(R);
        this.distortImage.setModel((PixelTransform)new PointToPixelTransform_F32((Point2Transform2_F32)this.distorter));
    }

    private void renderPinhole() {
        if (this.distortImage == null) {
            return;
        }
        this.imageRendered.reshape(this.pinholeModel.width, this.pinholeModel.height);
        this.distortImage.apply(this.imageFisheye, this.imageRendered);
        this.bufferedRendered = ConvertBufferedImage.checkDeclare((int)this.imageRendered.width, (int)this.imageRendered.height, (BufferedImage)this.bufferedRendered, (int)1);
        ConvertBufferedImage.convertTo(this.imageRendered, (BufferedImage)this.bufferedRendered, (boolean)true);
    }

    @Override
    protected void paintInPanel(AffineTransform tran, Graphics2D g2) {
        this.drawFeatures(g2, this.scale);
        if (!this.showUndistorted || this.bufferedRendered == null) {
            return;
        }
        double scaleSize = (double)(this.img.getWidth() / 2) / (double)this.bufferedRendered.getWidth();
        double offX = (this.pixelX - scaleSize * (double)this.bufferedRendered.getWidth() / 2.0) * this.scale;
        double offY = (this.pixelY - scaleSize * (double)this.bufferedRendered.getHeight() / 2.0) * this.scale;
        this.renderTran.setTransform(this.scale * scaleSize, 0.0, 0.0, this.scale * scaleSize, offX, offY);
        g2.drawImage(this.bufferedRendered, this.renderTran, null);
    }

    private void drawFeatures(Graphics2D g2, double scale) {
        if (this.results == null) {
            return;
        }
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        CalibrationObservation set = this.features;
        Ellipse2D.Double ellipse = new Ellipse2D.Double();
        Point2D_F32 adj = new Point2D_F32();
        if (this.showOrder) {
            DisplayFisheyeCalibrationPanel.renderOrder(g2, scale, set.points);
        }
        if (this.showPoints) {
            g2.setColor(Color.BLACK);
            g2.setStroke(new BasicStroke(3.0f));
            for (PointIndex2D_F64 p : set.points) {
                adj.set((float)p.x, (float)p.y);
                VisualizeFeatures.drawCross(g2, (double)adj.x * scale, (double)adj.y * scale, 4.0);
            }
            g2.setStroke(new BasicStroke(1.0f));
            g2.setColor(Color.RED);
            for (PointIndex2D_F64 p : set.points) {
                adj.set((float)p.x, (float)p.y);
                VisualizeFeatures.drawCross(g2, (double)adj.x * scale, (double)adj.y * scale, 4.0);
            }
        }
        if (this.showAll) {
            for (CalibrationObservation l : this.allFeatures) {
                for (PointIndex2D_F64 p : l.points) {
                    adj.set((float)p.x, (float)p.y);
                    VisualizeFeatures.drawPoint(g2, (double)adj.x * scale, (double)adj.y * scale, 3.0, Color.BLUE, Color.WHITE, ellipse);
                }
            }
        }
        if (this.showNumbers) {
            DisplayPinholeCalibrationPanel.drawNumbers(g2, set, null, scale);
        }
        if (this.showErrors) {
            int i;
            PointIndex2D_F64 p;
            g2.setStroke(new BasicStroke(4.0f));
            g2.setColor(Color.BLACK);
            for (i = 0; i < set.size(); ++i) {
                p = set.get(i);
                adj.set((float)p.x, (float)p.y);
                double r = this.errorScale * this.results.pointError[i];
                if (r < 1.0) continue;
                VisualizeFeatures.drawCircle(g2, (double)adj.x * scale, (double)adj.y * scale, r, ellipse);
            }
            g2.setStroke(new BasicStroke(2.5f));
            g2.setColor(Color.ORANGE);
            for (i = 0; i < set.size(); ++i) {
                p = set.get(i);
                adj.set((float)p.x, (float)p.y);
                double r = this.errorScale * this.results.pointError[i];
                if (r < 1.0) continue;
                VisualizeFeatures.drawCircle(g2, (double)adj.x * scale, (double)adj.y * scale, r);
            }
        }
    }

    public static void renderOrder(Graphics2D g2, double scale, List<Point2D_F64> points) {
        g2.setStroke(new BasicStroke(5.0f));
        Line2D.Double l = new Line2D.Double();
        int i = 0;
        int j = 1;
        while (j < points.size()) {
            Point2D_F64 p0 = points.get(i);
            Point2D_F64 p1 = points.get(j);
            double fraction = (double)i / ((double)points.size() - 2.0);
            int red = (int)(255.0 * fraction) + (int)(0.0 * (1.0 - fraction));
            int green = 0;
            int blue = (int)(0.0 * fraction) + (int)(255.0 * (1.0 - fraction));
            int lineRGB = red << 16 | green << 8 | blue;
            l.setLine(scale * p0.x, scale * p0.y, scale * p1.x, scale * p1.y);
            g2.setColor(new Color(lineRGB));
            g2.draw(l);
            i = j++;
        }
    }
}

