/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.gui.dialogs.OpenImageSetDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.NumberFormatter;
import org.apache.commons.io.FilenameUtils;

public class BoofSwingUtil {
    public static final String KEY_RECENT_FILES = "RecentFiles";
    public static final String KEY_PREVIOUS_SELECTION = "PreviouslySelected";
    public static final double MIN_ZOOM = 0.01;
    public static final double MAX_ZOOM = 50.0;

    public static boolean isRightClick(MouseEvent e) {
        return e.getButton() == 3 || System.getProperty("os.name").contains("Mac OS X") && (e.getModifiers() & 0x10) != 0 && (e.getModifiers() & 2) != 0;
    }

    public static File saveFileChooser(Component parent, FileTypes ... filters) {
        return BoofSwingUtil.fileChooser(parent, false, new File(".").getPath(), filters);
    }

    public static String[] openImageSetChooser(Window parent, OpenImageSetDialog.Mode mode, int numberOfImages) {
        File defaultPath;
        Preferences prefs = parent == null ? Preferences.userRoot() : Preferences.userRoot().node(parent.getClass().getSimpleName());
        String previousPath = prefs.get(KEY_PREVIOUS_SELECTION, (defaultPath = BoofSwingUtil.directoryUserHome()).getPath());
        String[] response = OpenImageSetDialog.showDialog(new File(previousPath), mode, numberOfImages, parent);
        if (response != null) {
            prefs.put(KEY_PREVIOUS_SELECTION, new File(response[0]).getParent());
        }
        return response;
    }

    public static File openFileChooser(Component parent, FileTypes ... filters) {
        return BoofSwingUtil.openFileChooser(parent, new File(".").getPath(), filters);
    }

    public static File openFileChooser(Component parent, String defaultPath, FileTypes ... filters) {
        return BoofSwingUtil.fileChooser(parent, true, defaultPath, filters);
    }

    public static File fileChooser(Component parent, boolean openFile, String defaultPath, FileTypes ... filters) {
        int returnVal;
        Preferences prefs = parent == null ? Preferences.userRoot() : Preferences.userRoot().node(parent.getClass().getSimpleName());
        String previousPath = prefs.get(KEY_PREVIOUS_SELECTION, defaultPath);
        JFileChooser chooser = new JFileChooser(previousPath);
        chooser.setSelectedFile(new File(previousPath));
        boolean selectDirectories = false;
        block8: for (FileTypes t : filters) {
            FileFilter ff;
            switch (t) {
                case FILES: {
                    ff = new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return true;
                        }

                        @Override
                        public String getDescription() {
                            return "All";
                        }
                    };
                    break;
                }
                case YAML: {
                    ff = new FileNameExtensionFilter("yaml", "yaml", "yml");
                    break;
                }
                case XML: {
                    ff = new FileNameExtensionFilter("xml", "xml");
                    break;
                }
                case IMAGES: {
                    ff = new FileNameExtensionFilter("Images", ImageIO.getReaderFileSuffixes());
                    break;
                }
                case VIDEOS: {
                    ff = new FileNameExtensionFilter("Videos", "mpg", "mp4", "mov", "avi", "wmv");
                    break;
                }
                case DIRECTORIES: {
                    selectDirectories = true;
                    break block8;
                }
                default: {
                    throw new RuntimeException("Unknown file type");
                }
            }
            chooser.addChoosableFileFilter(ff);
        }
        if (selectDirectories) {
            if (filters.length == 1) {
                chooser.setFileSelectionMode(1);
            } else {
                chooser.setFileSelectionMode(2);
            }
        }
        if (chooser.getChoosableFileFilters().length > 1) {
            chooser.setFileFilter(chooser.getChoosableFileFilters()[1]);
        }
        File selected = null;
        int n = returnVal = openFile ? chooser.showOpenDialog(parent) : chooser.showSaveDialog(parent);
        if (returnVal == 0) {
            selected = chooser.getSelectedFile();
            prefs.put(KEY_PREVIOUS_SELECTION, selected.getPath());
        }
        return selected;
    }

    public static List<String> getListOfRecentFiles(Component parent) {
        Preferences prefs = Preferences.userRoot().node(parent.getClass().getSimpleName());
        String encodedString = prefs.get(KEY_RECENT_FILES, "");
        String[] fileNames = encodedString.split("\n");
        ArrayList<String> output = new ArrayList<String>();
        for (String f : fileNames) {
            output.add(f);
        }
        return output;
    }

    public static void addToRecentFiles(Component parent, String filePath) {
        List<String> files = BoofSwingUtil.getListOfRecentFiles(parent);
        files.remove(filePath);
        if (files.size() >= 10) {
            files.remove(9);
        }
        files.add(0, filePath);
        String encoded = "";
        for (int i = 0; i < files.size(); ++i) {
            encoded = encoded + files.get(i);
            if (i >= files.size() - 1) continue;
            encoded = encoded + "\n";
        }
        Preferences prefs = Preferences.userRoot().node(parent.getClass().getSimpleName());
        prefs.put(KEY_RECENT_FILES, encoded);
    }

    public static void invokeNowOrLater(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static void checkGuiThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Must be run in UI thread");
        }
    }

    public static double selectZoomToShowAll(JComponent panel, int width, int height) {
        double scale;
        int w = panel.getWidth();
        int h = panel.getHeight();
        if (w == 0) {
            w = panel.getPreferredSize().width;
            h = panel.getPreferredSize().height;
        }
        if ((scale = Math.max((double)width / (double)w, (double)height / (double)h)) > 1.0) {
            return 1.0 / scale;
        }
        return 1.0;
    }

    public static double selectZoomToFitInDisplay(int width, int height) {
        double h;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double w = screenSize.getWidth();
        double scale = Math.max((double)width / w, (double)height / (h = screenSize.getHeight()));
        if (scale > 1.0) {
            return 1.0 / scale;
        }
        return 1.0;
    }

    public static JFormattedTextField createTextField(int current, int min, int max) {
        NumberFormat format = NumberFormat.getInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        if (Integer.MIN_VALUE != min) {
            formatter.setMinimum(Integer.valueOf(min));
        }
        if (Integer.MAX_VALUE != max) {
            formatter.setMaximum(Integer.valueOf(max));
        }
        formatter.setAllowsInvalid(true);
        JFormattedTextField field = new JFormattedTextField(formatter);
        field.setHorizontalAlignment(4);
        field.setValue(current);
        return field;
    }

    public static JFormattedTextField createTextField(double current, double min, double max) {
        NumberFormat format = NumberFormat.getInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Double.class);
        if (!Double.isNaN(min)) {
            formatter.setMinimum(Double.valueOf(min));
        }
        if (!Double.isNaN(max)) {
            formatter.setMaximum(Double.valueOf(max));
        }
        formatter.setAllowsInvalid(true);
        JFormattedTextField field = new JFormattedTextField(formatter);
        field.setHorizontalAlignment(4);
        field.setValue(current);
        return field;
    }

    public static void setMenuItemKeys(JMenuItem menu, int mnmonic, int accelerator) {
        menu.setMnemonic(mnmonic);
        menu.setAccelerator(KeyStroke.getKeyStroke(accelerator, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    public static void warningDialog(Component component, Exception e) {
        JOptionPane.showMessageDialog(component, e.getMessage());
    }

    public static void antialiasing(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public static JButton createButtonIconGUI(String path, int width, int height) {
        return BoofSwingUtil.createButtonIcon("boofcv/gui/" + path, width, height, true);
    }

    public static JButton createButtonIcon(String path, int width, int height, boolean opaque) {
        try {
            BufferedImage b;
            URL url = ClassLoader.getSystemResource(path);
            if (url != null) {
                b = ImageIO.read(url);
                double scale = BoofSwingUtil.computeButtonScale(width, height, b.getWidth(), b.getHeight());
                if (scale != 1.0) {
                    width = (int)((double)b.getWidth() * scale);
                    height = (int)((double)b.getHeight() * scale);
                    BufferedImage a = new BufferedImage(width, height, 2);
                    Graphics2D g2 = a.createGraphics();
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    g2.drawImage(b, 0, 0, width, height, null);
                    b = a;
                }
            } else {
                JButton button = new JButton(path);
                int bWidth = button.getPreferredSize().width;
                int bHeight = button.getPreferredSize().height;
                double scale = BoofSwingUtil.computeButtonScale(width, height, bWidth, bHeight);
                button.setPreferredSize(new Dimension((int)(scale * (double)bWidth), (int)(scale * (double)bHeight)));
                return button;
            }
            JButton button = new JButton(new ImageIcon(b));
            if (!opaque) {
                button.setOpaque(false);
                button.setBackground(new Color(0, 0, 0, 0));
                button.setBorder(new EmptyBorder(0, 0, 0, 0));
            }
            button.setPreferredSize(new Dimension(width, height));
            return button;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isImage(File file) {
        block4: {
            try {
                String mimeType = Files.probeContentType(file.toPath());
                if (mimeType == null) {
                    String[] suffixes;
                    String extension = FilenameUtils.getExtension((String)file.getName()).toLowerCase();
                    for (String s : suffixes = ImageIO.getReaderFileSuffixes()) {
                        if (!s.equals(extension)) continue;
                        return true;
                    }
                    break block4;
                }
                return mimeType.startsWith("image");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private static double computeButtonScale(int width, int height, double imageWidth, double imageHeight) {
        double scale = 1.0;
        if (width > 0 || height > 0) {
            scale = width <= 0 ? (double)height / imageHeight : (height <= 0 ? (double)width / imageWidth : Math.min((double)width / imageWidth, (double)height / imageHeight));
        }
        return scale;
    }

    public static JButton button(String name, ActionListener action) {
        JButton b = new JButton(name);
        b.addActionListener(action);
        return b;
    }

    public static JCheckBox checkbox(String name, boolean checked, ActionListener action) {
        JCheckBox b = new JCheckBox(name);
        if (action != null) {
            b.addActionListener(action);
        }
        b.setSelected(checked);
        return b;
    }

    public static File directoryUserHome() {
        String home = System.getProperty("user.home");
        if (home == null) {
            home = "";
        }
        return new File(home);
    }

    public static enum FileTypes {
        FILES,
        YAML,
        XML,
        IMAGES,
        VIDEOS,
        DIRECTORIES;

    }
}

