/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.gui.VisualizeApp;
import boofcv.gui.image.ImagePanel;
import boofcv.io.MediaManager;
import boofcv.io.PathLabel;
import boofcv.io.wrapper.DefaultMediaManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public abstract class SelectAlgorithmAndInputPanel
extends JPanel
implements ActionListener,
VisualizeApp {
    JToolBar toolbar;
    JComboBox[] algBoxes;
    JComboBox imageBox;
    protected JCheckBox originalCheck;
    List<Object>[] algCookies;
    protected List<PathLabel> inputRefs;
    protected String baseDirectory = "";
    List<JComponent> addedComponents = new ArrayList<JComponent>();
    protected BufferedImage inputImage;
    ImagePanel origPanel = new ImagePanel();
    Component gui;
    boolean postAlgorithmEvents = false;
    protected MediaManager media = DefaultMediaManager.INSTANCE;

    public SelectAlgorithmAndInputPanel(int numAlgFamilies) {
        super(new BorderLayout());
        this.toolbar = new JToolBar();
        this.imageBox = new JComboBox();
        this.toolbar.add(this.imageBox);
        this.imageBox.addActionListener(this);
        this.imageBox.setMaximumSize(this.imageBox.getPreferredSize());
        this.algBoxes = new JComboBox[numAlgFamilies];
        this.algCookies = new List[numAlgFamilies];
        for (int i = 0; i < numAlgFamilies; ++i) {
            JComboBox b = this.algBoxes[i] = new JComboBox();
            this.toolbar.add(b);
            b.addActionListener(this);
            b.setMaximumSize(b.getPreferredSize());
            this.algCookies[i] = new ArrayList<Object>();
        }
        this.toolbar.add(Box.createHorizontalGlue());
        this.originalCheck = new JCheckBox("Show Input");
        this.toolbar.add(this.originalCheck);
        this.originalCheck.addActionListener(this);
        this.originalCheck.setEnabled(false);
        this.add((Component)this.toolbar, "First");
    }

    @Override
    public void loadInputData(String fileName) {
        Reader r = this.media.openFile(fileName);
        ArrayList<PathLabel> refs = new ArrayList<PathLabel>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(r);
            while ((line = reader.readLine()) != null) {
                String[] z = line.split(":");
                String[] names = new String[z.length - 1];
                for (int i = 1; i < z.length; ++i) {
                    names[i - 1] = this.baseDirectory + z[i];
                }
                refs.add(new PathLabel(z[0], names));
            }
            this.setInputList(refs);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setBaseDirectory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void addToToolbar(JComponent comp) {
        this.toolbar.add((Component)comp, 1 + this.algBoxes.length);
        this.toolbar.revalidate();
        this.addedComponents.add(comp);
    }

    public void removeFromToolbar(JComponent comp) {
        this.toolbar.remove(comp);
        this.toolbar.revalidate();
        this.addedComponents.remove(comp);
    }

    public void setMainGUI(final Component gui) {
        this.postAlgorithmEvents = true;
        this.gui = gui;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectAlgorithmAndInputPanel.this.add(gui, "Center");
            }
        });
    }

    public void setInputImage(BufferedImage image) {
        this.inputImage = image;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SelectAlgorithmAndInputPanel.this.inputImage == null) {
                    SelectAlgorithmAndInputPanel.this.originalCheck.setEnabled(false);
                } else {
                    SelectAlgorithmAndInputPanel.this.originalCheck.setEnabled(true);
                    SelectAlgorithmAndInputPanel.this.origPanel.setImage(SelectAlgorithmAndInputPanel.this.inputImage);
                    SelectAlgorithmAndInputPanel.this.origPanel.setPreferredSize(new Dimension(SelectAlgorithmAndInputPanel.this.inputImage.getWidth(), SelectAlgorithmAndInputPanel.this.inputImage.getHeight()));
                    SelectAlgorithmAndInputPanel.this.origPanel.repaint();
                }
            }
        });
    }

    public void setInputList(final List<PathLabel> inputRefs) {
        this.inputRefs = inputRefs;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < inputRefs.size(); ++i) {
                    SelectAlgorithmAndInputPanel.this.imageBox.addItem(((PathLabel)inputRefs.get(i)).getLabel());
                }
            }
        });
    }

    public void addAlgorithm(final int indexFamily, final String name, Object cookie) {
        this.algCookies[indexFamily].add(cookie);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectAlgorithmAndInputPanel.this.algBoxes[indexFamily].addItem(name);
            }
        });
    }

    public void doRefreshAll() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final Object[] state = new Object[SelectAlgorithmAndInputPanel.this.algCookies.length];
                for (int i = 0; i < state.length; ++i) {
                    state[i] = SelectAlgorithmAndInputPanel.this.algCookies[i].get(SelectAlgorithmAndInputPanel.this.algBoxes[i].getSelectedIndex());
                }
                new Thread(){

                    @Override
                    public void run() {
                        SelectAlgorithmAndInputPanel.this.setActiveGUI(false);
                        SelectAlgorithmAndInputPanel.this.refreshAll(state);
                        SelectAlgorithmAndInputPanel.this.setActiveGUI(true);
                    }
                }.start();
            }
        });
    }

    private void setActiveGUI(final boolean isEnabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectAlgorithmAndInputPanel.this.toolbar.setEnabled(isEnabled);
                for (JComboBox b : SelectAlgorithmAndInputPanel.this.algBoxes) {
                    b.setEnabled(isEnabled);
                }
                for (JComponent b : SelectAlgorithmAndInputPanel.this.addedComponents) {
                    b.setEnabled(isEnabled);
                }
                SelectAlgorithmAndInputPanel.this.imageBox.setEnabled(isEnabled);
            }
        });
    }

    protected <T> T getAlgorithmCookie(int indexFamily) {
        return (T)this.algCookies[indexFamily].get(this.algBoxes[indexFamily].getSelectedIndex());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.algBoxes.length; ++i) {
            if (this.algBoxes[i] != e.getSource()) continue;
            if (!this.postAlgorithmEvents) {
                return;
            }
            final Object cookie = this.algCookies[i].get(this.algBoxes[i].getSelectedIndex());
            final String name = (String)this.algBoxes[i].getSelectedItem();
            final int indexFamily = i;
            new Thread(){

                @Override
                public void run() {
                    SelectAlgorithmAndInputPanel.this.performSetAlgorithm(indexFamily, name, cookie);
                }
            }.start();
            return;
        }
        if (e.getSource() == this.imageBox) {
            final String name = (String)this.imageBox.getSelectedItem();
            new Thread(){

                @Override
                public void run() {
                    SelectAlgorithmAndInputPanel.this.performChangeInput(name, SelectAlgorithmAndInputPanel.this.imageBox.getSelectedIndex());
                }
            }.start();
        } else if (e.getSource() == this.originalCheck) {
            this.origPanel.setSize(this.gui.getWidth(), this.gui.getHeight());
            if (this.originalCheck.isSelected()) {
                this.remove(this.gui);
                this.add(this.origPanel);
            } else {
                this.remove(this.origPanel);
                this.add(this.gui);
            }
            this.validate();
            this.repaint();
        }
    }

    private void performSetAlgorithm(int indexFamily, String name, Object cookie) {
        this.setActiveGUI(false);
        this.setActiveAlgorithm(indexFamily, name, cookie);
        this.setActiveGUI(true);
    }

    private void performChangeInput(String name, int index) {
        this.setActiveGUI(false);
        this.changeInput(name, index);
        this.setActiveGUI(true);
    }

    @Override
    public void setMediaManager(MediaManager manager) {
        this.media = manager;
    }

    public abstract void refreshAll(Object[] var1);

    public abstract void setActiveAlgorithm(int var1, String var2, Object var3);

    public abstract void changeInput(String var1, int var2);
}

