/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.d3;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import georegression.geometry.ConvertRotation3D_F32;
import georegression.metric.UtilAngle;
import georegression.struct.EulerType;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.se.Se3_F32;
import georegression.transform.se.SePointOps_F32;
import java.awt.Graphics;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JPanel;
import org.ddogleg.struct.GrowQueue_F32;
import org.ddogleg.struct.GrowQueue_I32;
import org.ejml.data.FMatrixRMaj;

public class PointCloudViewerPanelSwing
extends JPanel
implements MouseMotionListener,
MouseListener,
MouseWheelListener {
    GrowQueue_F32 cloudXyz = new GrowQueue_F32();
    GrowQueue_I32 cloudColor = new GrowQueue_I32();
    float maxRenderDistance = Float.MAX_VALUE;
    boolean fog;
    float hfov = UtilAngle.radian((float)50.0f);
    Se3_F32 worldToCamera = new Se3_F32();
    float stepSize;
    final Object imageLock = new Object();
    GrayS32 imageRgb = new GrayS32(1, 1);
    GrayF32 imageDepth = new GrayF32(1, 1);
    BufferedImage imageOutput = new BufferedImage(1, 1, 1);
    private int dotRadius = 2;
    int backgroundColor = 0;
    int prevX;
    int prevY;
    Keyboard keyboard = new Keyboard();
    ScheduledExecutorService pressedTask;
    private Point3D_F32 worldPt = new Point3D_F32();
    private Point3D_F32 cameraPt = new Point3D_F32();
    private Point3D_F32 pixel = new Point3D_F32();
    boolean shiftPressed = false;
    private final Set<Integer> pressed = new HashSet<Integer>();

    public PointCloudViewerPanelSwing(float keyStepSize) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setFocusable(true);
        this.requestFocus();
        this.stepSize = keyStepSize;
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(PointCloudViewerPanelSwing.this.keyboard);
                PointCloudViewerPanelSwing.this.pressedTask = Executors.newScheduledThreadPool(1);
                PointCloudViewerPanelSwing.this.pressedTask.scheduleAtFixedRate(new KeypressedTask(), 100L, 30L, TimeUnit.MILLISECONDS);
            }

            @Override
            public void focusLost(FocusEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(PointCloudViewerPanelSwing.this.keyboard);
                PointCloudViewerPanelSwing.this.pressedTask.shutdown();
                PointCloudViewerPanelSwing.this.pressedTask = null;
                PointCloudViewerPanelSwing.this.resetKey();
            }
        });
    }

    public PointCloudViewerPanelSwing(float hfov, float keyStepSize) {
        this(keyStepSize);
        this.setHorizontalFieldOfView(hfov);
    }

    public void resetKey() {
        this.pressed.clear();
        this.shiftPressed = false;
    }

    public synchronized void setWorldToCamera(Se3_F32 worldToCamera) {
        this.worldToCamera.set(worldToCamera);
    }

    public void setHorizontalFieldOfView(float radians) {
        this.hfov = radians;
    }

    public synchronized void clearCloud() {
        this.cloudXyz.reset();
        this.cloudColor.reset();
    }

    public synchronized void addPoint(float x, float y, float z, int rgb) {
        this.cloudXyz.add(x);
        this.cloudXyz.add(y);
        this.cloudXyz.add(z);
        this.cloudColor.add(rgb);
    }

    public synchronized void addPoints(float[] pointsXYZ, int[] pointsRGB, int length) {
        int idxSrc = this.cloudXyz.size * 3;
        this.cloudXyz.extend(this.cloudXyz.size + length * 3);
        this.cloudColor.extend(this.cloudColor.size + length);
        int idx = 0;
        for (int i = 0; i < length; ++i) {
            this.cloudXyz.data[idxSrc++] = pointsXYZ[idx++];
            this.cloudXyz.data[idxSrc++] = pointsXYZ[idx++];
            this.cloudXyz.data[idxSrc++] = pointsXYZ[idx++];
            this.cloudColor.data[i] = pointsRGB[i];
        }
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.projectScene();
        this.imageOutput = ConvertBufferedImage.checkDeclare((int)this.imageRgb.width, (int)this.imageRgb.height, (BufferedImage)this.imageOutput, (int)1);
        DataBufferInt buffer = (DataBufferInt)this.imageOutput.getRaster().getDataBuffer();
        System.arraycopy(this.imageRgb.data, 0, buffer.getData(), 0, this.imageRgb.width * this.imageRgb.height);
        g.drawImage(this.imageOutput, 0, 0, null);
    }

    private synchronized void projectScene() {
        int w = this.getWidth();
        int h = this.getHeight();
        this.imageDepth.reshape(w, h);
        this.imageRgb.reshape(w, h);
        CameraPinholeBrown intrinsic = PerspectiveOps.createIntrinsic((int)w, (int)h, (double)UtilAngle.degree((float)this.hfov));
        float fx = (float)intrinsic.fx;
        float fy = (float)intrinsic.fy;
        float cx = (float)intrinsic.cx;
        float cy = (float)intrinsic.cy;
        ImageMiscOps.fill((GrayF32)this.imageDepth, (float)Float.MAX_VALUE);
        ImageMiscOps.fill((GrayS32)this.imageRgb, (int)this.backgroundColor);
        float maxDistanceSq = this.maxRenderDistance * this.maxRenderDistance;
        if (Float.isInfinite(maxDistanceSq)) {
            maxDistanceSq = Float.MAX_VALUE;
        }
        int totalPoints = this.cloudXyz.size / 3;
        int pointIdx = 0;
        for (int i = 0; i < totalPoints; ++i) {
            float r2;
            this.worldPt.x = this.cloudXyz.data[pointIdx++];
            this.worldPt.y = this.cloudXyz.data[pointIdx++];
            this.worldPt.z = this.cloudXyz.data[pointIdx++];
            SePointOps_F32.transform((Se3_F32)this.worldToCamera, (Point3D_F32)this.worldPt, (Point3D_F32)this.cameraPt);
            if (this.cameraPt.z < 0.0f || (r2 = this.cameraPt.normSq()) > maxDistanceSq) continue;
            this.pixel.x = fx * this.cameraPt.x / this.cameraPt.z + cx;
            this.pixel.y = fy * this.cameraPt.y / this.cameraPt.z + cy;
            int x = (int)(this.pixel.x + 0.5f);
            int y = (int)(this.pixel.y + 0.5f);
            if (!this.imageDepth.isInBounds(x, y)) continue;
            int rgb = this.cloudColor.data[i];
            if (this.fog) {
                rgb = this.applyFog(rgb, 1.0f - (float)Math.sqrt(r2) / this.maxRenderDistance);
            }
            this.renderDot(x, y, this.cameraPt.z, rgb);
        }
    }

    private int applyFog(int rgb, float fraction) {
        int adjustment = (int)(1000.0f * fraction);
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        r = (r * adjustment + (this.backgroundColor >> 16 & 0xFF) * (1000 - adjustment)) / 1000;
        g = (g * adjustment + (this.backgroundColor >> 8 & 0xFF) * (1000 - adjustment)) / 1000;
        b = (b * adjustment + (this.backgroundColor & 0xFF) * (1000 - adjustment)) / 1000;
        return r << 16 | g << 8 | b;
    }

    private void renderDot(int cx, int cy, float Z, int rgb) {
        for (int i = -this.dotRadius; i <= this.dotRadius; ++i) {
            int y = cy + i;
            if (y < 0 || y >= this.imageRgb.height) continue;
            for (int j = -this.dotRadius; j <= this.dotRadius; ++j) {
                int pixelIndex;
                float depth;
                int x = cx + j;
                if (x < 0 || x >= this.imageRgb.width || !((depth = this.imageDepth.data[pixelIndex = this.imageDepth.getIndex(x, y)]) > Z)) continue;
                this.imageDepth.data[pixelIndex] = Z;
                this.imageRgb.data[pixelIndex] = rgb;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleKeyPress() {
        Vector3D_F32 T = this.worldToCamera.getT();
        Set<Integer> set = this.pressed;
        synchronized (set) {
            Integer[] keys;
            double multiplier = this.shiftPressed ? 5.0 : 1.0;
            Integer[] integerArray = keys = this.pressed.toArray(new Integer[0]);
            int n = integerArray.length;
            block12: for (int i = 0; i < n; ++i) {
                int k = integerArray[i];
                switch (k) {
                    case 87: {
                        T.z = (float)((double)T.z - (double)this.stepSize * multiplier);
                        continue block12;
                    }
                    case 83: {
                        T.z = (float)((double)T.z + (double)this.stepSize * multiplier);
                        continue block12;
                    }
                    case 65: {
                        T.x = (float)((double)T.x + (double)this.stepSize * multiplier);
                        continue block12;
                    }
                    case 68: {
                        T.x = (float)((double)T.x - (double)this.stepSize * multiplier);
                        continue block12;
                    }
                    case 81: {
                        T.y = (float)((double)T.y - (double)this.stepSize * multiplier);
                        continue block12;
                    }
                    case 69: {
                        T.y = (float)((double)T.y + (double)this.stepSize * multiplier);
                        continue block12;
                    }
                    case 72: {
                        this.worldToCamera.reset();
                    }
                }
            }
        }
        this.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        this.prevX = e.getX();
        this.prevY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public synchronized void mouseDragged(MouseEvent e) {
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        rotY = (float)((double)rotY + (double)(e.getX() - this.prevX) * 0.002);
        rotX = (float)((double)rotX + (double)(this.prevY - e.getY()) * 0.002);
        Se3_F32 rotTran = new Se3_F32();
        ConvertRotation3D_F32.eulerToMatrix((EulerType)EulerType.XYZ, (float)rotX, (float)rotY, (float)rotZ, (FMatrixRMaj)rotTran.getR());
        Se3_F32 temp = this.worldToCamera.concat(rotTran, null);
        this.worldToCamera.set(temp);
        this.prevX = e.getX();
        this.prevY = e.getY();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public int getDotRadius() {
        return this.dotRadius;
    }

    public void setDotRadius(int dotRadius) {
        this.dotRadius = dotRadius;
    }

    private class KeypressedTask
    implements Runnable {
        private KeypressedTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Set set = PointCloudViewerPanelSwing.this.pressed;
            synchronized (set) {
                PointCloudViewerPanelSwing.this.handleKeyPress();
            }
        }
    }

    private class Keyboard
    implements KeyEventDispatcher {
        private Keyboard() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            block0 : switch (e.getID()) {
                case 401: {
                    switch (e.getKeyCode()) {
                        case 16: {
                            PointCloudViewerPanelSwing.this.shiftPressed = true;
                            break block0;
                        }
                    }
                    PointCloudViewerPanelSwing.this.pressed.add(e.getKeyCode());
                    break;
                }
                case 402: {
                    switch (e.getKeyCode()) {
                        case 16: {
                            PointCloudViewerPanelSwing.this.shiftPressed = false;
                            break block0;
                        }
                    }
                    if (PointCloudViewerPanelSwing.this.pressed.remove(e.getKeyCode())) break;
                    System.err.println("Possible Java / Mac OS X bug related to 'character accent menu' if using Java 1.8 try upgrading to 11");
                }
            }
            return false;
        }
    }
}

