/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.dialogs;

import boofcv.gui.BoofSwingUtil;
import boofcv.gui.dialogs.JSpringPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.DefaultCaret;

public class FileBrowser
extends JSpringPanel {
    JTextArea fileName;
    JComboBox directoryPath;
    JList fileList;
    DefaultListModel listModel = new DefaultListModel();
    List<File> directories = new ArrayList<File>();
    SortDirectoryFirst sorter = new SortDirectoryFirst();
    ActionListener directoryListener;
    Listener listener;

    public FileBrowser(File directory, final Listener listener) {
        this.listener = listener;
        directory = directory.getAbsoluteFile();
        if (directory.isDirectory() && directory.getName().equals(".")) {
            directory = directory.getParentFile();
        }
        this.fileName = new JTextArea();
        DefaultCaret caret = (DefaultCaret)this.fileName.getCaret();
        caret.setUpdatePolicy(2);
        this.fileName.setRows(1);
        this.fileName.setEditable(false);
        this.fileName.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JScrollPane nameScrollPane = new JScrollPane(this.fileName);
        nameScrollPane.setHorizontalScrollBarPolicy(31);
        nameScrollPane.setVerticalScrollBarPolicy(21);
        this.directoryPath = new JComboBox();
        this.fileList = new JList(this.listModel);
        this.fileList.setCellRenderer(new FileListCellRenderer());
        this.fileList.setSelectionMode(0);
        this.fileList.setLayoutOrientation(0);
        this.fileList.addListSelectionListener(new FileSelectionListener(this));
        this.fileList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    File selected = (File)FileBrowser.this.listModel.get(FileBrowser.this.fileList.getSelectedIndex());
                    if (selected.isDirectory()) {
                        FileBrowser.this.setDirectory(selected);
                    } else {
                        FileBrowser.this.setSelected(selected);
                        listener.handleClickedFile(selected);
                    }
                }
            }
        });
        JScrollPane scrollList = new JScrollPane(this.fileList);
        scrollList.setVerticalScrollBarPolicy(22);
        JPanel navigationPanel = this.createNavigationPanel();
        JPanel directoryRow = new JPanel();
        directoryRow.setLayout(new BoxLayout(directoryRow, 0));
        directoryRow.add(new JLabel("Location"));
        directoryRow.add(Box.createHorizontalStrut(5));
        directoryRow.add(this.directoryPath);
        this.constrainWestNorthEast(nameScrollPane, null, 5, 5);
        this.constrainWestNorthEast(directoryRow, nameScrollPane, 5, 5);
        this.constrainWestNorthEast(navigationPanel, directoryRow, 5, 5);
        this.constrainWestNorthEast(scrollList, navigationPanel, 5, 5);
        this.layout.putConstraint("South", (Component)scrollList, -5, "South", (Component)this);
        this.setDirectory(directory);
        this.directoryListener = e -> {
            if (this.directoryPath.getSelectedIndex() >= 0) {
                File f = this.directories.get(this.directoryPath.getSelectedIndex());
                this.setDirectory(f);
            }
        };
        this.directoryPath.addActionListener(this.directoryListener);
    }

    public void setSelectionMode(int mode) {
        this.fileList.setSelectionMode(mode);
    }

    private JPanel createNavigationPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JButton bHome = BoofSwingUtil.createButtonIconGUI("Home24.gif", 26, 26);
        bHome.setToolTipText("User Home");
        bHome.addActionListener(e -> this.setDirectory(BoofSwingUtil.directoryUserHome()));
        JButton bSystem = BoofSwingUtil.createButtonIconGUI("Host24.gif", 26, 26);
        bSystem.setToolTipText("System");
        bSystem.addActionListener(e -> this.setDirectory(null));
        JButton bPrevious = BoofSwingUtil.createButtonIconGUI("AlignCenter24.gif", 26, 26);
        bPrevious.setToolTipText("Previous");
        JButton bUp = BoofSwingUtil.createButtonIconGUI("Up24.gif", 26, 26);
        bUp.setToolTipText("Up Directory");
        bUp.addActionListener(e -> {
            File f = new File(this.fileName.getText());
            this.setDirectory(f.getParentFile());
        });
        panel.add(Box.createHorizontalGlue());
        panel.add(bHome);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(bSystem);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(bPrevious);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(bUp);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    public void setSelected(File file) {
        this.fileName.setText(file.getAbsolutePath());
    }

    public void setDirectory(File file) {
        ArrayList<File> roots = null;
        if (file == null) {
            roots = new ArrayList<File>(Arrays.asList(File.listRoots()));
            for (int i = roots.size() - 1; i >= 0; --i) {
                File[] files = ((File)roots.get(i)).listFiles();
                if (files != null && files.length != 0) continue;
                roots.remove(i);
            }
            if (roots.size() == 1) {
                file = (File)roots.get(0);
                roots = null;
            }
        }
        if (roots == null) {
            this.setDirectoryNormal(file);
        } else {
            this.fileName.setText("");
            this.listModel.clear();
            for (File f : roots) {
                this.listModel.addElement(f);
            }
            this.directoryPath.removeActionListener(this.directoryListener);
            this.directoryPath.removeAllItems();
            this.directoryPath.addActionListener(this.directoryListener);
            this.listener.handleSelectedFile(null);
        }
    }

    private void setDirectoryNormal(File file) {
        this.fileName.setText(file.getAbsolutePath());
        this.listModel.clear();
        File[] fileArray = file.listFiles();
        List<Object> files = fileArray == null ? new ArrayList() : Arrays.asList(fileArray);
        Collections.sort(files, this.sorter);
        for (File file2 : files) {
            if (file2.isHidden()) continue;
            this.listModel.addElement(file2);
        }
        if ((file = file.getAbsoluteFile()).isFile()) {
            file = file.getParentFile();
        }
        files = new ArrayList();
        while (file != null) {
            files.add(file);
            file = file.getParentFile();
        }
        this.directoryPath.removeActionListener(this.directoryListener);
        this.directoryPath.removeAllItems();
        this.directories.clear();
        for (int i = files.size() - 1; i >= 0; --i) {
            File file3 = (File)files.get(i);
            if (file3.getParentFile() == null) {
                try {
                    this.directoryPath.addItem(file3.getCanonicalPath());
                }
                catch (IOException e) {
                    this.directoryPath.addItem("/");
                }
            } else {
                this.directoryPath.addItem(((File)files.get(i)).getName());
            }
            this.directories.add(file3);
        }
        this.directoryPath.setSelectedIndex(files.size() - 1);
        this.directoryPath.addActionListener(this.directoryListener);
        this.listener.handleSelectedFile(null);
    }

    public List<File> getSelectedFiles() {
        List selected = this.fileList.getSelectedValuesList();
        ArrayList<File> out = new ArrayList<File>();
        for (int i = 0; i < selected.size(); ++i) {
            out.add((File)selected.get(i));
        }
        return out;
    }

    public static interface Listener {
        public void handleSelectedFile(File var1);

        public void handleClickedFile(File var1);
    }

    private class SortDirectoryFirst
    implements Comparator<File> {
        private SortDirectoryFirst() {
        }

        @Override
        public int compare(File a, File b) {
            if (a.isDirectory()) {
                if (b.isDirectory()) {
                    return a.getName().compareTo(b.getName());
                }
                return -1;
            }
            if (b.isDirectory()) {
                return 1;
            }
            return a.getName().compareTo(b.getName());
        }
    }

    private class FileSelectionListener
    implements ListSelectionListener {
        FileBrowser browser;

        public FileSelectionListener(FileBrowser browser) {
            this.browser = browser;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            JList fileList = (JList)e.getSource();
            DefaultListModel listModel = (DefaultListModel)fileList.getModel();
            int index = fileList.getSelectedIndex();
            if (index >= 0) {
                File f = (File)listModel.getElementAt(index);
                this.browser.setSelected(f);
                FileBrowser.this.listener.handleSelectedFile(f);
            } else {
                FileBrowser.this.listener.handleSelectedFile(null);
            }
        }
    }

    private class FileListCellRenderer
    extends DefaultListCellRenderer {
        private FileSystemView fileSystemView;
        private JLabel label;
        private Color textSelectionColor = Color.BLACK;
        private Color backgroundSelectionColor = Color.CYAN;
        private Color textNonSelectionColor = Color.BLACK;
        private Color backgroundNonSelectionColor = Color.WHITE;

        FileListCellRenderer() {
            this.label = new JLabel();
            this.label.setBorder(new EmptyBorder(2, 4, 2, 4));
            this.label.setOpaque(true);
            this.fileSystemView = FileSystemView.getFileSystemView();
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean expanded) {
            File file = (File)value;
            String name = this.fileSystemView.getSystemDisplayName(file);
            if (name.length() == 0) {
                name = file.getAbsolutePath();
            }
            this.label.setIcon(this.fileSystemView.getSystemIcon(file));
            this.label.setText(name);
            this.label.setToolTipText(file.getPath());
            if (selected) {
                this.label.setBackground(this.backgroundSelectionColor);
                this.label.setForeground(this.textSelectionColor);
            } else {
                this.label.setBackground(this.backgroundNonSelectionColor);
                this.label.setForeground(this.textNonSelectionColor);
            }
            return this.label;
        }
    }
}

