/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.gui.feature.VisualizeFeatures;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.gss.GaussianScaleSpace;
import boofcv.struct.image.ImageBase;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ScaleSpacePointPanel
extends JPanel {
    GaussianScaleSpace ss;
    BufferedImage background;
    List<ScalePoint> points = new ArrayList<ScalePoint>();
    List<ScalePoint> unused = new ArrayList<ScalePoint>();
    BufferedImage levelImage;
    List<ScalePoint> levelPoints = new ArrayList<ScalePoint>();
    int activeLevel = 0;
    double scaleToRadius;

    public ScaleSpacePointPanel(GaussianScaleSpace ss, double scaleToRadius) {
        this.ss = ss;
    }

    public void setBackground(BufferedImage background) {
        this.background = background;
        final int width = background.getWidth();
        final int height = background.getHeight();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScaleSpacePointPanel.this.setPreferredSize(new Dimension(width, height));
            }
        });
    }

    public synchronized void setPoints(List<ScalePoint> points) {
        this.unused.addAll(this.points);
        this.points.clear();
        this.activeLevel = 0;
        for (ScalePoint p : points) {
            if (this.unused.isEmpty()) {
                this.points.add(p.copy());
            } else {
                ScalePoint c = this.unused.remove(this.unused.size() - 1);
                c.set(p);
            }
            this.points.add(p);
        }
    }

    public synchronized void setLevel(int level) {
        if (level > 0) {
            this.ss.setActiveScale(level - 1);
            if (this.levelImage != null && (this.levelImage.getWidth() != this.background.getWidth() || this.levelImage.getHeight() != this.background.getHeight())) {
                this.levelImage = null;
            }
            this.levelImage = ConvertBufferedImage.convertTo((ImageBase)this.ss.getScaledImage(), (BufferedImage)this.levelImage, (boolean)true);
            double scale = this.ss.getCurrentScale();
            this.levelPoints.clear();
            for (ScalePoint p : this.points) {
                if (p.scale != scale) continue;
                this.levelPoints.add(p);
            }
        }
        this.activeLevel = level;
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        double scaleX = (double)this.background.getWidth() / (double)this.getWidth();
        double scaleY = (double)this.background.getHeight() / (double)this.getHeight();
        double scale = Math.max(scaleX, scaleY);
        if (scale > 1.0) {
            AffineTransform tran = g2.getTransform();
            tran.concatenate(AffineTransform.getScaleInstance(1.0 / scale, 1.0 / scale));
            g2.setTransform(tran);
        }
        if (this.activeLevel == 0) {
            this.showAll(g);
        } else {
            g2.drawImage(this.levelImage, 0, 0, this.levelImage.getWidth(), this.levelImage.getHeight(), null);
            VisualizeFeatures.drawScalePoints(g2, this.levelPoints, this.scaleToRadius);
        }
    }

    private void showAll(Graphics g) {
        if (this.background != null) {
            g.drawImage(this.background, 0, 0, this.background.getWidth(), this.background.getHeight(), null);
        }
        VisualizeFeatures.drawScalePoints((Graphics2D)g, this.points, this.scaleToRadius);
    }
}

