/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.io.image.UtilImageIO;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SaveImageOnClick
extends MouseAdapter {
    private static int saveCounter = 0;
    private static boolean hideSaveDialog = false;
    Component parent;

    public SaveImageOnClick(Component parent) {
        this.parent = parent;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        boolean clicked = SwingUtilities.isMiddleMouseButton(e);
        if (clicked |= e.isControlDown() && (e.getModifiersEx() & 0x100) != 0) {
            String fileName = String.format("saved_image%03d.png", saveCounter++);
            System.out.println("Image saved to " + new File(fileName).getAbsolutePath());
            BufferedImage output = this.getBufferedImage();
            UtilImageIO.saveImage((BufferedImage)output, (String)fileName);
            if (hideSaveDialog) {
                return;
            }
            Object[] options = new Object[]{"Hide in Future", "OK"};
            int n = JOptionPane.showOptionDialog(this.parent, "Saved image to " + fileName, "Middle Mouse Click Image Saving", 2, 3, null, options, options[1]);
            if (n == 0) {
                hideSaveDialog = true;
            }
        }
    }

    protected BufferedImage getBufferedImage() {
        BufferedImage output = new BufferedImage(this.parent.getWidth(), this.parent.getHeight(), 4);
        this.parent.paint(output.createGraphics());
        return output;
    }
}

