/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.misc.GImageStatistics;
import boofcv.alg.misc.ImageStatistics;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.ConvertRaster;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;

public class VisualizeImageData {
    public static BufferedImage standard(ImageGray<?> src, BufferedImage dst) {
        if (src.getDataType().isInteger()) {
            GrayI srcInt = (GrayI)src;
            if (src.getDataType().isSigned()) {
                dst = VisualizeImageData.checkInputs(src, dst);
                double max = GImageStatistics.maxAbs((ImageBase)srcInt);
                VisualizeImageData.colorizeSign(srcInt, dst, (int)max);
            } else if (src.getDataType().getNumBits() == 8) {
                dst = ConvertBufferedImage.convertTo((GrayU8)((GrayU8)src), (BufferedImage)dst);
            } else {
                double max = GImageStatistics.maxAbs((ImageBase)srcInt);
                dst = VisualizeImageData.grayUnsigned(srcInt, dst, (int)max);
            }
        } else if (GrayF32.class.isAssignableFrom(src.getClass())) {
            GrayF32 img = (GrayF32)src;
            float max = ImageStatistics.maxAbs((GrayF32)img);
            boolean hasNegative = false;
            block0: for (int i = 0; i < img.getHeight(); ++i) {
                for (int j = 0; j < img.getWidth(); ++j) {
                    if (!(img.get(j, i) < 0.0f)) continue;
                    hasNegative = true;
                    continue block0;
                }
            }
            if (hasNegative) {
                VisualizeImageData.colorizeSign(img, dst, (float)((int)max));
            } else {
                VisualizeImageData.grayMagnitude((GrayF32)src, dst, max);
            }
        }
        return dst;
    }

    public static BufferedImage colorizeSign(ImageGray src, BufferedImage dst, double normalize) {
        dst = VisualizeImageData.checkInputs((ImageBase)src, dst);
        if (normalize <= 0.0) {
            normalize = GImageStatistics.maxAbs((ImageBase)src);
        }
        if (normalize == 0.0) {
            ConvertBufferedImage.convertTo((ImageBase)src, (BufferedImage)dst, (boolean)true);
            return dst;
        }
        if (src.getClass().isAssignableFrom(GrayF32.class)) {
            VisualizeImageData.colorizeSign((GrayF32)src, dst, (float)normalize);
        } else {
            VisualizeImageData.colorizeSign((GrayI)src, dst, (int)normalize);
        }
        return dst;
    }

    private static void colorizeSign(GrayI src, BufferedImage dst, int normalize) {
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                int v = src.get(x, y);
                int rgb = v > 0 ? 255 * v / normalize << 16 : -(255 * v / normalize << 8);
                dst.setRGB(x, y, rgb);
            }
        }
    }

    public static BufferedImage grayUnsigned(GrayI src, BufferedImage dst, int normalize) {
        dst = VisualizeImageData.checkInputs((ImageBase)src, dst);
        if (src.getDataType().isSigned()) {
            throw new IllegalArgumentException("Can only convert unsigned images.");
        }
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                int v = src.get(x, y);
                int rgb = 255 * v / normalize;
                dst.setRGB(x, y, rgb << 16 | rgb << 8 | rgb);
            }
        }
        return dst;
    }

    public static BufferedImage grayMagnitude(ImageGray src, BufferedImage dst, double normalize) {
        if (normalize < 0.0) {
            normalize = GImageStatistics.maxAbs((ImageBase)src);
        }
        dst = VisualizeImageData.checkInputs((ImageBase)src, dst);
        if (src.getDataType().isInteger()) {
            VisualizeImageData.grayMagnitude((GrayI)src, dst, (int)normalize);
        } else if (src instanceof GrayF32) {
            VisualizeImageData.grayMagnitude((GrayF32)src, dst, (float)normalize);
        } else if (src instanceof GrayF64) {
            VisualizeImageData.grayMagnitude((GrayF64)src, dst, (double)((float)normalize));
        } else {
            throw new RuntimeException("Unsupported type");
        }
        return dst;
    }

    public static void grayMagnitudeTemp(ImageGray src, BufferedImage dst, double normalize) {
        if (normalize < 0.0) {
            normalize = GImageStatistics.maxAbs((ImageBase)src);
        }
        dst = VisualizeImageData.checkInputs((ImageBase)src, dst);
        if (!src.getDataType().isInteger()) {
            throw new RuntimeException("Add support");
        }
        VisualizeImageData.grayMagnitudeTemp((GrayI)src, dst, (int)normalize);
    }

    private static void grayMagnitude(GrayI src, BufferedImage dst, int maxValue) {
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                int v = Math.abs(src.get(x, y));
                int rgb = 255 * v / maxValue;
                dst.setRGB(x, y, rgb << 16 | rgb << 8 | rgb);
            }
        }
    }

    private static void grayMagnitudeTemp(GrayI src, BufferedImage dst, int maxValue) {
        int halfValue = maxValue / 2 + maxValue % 2;
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                int r;
                int b;
                int v = Math.abs(src.get(x, y));
                if (v == 0) {
                    b = 0;
                    r = 0;
                } else {
                    r = 255 * v / maxValue;
                    b = 255 * (maxValue - v) / maxValue;
                }
                dst.setRGB(x, y, r << 16 | b);
            }
        }
    }

    public static BufferedImage disparity(ImageGray disparity, BufferedImage dst, int minDisparity, int maxDisparity, int invalidColor) {
        if (dst == null) {
            dst = new BufferedImage(disparity.getWidth(), disparity.getHeight(), 1);
        }
        if (disparity.getDataType().isInteger()) {
            return VisualizeImageData.disparity((GrayI)disparity, dst, minDisparity, maxDisparity, invalidColor);
        }
        if (disparity instanceof GrayF32) {
            return VisualizeImageData.disparity((GrayF32)disparity, dst, minDisparity, maxDisparity, invalidColor);
        }
        throw new RuntimeException("Add support");
    }

    private static BufferedImage disparity(GrayI src, BufferedImage dst, int minValue, int maxValue, int invalidColor) {
        int range = maxValue - minValue;
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                int r;
                int b;
                int v = src.unsafe_get(x, y);
                if (v > range) {
                    dst.setRGB(x, y, invalidColor);
                    continue;
                }
                if (v == 0) {
                    b = 0;
                    r = 0;
                } else {
                    r = 255 * v / maxValue;
                    b = 255 * (maxValue - v) / maxValue;
                }
                dst.setRGB(x, y, r << 16 | b);
            }
        }
        return dst;
    }

    private static BufferedImage disparity(GrayF32 src, BufferedImage dst, int minValue, int maxValue, int invalidColor) {
        float range = maxValue - minValue;
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                int r;
                int b;
                float v = src.unsafe_get(x, y);
                if (v > range) {
                    dst.setRGB(x, y, invalidColor);
                    continue;
                }
                if (v == 0.0f) {
                    b = 0;
                    r = 0;
                } else {
                    r = (int)(255.0f * v / (float)maxValue);
                    b = (int)(255.0f * ((float)maxValue - v) / (float)maxValue);
                }
                dst.setRGB(x, y, r << 16 | b);
            }
        }
        return dst;
    }

    private static void colorizeSign(GrayF32 src, BufferedImage dst, float maxAbsValue) {
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                float v = src.get(x, y);
                int rgb = v > 0.0f ? (int)(255.0f * v / maxAbsValue) << 16 : (int)(-255.0f * v / maxAbsValue) << 8;
                dst.setRGB(x, y, rgb);
            }
        }
    }

    public static BufferedImage graySign(GrayF32 src, BufferedImage dst, float maxAbsValue) {
        dst = VisualizeImageData.checkInputs((ImageBase)src, dst);
        if (maxAbsValue < 0.0f) {
            maxAbsValue = ImageStatistics.maxAbs((GrayF32)src);
        }
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                float v = src.get(x, y);
                int rgb = 127 + (int)(127.0f * v / maxAbsValue);
                dst.setRGB(x, y, rgb << 16 | rgb << 8 | rgb);
            }
        }
        return dst;
    }

    private static void grayMagnitude(GrayF32 src, BufferedImage dst, float maxAbsValue) {
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                float v = Math.abs(src.get(x, y));
                int rgb = (int)(255.0f * v / maxAbsValue);
                dst.setRGB(x, y, rgb << 16 | rgb << 8 | rgb);
            }
        }
    }

    private static void grayMagnitude(GrayF64 src, BufferedImage dst, double maxAbsValue) {
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                double v = Math.abs(src.get(x, y));
                int rgb = (int)(255.0 * v / maxAbsValue);
                dst.setRGB(x, y, rgb << 16 | rgb << 8 | rgb);
            }
        }
    }

    private static BufferedImage checkInputs(ImageBase src, BufferedImage dst) {
        if (dst != null) {
            if (dst.getWidth() != src.getWidth() || dst.getHeight() != src.getHeight()) {
                dst = new BufferedImage(src.getWidth(), src.getHeight(), 1);
            }
        } else {
            dst = new BufferedImage(src.getWidth(), src.getHeight(), 1);
        }
        return dst;
    }

    public static BufferedImage colorizeGradient(ImageGray derivX, ImageGray derivY, double maxAbsValue, BufferedImage output) {
        if (derivX instanceof GrayS16) {
            return VisualizeImageData.colorizeGradient((GrayS16)derivX, (GrayS16)derivY, (int)maxAbsValue, output);
        }
        if (derivX instanceof GrayF32) {
            return VisualizeImageData.colorizeGradient((GrayF32)derivX, (GrayF32)derivY, (float)maxAbsValue, output);
        }
        throw new IllegalArgumentException("Image type not supported");
    }

    public static BufferedImage colorizeGradient(GrayS16 derivX, GrayS16 derivY, int maxAbsValue, BufferedImage output) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY);
        if (output == null) {
            output = new BufferedImage(derivX.width, derivX.height, 1);
        }
        WritableRaster raster = output.getRaster();
        DataBufferInt buffer = (DataBufferInt)raster.getDataBuffer();
        int[] outData = buffer.getData();
        int outOffset = ConvertRaster.getOffset((WritableRaster)raster);
        if (maxAbsValue < 0) {
            maxAbsValue = ImageStatistics.maxAbs((GrayS16)derivX);
            maxAbsValue = Math.max(maxAbsValue, ImageStatistics.maxAbs((GrayS16)derivY));
        }
        if (maxAbsValue == 0) {
            return output;
        }
        int indexOut = outOffset;
        for (int y = 0; y < derivX.height; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            for (int x = 0; x < derivX.width; ++x) {
                short valueX = derivX.data[indexX++];
                short valueY = derivY.data[indexY++];
                int r = 0;
                int g = 0;
                int b = 0;
                if (valueX > 0) {
                    r = 255 * valueX / maxAbsValue;
                } else {
                    g = -255 * valueX / maxAbsValue;
                }
                if (valueY > 0) {
                    b = 255 * valueY / maxAbsValue;
                } else {
                    int v = -255 * valueY / maxAbsValue;
                    g += v;
                    if ((r += v) > 255) {
                        r = 255;
                    }
                    if (g > 255) {
                        g = 255;
                    }
                }
                outData[indexOut++] = r << 16 | g << 8 | b;
            }
        }
        return output;
    }

    public static BufferedImage colorizeGradient(GrayF32 derivX, GrayF32 derivY, float maxAbsValue, BufferedImage output) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY);
        if (output == null) {
            output = new BufferedImage(derivX.width, derivX.height, 1);
        }
        WritableRaster raster = output.getRaster();
        DataBufferInt buffer = (DataBufferInt)raster.getDataBuffer();
        int[] outData = buffer.getData();
        int outOffset = ConvertRaster.getOffset((WritableRaster)raster);
        if (maxAbsValue < 0.0f) {
            maxAbsValue = ImageStatistics.maxAbs((GrayF32)derivX);
            maxAbsValue = Math.max(maxAbsValue, ImageStatistics.maxAbs((GrayF32)derivY));
        }
        if (maxAbsValue == 0.0f) {
            return output;
        }
        int indexOut = outOffset;
        for (int y = 0; y < derivX.height; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            for (int x = 0; x < derivX.width; ++x) {
                float valueX = derivX.data[indexX++];
                float valueY = derivY.data[indexY++];
                int r = 0;
                int g = 0;
                int b = 0;
                if (valueX > 0.0f) {
                    r = (int)(255.0f * valueX / maxAbsValue);
                } else {
                    g = -((int)(255.0f * valueX / maxAbsValue));
                }
                if (valueY > 0.0f) {
                    b = (int)(255.0f * valueY / maxAbsValue);
                } else {
                    int v = -((int)(255.0f * valueY / maxAbsValue));
                    g += v;
                    if ((r += v) > 255) {
                        r = 255;
                    }
                    if (g > 255) {
                        g = 255;
                    }
                }
                outData[indexOut++] = r << 16 | g << 8 | b;
            }
        }
        return output;
    }
}

