/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.calibration;

import boofcv.alg.distort.AdjustmentType;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.alg.distort.LensDistortionOps_F32;
import boofcv.alg.feature.detect.chess.ChessboardCorner;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.gui.calibration.DisplayCalibrationPanel;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.border.BorderType;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrixRMaj;
import org.ejml.ops.ConvertMatrixData;

public class DisplayPinholeCalibrationPanel
extends DisplayCalibrationPanel<CameraPinholeBrown> {
    int selectedImage;
    BufferedImage distorted;
    BufferedImage undistorted;
    boolean isUndistorted = false;
    Planar<GrayF32> origMS = new Planar(GrayF32.class, 1, 1, 3);
    Planar<GrayF32> correctedMS = new Planar(GrayF32.class, 1, 1, 3);
    ImageDistort<GrayF32, GrayF32> undoRadial;
    Point2Transform2_F32 remove_p_to_p;
    int lineY = -1;

    @Override
    public void setImage(BufferedImage image) {
        this.distorted = image;
        this.undoRadialDistortion(this.distorted);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.img = this.showUndistorted ? this.undistorted : this.distorted;
        super.paintComponent(g);
    }

    @Override
    protected void paintInPanel(AffineTransform tran, Graphics2D g2) {
        if (this.features != null && this.features.size() > this.selectedImage) {
            this.drawFeatures(g2, this.scale);
        }
        if (this.lineY > -1) {
            g2.setColor(Color.RED);
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawLine(0, this.lineY, this.getWidth(), this.lineY);
        }
    }

    private void undoRadialDistortion(BufferedImage image) {
        if (this.undoRadial == null) {
            return;
        }
        ConvertBufferedImage.convertFrom((BufferedImage)image, this.origMS, (boolean)true);
        if (this.correctedMS.getNumBands() != this.origMS.getNumBands()) {
            this.correctedMS.setNumberOfBands(this.origMS.getNumBands());
        }
        this.correctedMS.reshape(this.origMS.width, this.origMS.height);
        for (int i = 0; i < this.origMS.getNumBands(); ++i) {
            GrayF32 in = (GrayF32)this.origMS.getBand(i);
            GrayF32 out = (GrayF32)this.correctedMS.getBand(i);
            this.undoRadial.apply((ImageBase)in, (ImageBase)out);
        }
        this.undistorted = ConvertBufferedImage.checkDeclare((int)this.origMS.width, (int)this.origMS.height, (BufferedImage)this.undistorted, (int)image.getType());
        ConvertBufferedImage.convertTo(this.correctedMS, (BufferedImage)this.undistorted, (boolean)true);
    }

    private void drawFeatures(Graphics2D g2, double scale) {
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        CalibrationObservation set = this.features;
        Ellipse2D.Double ellipse = new Ellipse2D.Double();
        Point2D_F32 adj = new Point2D_F32();
        if (this.showOrder) {
            Iterator<Point2D_F64> adjusted;
            if (this.showUndistorted) {
                adjusted = new ArrayList<Point2D_F64>();
                for (Object p : set.points) {
                    this.remove_p_to_p.compute((float)((PointIndex2D_F64)p).x, (float)((PointIndex2D_F64)p).y, adj);
                    adjusted.add(new Point2D_F64((double)adj.x, (double)adj.y));
                }
            } else {
                adjusted = set.points;
            }
            DisplayPinholeCalibrationPanel.renderOrder(g2, scale, adjusted);
        }
        if (this.showPoints) {
            g2.setColor(Color.BLACK);
            g2.setStroke(new BasicStroke(3.0f));
            for (PointIndex2D_F64 p : set.points) {
                if (this.showUndistorted) {
                    this.remove_p_to_p.compute((float)p.x, (float)p.y, adj);
                } else {
                    adj.set((float)p.x, (float)p.y);
                }
                VisualizeFeatures.drawCross(g2, (double)adj.x * scale, (double)adj.y * scale, 4.0);
            }
            g2.setStroke(new BasicStroke(1.0f));
            g2.setColor(Color.RED);
            for (PointIndex2D_F64 p : set.points) {
                if (this.showUndistorted) {
                    this.remove_p_to_p.compute((float)p.x, (float)p.y, adj);
                } else {
                    adj.set((float)p.x, (float)p.y);
                }
                VisualizeFeatures.drawCross(g2, (double)adj.x * scale, (double)adj.y * scale, 4.0);
            }
        }
        if (this.showAll) {
            for (CalibrationObservation l : this.allFeatures) {
                for (PointIndex2D_F64 p : l.points) {
                    if (this.showUndistorted) {
                        this.remove_p_to_p.compute((float)p.x, (float)p.y, adj);
                    } else {
                        adj.set((float)p.x, (float)p.y);
                    }
                    VisualizeFeatures.drawPoint(g2, (double)adj.x * scale, (double)adj.y * scale, 3.0, Color.BLUE, Color.WHITE, ellipse);
                }
            }
        }
        if (this.showNumbers) {
            if (this.showUndistorted) {
                DisplayPinholeCalibrationPanel.drawNumbers(g2, set.points, this.remove_p_to_p, scale);
            } else {
                DisplayPinholeCalibrationPanel.drawNumbers(g2, set.points, null, scale);
            }
        }
        if (this.showErrors && this.results != null) {
            for (int i = 0; i < set.size(); ++i) {
                PointIndex2D_F64 p;
                p = set.get(i);
                if (this.showUndistorted) {
                    this.remove_p_to_p.compute((float)p.x, (float)p.y, adj);
                } else {
                    adj.set((float)p.x, (float)p.y);
                }
                double r = scale * this.errorScale * this.results.pointError[i];
                if (r < 1.0) continue;
                g2.setStroke(new BasicStroke(4.0f));
                g2.setColor(Color.BLACK);
                VisualizeFeatures.drawCircle(g2, (double)adj.x * scale, (double)adj.y * scale, r, ellipse);
                g2.setStroke(new BasicStroke(2.5f));
                g2.setColor(Color.ORANGE);
                VisualizeFeatures.drawCircle(g2, (double)adj.x * scale, (double)adj.y * scale, r, ellipse);
            }
        }
    }

    public static void renderOrder(Graphics2D g2, double scale, List<Point2D_F64> points) {
        g2.setStroke(new BasicStroke(5.0f));
        Line2D.Double l = new Line2D.Double();
        int i = 0;
        int j = 1;
        while (j < points.size()) {
            Point2D_F64 p0 = points.get(i);
            Point2D_F64 p1 = points.get(j);
            double fraction = (double)i / ((double)points.size() - 2.0);
            int red = (int)(255.0 * fraction) + (int)(0.0 * (1.0 - fraction));
            int green = 0;
            int blue = (int)(0.0 * fraction) + (int)(255.0 * (1.0 - fraction));
            int lineRGB = red << 16 | green << 8 | blue;
            l.setLine(scale * p0.x, scale * p0.y, scale * p1.x, scale * p1.y);
            g2.setColor(new Color(lineRGB));
            g2.draw(l);
            i = j++;
        }
    }

    @Override
    public void setCalibration(CameraPinholeBrown param) {
        CameraPinhole undistorted = new CameraPinhole((CameraPinhole)param);
        this.undoRadial = LensDistortionOps.changeCameraModel((AdjustmentType)AdjustmentType.FULL_VIEW, (BorderType)BorderType.ZERO, (CameraPinhole)param, (CameraPinhole)undistorted, null, (ImageType)ImageType.single(GrayF32.class));
        this.remove_p_to_p = LensDistortionOps_F32.transformChangeModel((AdjustmentType)AdjustmentType.FULL_VIEW, (CameraPinhole)param, (CameraPinhole)undistorted, (boolean)false, null);
        this.undoRadialDistortion(this.distorted);
    }

    public void setCalibration(CameraPinholeBrown param, DMatrixRMaj rect) {
        FMatrixRMaj rect_f32 = new FMatrixRMaj(3, 3);
        ConvertMatrixData.convert((DMatrixRMaj)rect, (FMatrixRMaj)rect_f32);
        this.undoRadial = RectifyImageOps.rectifyImage((CameraPinholeBrown)param, (FMatrixRMaj)rect_f32, (BorderType)BorderType.ZERO, (ImageType)ImageType.single(GrayF32.class));
        this.remove_p_to_p = RectifyImageOps.transformPixelToRect((CameraPinholeBrown)param, (FMatrixRMaj)rect_f32);
    }

    public void setLine(int y) {
        this.lineY = y;
    }

    public static void drawNumbers(Graphics2D g2, List<PointIndex2D_F64> points, Point2Transform2_F32 transform, double scale) {
        Font regular = new Font("Serif", 0, 16);
        g2.setFont(regular);
        Point2D_F32 adj = new Point2D_F32();
        AffineTransform origTran = g2.getTransform();
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F64 p = (Point2D_F64)points.get(i);
            int gridIndex = points.get((int)i).index;
            if (transform != null) {
                transform.compute((float)p.x, (float)p.y, adj);
            } else {
                adj.set((float)p.x, (float)p.y);
            }
            String text = String.format("%2d", gridIndex);
            int x = (int)((double)adj.x * scale);
            int y = (int)((double)adj.y * scale);
            g2.setColor(Color.BLACK);
            g2.drawString(text, x - 1, y);
            g2.drawString(text, x + 1, y);
            g2.drawString(text, x, y - 1);
            g2.drawString(text, x, y + 1);
            g2.setTransform(origTran);
            g2.setColor(Color.GREEN);
            g2.drawString(text, x, y);
        }
    }

    public static void drawIndexes(Graphics2D g2, int fontSize, List<Point2D_F64> points, Point2Transform2_F32 transform, double scale) {
        int numDigits = BoofMiscOps.numDigits((int)points.size());
        String format = "%" + numDigits + "d";
        Font regular = new Font("Serif", 0, fontSize);
        g2.setFont(regular);
        Point2D_F32 adj = new Point2D_F32();
        AffineTransform origTran = g2.getTransform();
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F64 p = points.get(i);
            if (transform != null) {
                transform.compute((float)p.x, (float)p.y, adj);
            } else {
                adj.set((float)p.x, (float)p.y);
            }
            String text = String.format(format, i);
            int x = (int)((double)adj.x * scale);
            int y = (int)((double)adj.y * scale);
            g2.setColor(Color.BLACK);
            g2.drawString(text, x - 1, y);
            g2.drawString(text, x + 1, y);
            g2.drawString(text, x, y - 1);
            g2.drawString(text, x, y + 1);
            g2.setTransform(origTran);
            g2.setColor(Color.GREEN);
            g2.drawString(text, x, y);
        }
    }

    public static void drawIndexes(Graphics2D g2, int fontSize, List<ChessboardCorner> points, Point2Transform2_F32 transform, int minLevel, double scale) {
        int numDigits = BoofMiscOps.numDigits((int)points.size());
        String format = "%" + numDigits + "d";
        Font regular = new Font("Serif", 0, fontSize);
        g2.setFont(regular);
        Point2D_F32 adj = new Point2D_F32();
        AffineTransform origTran = g2.getTransform();
        for (int i = 0; i < points.size(); ++i) {
            ChessboardCorner p = points.get(i);
            if (p.level2 < minLevel) continue;
            if (transform != null) {
                transform.compute((float)p.x, (float)p.y, adj);
            } else {
                adj.set((float)p.x, (float)p.y);
            }
            String text = String.format(format, i);
            int x = (int)((double)adj.x * scale);
            int y = (int)((double)adj.y * scale);
            g2.setColor(Color.BLACK);
            g2.drawString(text, x - 1, y);
            g2.drawString(text, x + 1, y);
            g2.drawString(text, x, y - 1);
            g2.drawString(text, x, y + 1);
            g2.setTransform(origTran);
            g2.setColor(Color.GREEN);
            g2.drawString(text, x, y);
        }
    }
}

