/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.calibration;

import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.abst.geo.calibration.ImageResults;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.calibration.CalibratedPlanarPanel;
import boofcv.gui.calibration.DisplayPinholeCalibrationPanel;
import boofcv.struct.calib.CameraPinholeBrown;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;

public class MonoPlanarPanel
extends CalibratedPlanarPanel<CameraPinholeBrown>
implements ItemListener,
ChangeListener {
    JTextArea paramCenterX;
    JTextArea paramCenterY;
    JTextArea paramFX;
    JTextArea paramFY;
    JTextArea paramSkew;
    JTextArea paramRadial;
    JTextArea paramTangental;

    public MonoPlanarPanel() {
        this.viewInfo.setListener(zoom -> this.mainView.setScale(zoom));
        this.mainView = new DisplayPinholeCalibrationPanel();
        this.mainView.getImagePanel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                double scale = MonoPlanarPanel.this.viewInfo.getZoom();
                MonoPlanarPanel.this.viewInfo.setCursor((double)e.getX() / scale, (double)e.getY() / scale);
            }
        });
        this.imageList = new JList();
        this.imageList.setSelectionMode(0);
        this.imageList.addListSelectionListener(this);
        this.meanError = this.createErrorComponent(1);
        this.maxError = this.createErrorComponent(1);
        this.paramCenterX = this.createErrorComponent(1);
        this.paramCenterY = this.createErrorComponent(1);
        this.paramFX = this.createErrorComponent(1);
        this.paramFY = this.createErrorComponent(1);
        this.paramSkew = this.createErrorComponent(1);
        this.paramRadial = this.createErrorComponent(2);
        this.paramTangental = this.createErrorComponent(2);
        this.mainView.setDisplay(this.showPoints, this.showErrors, this.showUndistorted, this.showAll, this.showNumbers, this.showOrder, this.errorScale);
        this.mainView.addMouseWheelListener(this.viewInfo);
        this.add((Component)this.mainView, "Center");
        this.add((Component)new LeftPanel(), "West");
        this.add((Component)new CalibratedPlanarPanel.RightPanel(), "East");
    }

    @Override
    public void setObservations(List<CalibrationObservation> features) {
        this.features = features;
    }

    @Override
    public void setResults(List<ImageResults> results) {
        this.results = results;
        this.setSelected(this.selectedImage);
    }

    @Override
    public void setCalibration(CameraPinholeBrown intrinsic, SceneStructureMetric scene) {
        String textX = String.format("%5.1f", intrinsic.cx);
        String textY = String.format("%5.1f", intrinsic.cy);
        this.paramCenterX.setText(textX);
        this.paramCenterY.setText(textY);
        String textA = String.format("%5.1f", intrinsic.fx);
        String textB = String.format("%5.1f", intrinsic.fy);
        this.paramFX.setText(textA);
        this.paramFY.setText(textB);
        if (intrinsic.skew == 0.0) {
            this.paramSkew.setText("");
        } else {
            String textC = String.format("%5.1e", intrinsic.skew);
            this.paramSkew.setText(textC);
        }
        String radial = "";
        if (intrinsic.radial != null) {
            for (int i = 0; i < intrinsic.radial.length; ++i) {
                radial = radial + String.format("%5.2e", intrinsic.radial[i]);
                if (i == intrinsic.radial.length - 1) continue;
                radial = radial + "\n";
            }
        }
        this.paramRadial.setText(radial);
        if (intrinsic.t1 != 0.0 && intrinsic.t2 != 0.0) {
            this.paramTangental.setText(String.format("%5.2e\n%5.2e", intrinsic.t1, intrinsic.t2));
        } else {
            this.paramTangental.setText("");
        }
    }

    @Override
    public void setCorrection(CameraPinholeBrown param) {
        this.checkUndistorted.setEnabled(true);
        this.mainView.setCalibration(param);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.checkPoints) {
            this.showPoints = this.checkPoints.isSelected();
        } else if (e.getSource() == this.checkErrors) {
            this.showErrors = this.checkErrors.isSelected();
        } else if (e.getSource() == this.checkAll) {
            this.showAll = this.checkAll.isSelected();
        } else if (e.getSource() == this.checkUndistorted) {
            this.showUndistorted = this.checkUndistorted.isSelected();
        } else if (e.getSource() == this.checkNumbers) {
            this.showNumbers = this.checkNumbers.isSelected();
        } else if (e.getSource() == this.checkOrder) {
            this.showOrder = this.checkOrder.isSelected();
        }
        this.mainView.setDisplay(this.showPoints, this.showErrors, this.showUndistorted, this.showAll, this.showNumbers, this.showOrder, this.errorScale);
        this.mainView.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting() || e.getFirstIndex() == -1) {
            return;
        }
        if (this.imageList.getSelectedIndex() >= 0) {
            this.setSelected(this.imageList.getSelectedIndex());
            this.mainView.repaint();
        }
    }

    @Override
    protected void updateResultsGUI() {
        if (this.selectedImage < this.results.size()) {
            ImageResults r = (ImageResults)this.results.get(this.selectedImage);
            String textMean = String.format("%5.1e", r.meanError);
            String textMax = String.format("%5.1e", r.maxError);
            this.meanError.setText(textMean);
            this.maxError.setText(textMax);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.selectErrorScale) {
            this.errorScale = ((Number)this.selectErrorScale.getValue()).intValue();
        }
        this.mainView.setDisplay(this.showPoints, this.showErrors, this.showUndistorted, this.showAll, this.showNumbers, this.showOrder, this.errorScale);
        this.mainView.repaint();
    }

    private class LeftPanel
    extends StandardAlgConfigPanel {
        public LeftPanel() {
            JScrollPane scroll = new JScrollPane(MonoPlanarPanel.this.imageList);
            LeftPanel.addLabeled(MonoPlanarPanel.this.meanError, "Mean Error", this);
            LeftPanel.addLabeled(MonoPlanarPanel.this.maxError, "Max Error", this);
            this.addSeparator(200);
            LeftPanel.addLabeled(MonoPlanarPanel.this.paramCenterX, "Xc", this);
            LeftPanel.addLabeled(MonoPlanarPanel.this.paramCenterY, "Yc", this);
            LeftPanel.addLabeled(MonoPlanarPanel.this.paramFX, "fx", this);
            LeftPanel.addLabeled(MonoPlanarPanel.this.paramFY, "fy", this);
            LeftPanel.addLabeled(MonoPlanarPanel.this.paramSkew, "skew", this);
            LeftPanel.addLabeled(MonoPlanarPanel.this.paramRadial, "radial", this);
            LeftPanel.addLabeled(MonoPlanarPanel.this.paramTangental, "tangential", this);
            this.addSeparator(200);
            this.add(scroll);
        }
    }
}

