/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.d2;

import boofcv.gui.BoofSwingUtil;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se2_F64;
import georegression.transform.se.SePointOps_F64;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.ddogleg.struct.FastQueue;

public class PlaneView2D
extends JPanel
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener {
    FastQueue<Point2D_F64> points = new FastQueue(Point2D_F64.class, true);
    Se2_F64 transform = new Se2_F64();
    double scale = 1.0;
    Point2D_F64 a = new Point2D_F64();
    int prevX;
    int prevY;
    double pixelToUnit;

    public PlaneView2D(double pixelToUnit) {
        this.pixelToUnit = pixelToUnit;
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    public void reset() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlaneView2D.this.points.reset();
            }
        });
    }

    public void addPoint(final double x, final double y) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((Point2D_F64)PlaneView2D.this.points.grow()).set(x, y);
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int offsetX = this.getWidth() / 2;
        int offsetY = this.getHeight() / 2;
        int H = this.getHeight() - 1;
        int r = 2;
        int w = 2 * r + 1;
        for (Point2D_F64 p : this.points.toList()) {
            SePointOps_F64.transform((Se2_F64)this.transform, (Point2D_F64)p, (Point2D_F64)this.a);
            this.a.x *= this.scale / this.pixelToUnit;
            this.a.y *= this.scale / this.pixelToUnit;
            g2.fillOval(offsetX + (int)this.a.x, H - (offsetY + (int)this.a.y), w, w);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double scale = BoofSwingUtil.mouseWheelImageZoom(this.scale, e);
        if (scale == this.scale) {
            return;
        }
        if (scale < 0.001) {
            scale = 0.001;
        } else if (scale > 1000.0) {
            scale = 1000.0;
        }
        this.scale = scale;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.grabFocus();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.prevX = e.getX();
        this.prevY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int deltaX = e.getX() - this.prevX;
        int deltaY = e.getY() - this.prevY;
        this.transform.T.x += (double)deltaX * this.pixelToUnit / this.scale;
        this.transform.T.y -= (double)deltaY * this.pixelToUnit / this.scale;
        this.prevX = e.getX();
        this.prevY = e.getY();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == 'w') {
            this.transform.T.y -= this.pixelToUnit / this.scale;
        } else if (e.getKeyChar() == 's') {
            this.transform.T.y += this.pixelToUnit / this.scale;
        } else if (e.getKeyChar() == 'a') {
            this.transform.T.x += this.pixelToUnit / this.scale;
        } else if (e.getKeyChar() == 'd') {
            this.transform.T.x -= this.pixelToUnit / this.scale;
        } else if (e.getKeyChar() == 'q') {
            this.scale *= 1.05;
        } else if (e.getKeyChar() == 'e') {
            this.scale *= 0.95;
        } else if (e.getKeyChar() == 'h') {
            this.transform.reset();
            this.scale = 1.0;
        }
        if (this.scale < 0.001) {
            this.scale = 0.001;
        } else if (this.scale > 1000.0) {
            this.scale = 1000.0;
        }
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

