/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class AnimatePanel
extends JPanel {
    BufferedImage[] images;
    long previousTime;
    int period;
    int frame;
    Timer timer;

    public AnimatePanel(int period, BufferedImage ... images) {
        this.period = period;
        if (images.length > 0) {
            this.images = images;
            this.setPreferredSize(new Dimension(images[0].getWidth(), images[0].getHeight()));
        }
    }

    public void setAnimation(BufferedImage ... images) {
        if (images.length == 0) {
            throw new IllegalArgumentException("Can't be of length 0");
        }
        this.frame = 0;
        this.images = images;
    }

    public AnimatePanel start() {
        if (this.timer != null) {
            throw new IllegalArgumentException("Already running");
        }
        this.timer = new Timer();
        this.timer.start();
        return this;
    }

    public void stop() {
        this.timer.running = false;
        this.timer = null;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.images == null) {
            return;
        }
        if (this.previousTime <= System.currentTimeMillis()) {
            this.previousTime = System.currentTimeMillis() + (long)this.period - 1L;
            this.frame = (this.frame + 1) % this.images.length;
        }
        g2.drawImage((Image)this.images[this.frame], 0, 0, this);
    }

    private class Timer
    extends Thread {
        public volatile boolean running = true;

        private Timer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AnimatePanel.this.previousTime = 0L;
            Timer timer = this;
            synchronized (timer) {
                while (this.running) {
                    try {
                        this.wait(AnimatePanel.this.period);
                        AnimatePanel.this.repaint();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

