/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.gui.BoofSwingUtil;
import boofcv.gui.image.SaveImageOnClick;
import boofcv.gui.image.ScaleOptions;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ImagePanel
extends JPanel {
    protected BufferedImage img;
    protected ScaleOptions scaling = ScaleOptions.DOWN;
    public double scale = 1.0;
    public double offsetX = 0.0;
    public double offsetY = 0.0;
    private ScaleOffset adjustmentGUI = new ScaleOffset();
    protected SaveImageOnClick mouseListener;
    protected AffineTransform transform = new AffineTransform();
    private boolean center = false;

    public ImagePanel(BufferedImage img) {
        this(img, ScaleOptions.NONE);
    }

    public ImagePanel(BufferedImage img, ScaleOptions scaling) {
        this(true);
        this.img = img;
        this.scaling = scaling;
        this.autoSetPreferredSize();
    }

    public ImagePanel(int width, int height) {
        this(true);
        this.setPreferredSize(new Dimension(width, height));
    }

    public ImagePanel(boolean addMouseListener) {
        if (addMouseListener) {
            this.addClickToSaveListener();
        }
    }

    public ImagePanel() {
        this(true);
    }

    public void addClickToSaveListener() {
        this.mouseListener = new SaveImageOnClick(this);
        this.addMouseListener(this.mouseListener);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform original = g2.getTransform();
        this.configureDrawImageGraphics(g2);
        BufferedImage img = this.img;
        if (img != null) {
            this.computeOffsetAndScale(img, this.adjustmentGUI);
            this.scale = this.adjustmentGUI.scale;
            this.offsetX = this.adjustmentGUI.offsetX;
            this.offsetY = this.adjustmentGUI.offsetY;
            if (this.scale == 1.0) {
                g2.drawImage((Image)img, (int)this.offsetX, (int)this.offsetY, this);
            } else {
                this.transform.setTransform(this.scale, 0.0, 0.0, this.scale, this.offsetX, this.offsetY);
                g2.drawImage(img, this.transform, null);
            }
        }
        g2.setTransform(original);
    }

    protected void configureDrawImageGraphics(Graphics2D g2) {
    }

    private void computeOffsetAndScale(BufferedImage img, ScaleOffset so) {
        if (this.scaling != ScaleOptions.NONE) {
            if (this.scaling == ScaleOptions.MANUAL) {
                so.scale = this.scale;
            } else {
                double ratioW = (double)this.getWidth() / (double)img.getWidth();
                double ratioH = (double)this.getHeight() / (double)img.getHeight();
                so.scale = Math.min(ratioW, ratioH);
                if (this.scaling == ScaleOptions.DOWN && so.scale >= 1.0) {
                    so.scale = 1.0;
                }
            }
            if (this.center) {
                so.offsetX = ((double)this.getWidth() - (double)img.getWidth() * so.scale) / 2.0;
                so.offsetY = ((double)this.getHeight() - (double)img.getHeight() * so.scale) / 2.0;
            } else {
                so.offsetX = 0.0;
                so.offsetY = 0.0;
            }
            if (this.scale == 1.0) {
                so.offsetX = (int)so.offsetX;
                so.offsetY = (int)so.offsetY;
            }
        } else {
            if (this.center) {
                so.offsetX = (this.getWidth() - img.getWidth()) / 2;
                so.offsetY = (this.getHeight() - img.getHeight()) / 2;
            } else {
                so.offsetX = 0.0;
                so.offsetY = 0.0;
            }
            so.scale = 1.0;
        }
    }

    public void setImage(BufferedImage image) {
        this.img = image;
    }

    public void setImageRepaint(BufferedImage image) {
        ScaleOffset workspace = SwingUtilities.isEventDispatchThread() ? this.adjustmentGUI : new ScaleOffset();
        this.repaintJustImage(this.img, workspace);
        this.img = image;
        if (image != null) {
            this.repaintJustImage(this.img, workspace);
        } else {
            this.repaint();
        }
    }

    public void setImageUI(BufferedImage image) {
        BoofSwingUtil.invokeNowOrLater(() -> {
            this.repaintJustImage(this.img, this.adjustmentGUI);
            this.img = image;
            this.repaintJustImage(this.img, this.adjustmentGUI);
        });
    }

    public boolean isCentered() {
        return this.center;
    }

    public void setCentering(boolean center) {
        this.center = center;
    }

    public void repaintJustImage() {
        this.repaintJustImage(this.img, new ScaleOffset());
    }

    protected void repaintJustImage(BufferedImage img, ScaleOffset workspace) {
        if (img == null) {
            this.repaint();
            return;
        }
        this.computeOffsetAndScale(img, workspace);
        this.repaint((int)Math.round(workspace.offsetX) - 1, (int)Math.round(workspace.offsetY) - 1, (int)((double)img.getWidth() * workspace.scale + 0.5) + 2, (int)((double)img.getHeight() * workspace.scale + 0.5) + 2);
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public void setScaling(ScaleOptions scaling) {
        this.scaling = scaling;
    }

    public void autoSetPreferredSize() {
        this.setPreferredSize(new Dimension(this.img.getWidth(), this.img.getHeight()));
    }

    public MouseListener getMouseClickToSaveListener() {
        return this.mouseListener;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    private static class ScaleOffset {
        double scale;
        double offsetX;
        double offsetY;

        private ScaleOffset() {
        }
    }
}

