/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.tracker;

import boofcv.alg.tracker.tld.TldHelperFunctions;
import boofcv.alg.tracker.tld.TldRegion;
import boofcv.alg.tracker.tld.TldTracker;
import boofcv.gui.tracker.TldTemplatePanel;
import boofcv.struct.ImageRectangle;
import georegression.struct.shapes.Rectangle2D_F64;
import georegression.struct.shapes.Rectangle2D_I32;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.ddogleg.struct.FastQueue;

public class TldVisualizationPanel
extends JPanel
implements MouseListener {
    BufferedImage frame;
    CenterPanel centerPanel = new CenterPanel();
    Listener listener;
    int numClicks;
    ImageRectangle selected = new ImageRectangle();
    boolean hasSelected = false;
    FastQueue<TldRegion> detections = new FastQueue(TldRegion::new);
    TldTemplatePanel positivePanel = new TldTemplatePanel(15);
    TldTemplatePanel negativePanel = new TldTemplatePanel(15);

    public TldVisualizationPanel(Listener listener) {
        this.setLayout(new BorderLayout());
        this.listener = listener;
        JScrollPane scrollPositive = new JScrollPane(this.positivePanel);
        scrollPositive.setVerticalScrollBarPolicy(22);
        JScrollPane scrollNegative = new JScrollPane(this.negativePanel);
        scrollNegative.setVerticalScrollBarPolicy(22);
        this.add((Component)scrollPositive, "West");
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)scrollNegative, "East");
        this.centerPanel.addMouseListener(this);
        this.centerPanel.grabFocus();
    }

    public void setSelectRectangle(boolean value) {
        this.numClicks = value ? 0 : 2;
    }

    public void setFrame(final BufferedImage frame) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TldVisualizationPanel.this.frame = frame;
                TldVisualizationPanel.this.centerPanel.setPreferredSize(new Dimension(frame.getWidth(), frame.getHeight()));
                TldVisualizationPanel.this.centerPanel.setMinimumSize(TldVisualizationPanel.this.centerPanel.getPreferredSize());
                TldVisualizationPanel.this.centerPanel.revalidate();
            }
        });
    }

    public synchronized void update(TldTracker tracker, boolean hasSelected) {
        this.hasSelected = hasSelected;
        if (hasSelected) {
            Rectangle2D_F64 r = tracker.getTargetRegion();
            TldHelperFunctions.convertRegion((Rectangle2D_F64)r, (Rectangle2D_I32)this.selected);
            this.addDetections((FastQueue<TldRegion>)tracker.getDetection().getLocalMaximums());
            this.positivePanel.update(tracker.getTemplateMatching().getTemplatePositive(), false);
            this.negativePanel.update(tracker.getTemplateMatching().getTemplateNegative(), false);
        } else {
            this.detections.reset();
        }
        this.repaint();
    }

    private void addDetections(FastQueue<TldRegion> detections) {
        this.detections.reset();
        for (TldRegion r : detections.toList()) {
            TldRegion a = (TldRegion)this.detections.grow();
            a.confidence = r.confidence;
            a.rect.set((Rectangle2D_I32)r.rect);
        }
    }

    public void discardSelected() {
        this.hasSelected = false;
        this.numClicks = 0;
    }

    private void drawRectangle(Graphics2D g2, ImageRectangle r, Color c, int size) {
        g2.setColor(c);
        g2.setStroke(new BasicStroke(size));
        g2.drawLine(r.x0, r.y0, r.x1, r.y0);
        g2.drawLine(r.x1, r.y0, r.x1, r.y1);
        g2.drawLine(r.x1, r.y1, r.x0, r.y1);
        g2.drawLine(r.x0, r.y1, r.x0, r.y0);
    }

    public void turnOffSelect() {
        this.numClicks = 2;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.numClicks == 0) {
            this.selected.x0 = e.getX();
            this.selected.y0 = e.getY();
        } else if (this.numClicks == 1) {
            this.selected.x1 = e.getX();
            this.selected.y1 = e.getY();
            this.hasSelected = true;
            this.listener.startTracking(this.selected.x0, this.selected.y0, this.selected.x1, this.selected.y1);
            System.out.println("Selected = " + this.selected);
        } else {
            this.listener.togglePause();
        }
        ++this.numClicks;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public static interface Listener {
        public void startTracking(int var1, int var2, int var3, int var4);

        public void togglePause();
    }

    private class CenterPanel
    extends JPanel {
        private CenterPanel() {
        }

        @Override
        protected synchronized void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage((Image)TldVisualizationPanel.this.frame, 0, 0, null);
            if (TldVisualizationPanel.this.hasSelected) {
                TldVisualizationPanel.this.drawRectangle(g2, TldVisualizationPanel.this.selected, Color.RED, 3);
            }
        }
    }
}

