/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.gui.BoofSwingUtil;
import boofcv.gui.StandardAlgConfigPanel;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ViewedImageInfoPanel
extends StandardAlgConfigPanel
implements ChangeListener,
MouseWheelListener {
    double zoomMin;
    double zoomMax;
    double zoomInc;
    protected JLabel processingTimeLabel = new JLabel();
    JTextField textImageSize = new JTextField(8);
    JTextField textCursorX = new JTextField(8);
    JTextField textCursorY = new JTextField(8);
    JSpinner selectZoom;
    Listener listener;
    double zoom = 1.0;

    public ViewedImageInfoPanel() {
        this(0.01, 50.0, 0.5, true);
    }

    public ViewedImageInfoPanel(double zoomMin, double zoomMax, double zoomInc, boolean showClick) {
        this.zoomMin = zoomMin;
        this.zoomMax = zoomMax;
        this.zoomInc = zoomInc;
        this.textImageSize.setEditable(false);
        this.textImageSize.setHorizontalAlignment(4);
        this.textImageSize.setMaximumSize(this.textImageSize.getPreferredSize());
        this.textCursorX.setEditable(false);
        this.textCursorX.setMaximumSize(this.textCursorX.getPreferredSize());
        this.textCursorY.setEditable(false);
        this.textCursorY.setMaximumSize(this.textCursorY.getPreferredSize());
        this.selectZoom = new JSpinner(new SpinnerNumberModel(this.zoom, zoomMin, zoomMax, zoomInc));
        this.selectZoom.addChangeListener(this);
        this.selectZoom.setMaximumSize(this.selectZoom.getPreferredSize());
        this.addLabeled(this.textImageSize, "Input Shape");
        this.addLabeled(this.processingTimeLabel, "Time (ms)");
        if (showClick) {
            this.addLabeled(this.textCursorX, "Click X");
            this.addLabeled(this.textCursorY, "Click Y");
        }
        this.addLabeled(this.selectZoom, "Zoom");
    }

    public void setImageSize(int width, int height) {
        this.textImageSize.setText(String.format("%d x %d", width, height));
    }

    public void setCursor(double x, double y) {
        this.textCursorX.setText(String.format("%5.3f", x));
        this.textCursorY.setText(String.format("%5.3f", y));
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public double getZoom() {
        return this.zoom;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.selectZoom == e.getSource()) {
            this.zoom = ((Number)this.selectZoom.getValue()).doubleValue();
            if (this.listener != null) {
                this.listener.zoomChanged(this.zoom);
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.setScale(BoofSwingUtil.mouseWheelImageZoom(this.zoom, e));
    }

    public void setScale(double scale) {
        BoofSwingUtil.checkGuiThread();
        if (((Number)this.selectZoom.getValue()).doubleValue() == scale) {
            return;
        }
        double curr = scale;
        if (curr < this.zoomMin) {
            curr = this.zoomMin;
        }
        if (curr > this.zoomMax) {
            curr = this.zoomMax;
        }
        this.selectZoom.setValue(curr);
    }

    public void setProcessingTimeS(double seconds) {
        BoofSwingUtil.checkGuiThread();
        this.processingTimeLabel.setText(String.format("%7.1f", seconds * 1000.0));
    }

    public void setProcessingTimeMS(double ms) {
        BoofSwingUtil.checkGuiThread();
        this.processingTimeLabel.setText(String.format("%7.1f", ms));
    }

    public static interface Listener {
        public void zoomChanged(double var1);
    }
}

