/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.calibration;

import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.abst.geo.calibration.ImageResults;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.ViewedImageInfoPanel;
import boofcv.gui.calibration.CalibratedPlanarPanel;
import boofcv.gui.calibration.DisplayFisheyeCalibrationPanel;
import boofcv.struct.calib.CameraUniversalOmni;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;

public class FisheyePlanarPanel
extends CalibratedPlanarPanel<CameraUniversalOmni> {
    JTextArea paramCenterX;
    JTextArea paramCenterY;
    JTextArea paramFX;
    JTextArea paramFY;
    JTextArea paramSkew;
    JTextArea paramRadial;
    JTextArea paramTangental;
    JTextArea paramOffset;

    public FisheyePlanarPanel() {
        this.viewInfo.setListener(new ViewedImageInfoPanel.Listener(){

            @Override
            public void zoomChanged(double zoom) {
                FisheyePlanarPanel.this.mainView.setScale(zoom);
            }
        });
        this.mainView = new DisplayFisheyeCalibrationPanel();
        this.mainView.getImagePanel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                double scale = FisheyePlanarPanel.this.viewInfo.getZoom();
                FisheyePlanarPanel.this.viewInfo.setCursor((double)e.getX() / scale, (double)e.getY() / scale);
            }
        });
        this.imageList = new JList();
        this.imageList.setSelectionMode(0);
        this.imageList.addListSelectionListener(this);
        this.paramCenterX = this.createErrorComponent(1);
        this.paramCenterY = this.createErrorComponent(1);
        this.paramFX = this.createErrorComponent(1);
        this.paramFY = this.createErrorComponent(1);
        this.paramSkew = this.createErrorComponent(1);
        this.paramRadial = this.createErrorComponent(2);
        this.paramTangental = this.createErrorComponent(2);
        this.paramOffset = this.createErrorComponent(1);
        this.mainView.setDisplay(this.showPoints, this.showErrors, this.showUndistorted, this.showAll, this.showNumbers, this.showOrder, this.errorScale);
        this.mainView.addMouseWheelListener(this.viewInfo);
        this.add((Component)new LeftPanel(), "West");
        this.add((Component)this.mainView, "Center");
        this.add((Component)new CalibratedPlanarPanel.RightPanel(), "East");
    }

    @Override
    public void setObservations(List<CalibrationObservation> features) {
        this.features = features;
    }

    @Override
    public void setResults(List<ImageResults> results) {
        this.results = results;
        this.setSelected(this.selectedImage);
    }

    @Override
    public void setCalibration(CameraUniversalOmni intrinsic, SceneStructureMetric scene) {
        String textX = String.format("%5.1f", intrinsic.cx);
        String textY = String.format("%5.1f", intrinsic.cy);
        this.paramCenterX.setText(textX);
        this.paramCenterY.setText(textY);
        String textA = String.format("%5.1f", intrinsic.fx);
        String textB = String.format("%5.1f", intrinsic.fy);
        this.paramFX.setText(textA);
        this.paramFY.setText(textB);
        if (intrinsic.skew == 0.0) {
            this.paramSkew.setText("");
        } else {
            String textC = String.format("%5.1e", intrinsic.skew);
            this.paramSkew.setText(textC);
        }
        String textD = String.format("%5.1e", intrinsic.mirrorOffset);
        this.paramOffset.setText(textD);
        String radial = "";
        if (intrinsic.radial != null) {
            for (int i = 0; i < intrinsic.radial.length; ++i) {
                radial = radial + String.format("%5.2e", intrinsic.radial[i]);
                if (i == intrinsic.radial.length - 1) continue;
                radial = radial + "\n";
            }
        }
        this.paramRadial.setText(radial);
        if (intrinsic.t1 != 0.0 && intrinsic.t2 != 0.0) {
            this.paramTangental.setText(String.format("%5.2e\n%5.2e", intrinsic.t1, intrinsic.t2));
        } else {
            this.paramTangental.setText("");
        }
    }

    @Override
    public void setCorrection(CameraUniversalOmni param) {
        this.checkUndistorted.setEnabled(true);
        this.mainView.setCalibration(param);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting() || e.getFirstIndex() == -1) {
            return;
        }
        if (this.imageList.getSelectedIndex() >= 0) {
            this.setSelected(this.imageList.getSelectedIndex());
            this.mainView.repaint();
        }
    }

    @Override
    protected void updateResultsGUI() {
        if (this.selectedImage < this.results.size()) {
            ImageResults r = (ImageResults)this.results.get(this.selectedImage);
            String textMean = String.format("%5.1e", r.meanError);
            String textMax = String.format("%5.1e", r.maxError);
            this.meanError.setText(textMean);
            this.maxError.setText(textMax);
        }
    }

    private class LeftPanel
    extends StandardAlgConfigPanel {
        public LeftPanel() {
            JScrollPane scroll = new JScrollPane(FisheyePlanarPanel.this.imageList);
            this.addLabeled(FisheyePlanarPanel.this.meanError, "Mean Error");
            this.addLabeled(FisheyePlanarPanel.this.maxError, "Max Error");
            this.addSeparator(200);
            this.addLabeled(FisheyePlanarPanel.this.paramCenterX, "Xc");
            this.addLabeled(FisheyePlanarPanel.this.paramCenterY, "Yc");
            this.addLabeled(FisheyePlanarPanel.this.paramFX, "fx");
            this.addLabeled(FisheyePlanarPanel.this.paramFY, "fy");
            this.addLabeled(FisheyePlanarPanel.this.paramSkew, "skew");
            this.addLabeled(FisheyePlanarPanel.this.paramRadial, "radial");
            this.addLabeled(FisheyePlanarPanel.this.paramTangental, "tangential");
            this.addLabeled(FisheyePlanarPanel.this.paramOffset, "offset");
            this.addCenterLabel("Images", this);
            this.add(scroll);
        }
    }
}

