/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.abst.feature.describe.ConfigBrief;
import boofcv.gui.StandardAlgConfigPanel;
import javax.annotation.Nullable;
import javax.swing.JCheckBox;
import javax.swing.JSpinner;

public class ControlPanelDescribeBrief
extends StandardAlgConfigPanel {
    public final ConfigBrief config;
    private final JSpinner spinnerRadius;
    private final JSpinner spinnerNumPoints;
    private final JSpinner spinnerBlurSigma;
    private final JSpinner spinnerBlurRadius;
    private final JCheckBox checkFixed;
    private final Listener listener;

    public ControlPanelDescribeBrief(@Nullable ConfigBrief config_, Listener listener) {
        this.config = config_ == null ? new ConfigBrief() : config_;
        this.listener = listener;
        this.spinnerRadius = this.spinner(this.config.radius, 1, 999, 2);
        this.spinnerNumPoints = this.spinner(this.config.numPoints, 1, 9999, 128);
        this.spinnerBlurSigma = this.spinner(this.config.blurSigma, -1.0, 100.0, 0.5);
        this.spinnerBlurRadius = this.spinner(this.config.blurRadius, -1, 10000, 1);
        this.checkFixed = this.checkbox("Fixed", this.config.fixed, "true = fixed shape. false = scales and rotates");
        this.addLabeled(this.spinnerRadius, "Radius", "Radius of the descriptor's sample region");
        this.addLabeled(this.spinnerNumPoints, "Num Points", "Number of points it will sample. Descriptor length.");
        this.addLabeled(this.spinnerBlurSigma, "Blur Sigma", "Amount of blur applied to the image before sampling.");
        this.addLabeled(this.spinnerBlurRadius, "Blur Radius", "Amount of blur applied to the image before sampling.");
        this.addAlignLeft(this.checkFixed);
    }

    @Override
    public void controlChanged(Object source) {
        if (source == this.spinnerRadius) {
            this.config.radius = ((Number)this.spinnerRadius.getValue()).intValue();
        } else if (source == this.spinnerNumPoints) {
            this.config.numPoints = ((Number)this.spinnerNumPoints.getValue()).intValue();
        } else if (source == this.spinnerBlurSigma) {
            this.config.blurSigma = ((Number)this.spinnerBlurSigma.getValue()).doubleValue();
        } else if (source == this.spinnerBlurRadius) {
            this.config.blurRadius = ((Number)this.spinnerBlurRadius.getValue()).intValue();
        } else if (source == this.checkFixed) {
            this.config.fixed = this.checkFixed.isSelected();
        }
        this.listener.handleChangeBrief();
    }

    public static interface Listener {
        public void handleChangeBrief();
    }
}

