/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.feature.ControlPanelExtractor;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.JSpinner;

public class ControlPanelFastHessian
extends StandardAlgConfigPanel {
    public final ConfigFastHessian config;
    private final ControlPanelExtractor controlExtractor;
    private final JSpinner spinnerMaxPerScale;
    private final JSpinner spinnerInitialSample;
    private final JSpinner spinnerInitialSize;
    private final JSpinner spinnerScalesPerOctave;
    private final JSpinner spinnerOctaves;
    private final JSpinner spinnerScaleStep;
    private final Listener listener;

    public ControlPanelFastHessian(@Nullable ConfigFastHessian config_, Listener listener) {
        this.config = config_ == null ? new ConfigFastHessian() : config_;
        this.listener = listener;
        this.controlExtractor = new ControlPanelExtractor(this.config.extract, listener::handleChangeFastHessian);
        this.spinnerMaxPerScale = this.spinner(this.config.maxFeaturesPerScale, -1, 9999, 100);
        this.spinnerInitialSample = this.spinner(this.config.initialSampleStep, 1, 10, 1);
        this.spinnerInitialSize = this.spinner(this.config.initialSize, 3, 999, 2);
        this.spinnerScalesPerOctave = this.spinner(this.config.numberScalesPerOctave, 1, 100, 1);
        this.spinnerOctaves = this.spinner(this.config.numberOfOctaves, 1, 20, 1);
        this.spinnerScaleStep = this.spinner(this.config.scaleStepSize, 1, 100, 1);
        this.controlExtractor.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.controlExtractor);
        this.addLabeled(this.spinnerMaxPerScale, "Max-Per-Scale", "Maximum number of features detected per scale");
        this.addLabeled(this.spinnerInitialSample, "Sample Step", "How often pixels are sampled in first octave");
        this.addLabeled(this.spinnerInitialSize, "Kernel Size", "Size of sampling kernel");
        this.addLabeled(this.spinnerScalesPerOctave, "Scales", "Number of scales per octave");
        this.addLabeled(this.spinnerOctaves, "Octaves", "Number of octaves in the scale space");
        this.addLabeled(this.spinnerScaleStep, "Scale Step", "Increment between kernel sizes at each scale");
    }

    @Override
    public void controlChanged(Object source) {
        if (source == this.spinnerMaxPerScale) {
            this.config.maxFeaturesPerScale = ((Number)this.spinnerMaxPerScale.getValue()).intValue();
        } else if (source == this.spinnerInitialSample) {
            this.config.initialSampleStep = ((Number)this.spinnerInitialSample.getValue()).intValue();
        } else if (source == this.spinnerInitialSize) {
            this.config.initialSize = ((Number)this.spinnerInitialSize.getValue()).intValue();
        } else if (source == this.spinnerScalesPerOctave) {
            this.config.numberScalesPerOctave = ((Number)this.spinnerScalesPerOctave.getValue()).intValue();
        } else if (source == this.spinnerOctaves) {
            this.config.numberOfOctaves = ((Number)this.spinnerOctaves.getValue()).intValue();
        } else if (source == this.spinnerScaleStep) {
            this.config.scaleStepSize = ((Number)this.spinnerScaleStep.getValue()).intValue();
        }
        this.listener.handleChangeFastHessian();
    }

    public static interface Listener {
        public void handleChangeFastHessian();
    }
}

