/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.interest.ConfigPointDetector;
import boofcv.abst.feature.detect.interest.PointDetectorTypes;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.factory.feature.detect.interest.FactoryDetectPoint;
import boofcv.factory.feature.detect.selector.SelectLimitTypes;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.feature.ControlPanelExtractor;
import boofcv.struct.image.ImageGray;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSpinner;

public class ControlPanelPointDetector
extends StandardAlgConfigPanel {
    public ConfigPointDetector config;
    private final JComboBox<String> comboType;
    private final JSpinner spinnerKernel;
    private final JCheckBox checkWeighted;
    private final JSpinner spinnerRadius;
    private final ControlPanelExtractor controlExtractor;
    private final JSpinner spinnerMaxFeatures;
    private final JComboBox<String> comboSelector;
    Listener listener;

    public ControlPanelPointDetector(ConfigPointDetector config, Listener listener) {
        this.config = config;
        this.listener = listener;
        this.spinnerKernel = this.spinner(1, 1, 1000, 1);
        this.checkWeighted = this.checkbox("Weighted", false, "Gaussian weighted or block");
        this.spinnerRadius = this.spinner(config.scaleRadius, 1.0, 500.0, 1.0);
        this.comboType = this.combo(config.type.ordinal(), PointDetectorTypes.FIRST_ONLY);
        this.controlExtractor = new ControlPanelExtractor((ConfigExtract)config.general, listener::handleChangePointDetector);
        this.spinnerMaxFeatures = this.spinner(config.general.maxFeatures, -1, 9999, 50);
        this.setKernelSize();
        this.setWeighted();
        this.controlExtractor.setBorder(BorderFactory.createEmptyBorder());
        this.comboSelector = this.combo(config.general.selector.type.ordinal(), SelectLimitTypes.values());
        this.addLabeled(this.comboType, "Type", "Type of corner or blob detector");
        this.addLabeled(this.spinnerKernel, "Kernel", "Radius of convolutional kernel");
        this.addAlignCenter(this.checkWeighted);
        this.addLabeled(this.spinnerRadius, "Scale/Radius", "Specified size given to scale invariant descriptors");
        this.add(this.controlExtractor);
        this.addLabeled(this.spinnerMaxFeatures, "Max Features", "Maximum features it will detect. <= 0 for no limit");
        this.addLabeled(this.comboSelector, "Select", "Method used to select points when more have been detected than the maximum allowed");
    }

    private void setKernelSize() {
        int radius = -1;
        switch (this.config.type) {
            case SHI_TOMASI: {
                radius = this.config.shiTomasi.radius;
                break;
            }
            case HARRIS: {
                radius = this.config.harris.radius;
            }
        }
        this.spinnerKernel.removeChangeListener(this);
        if (radius == -1) {
            this.spinnerKernel.setEnabled(false);
        } else {
            this.spinnerKernel.setEnabled(true);
            this.spinnerKernel.setValue(radius);
        }
        this.spinnerKernel.addChangeListener(this);
    }

    private void setWeighted() {
        this.checkWeighted.removeActionListener(this);
        switch (this.config.type) {
            case SHI_TOMASI: {
                this.checkWeighted.setEnabled(true);
                this.checkWeighted.setSelected(this.config.shiTomasi.weighted);
                break;
            }
            case HARRIS: {
                this.checkWeighted.setEnabled(true);
                this.checkWeighted.setSelected(this.config.harris.weighted);
                break;
            }
            default: {
                this.checkWeighted.setEnabled(false);
            }
        }
        this.checkWeighted.addActionListener(this);
    }

    public <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> create(Class<T> imageType) {
        return FactoryDetectPoint.create((ConfigPointDetector)this.config, imageType, null);
    }

    @Override
    public void controlChanged(Object source) {
        if (source == this.comboType) {
            this.config.type = PointDetectorTypes.FIRST_ONLY[this.comboType.getSelectedIndex()];
            this.setKernelSize();
            this.setWeighted();
        } else if (source == this.spinnerMaxFeatures) {
            this.config.general.maxFeatures = ((Number)this.spinnerMaxFeatures.getValue()).intValue();
        } else if (source == this.comboSelector) {
            this.config.general.selector.type = SelectLimitTypes.values()[this.comboSelector.getSelectedIndex()];
        } else if (source == this.spinnerRadius) {
            this.config.scaleRadius = ((Number)this.spinnerRadius.getValue()).doubleValue();
        } else if (source == this.spinnerKernel) {
            switch (this.config.type) {
                case SHI_TOMASI: {
                    this.config.shiTomasi.radius = ((Number)this.spinnerKernel.getValue()).intValue();
                    break;
                }
                case HARRIS: {
                    this.config.harris.radius = ((Number)this.spinnerKernel.getValue()).intValue();
                }
            }
        } else if (source == this.checkWeighted) {
            switch (this.config.type) {
                case SHI_TOMASI: {
                    this.config.shiTomasi.weighted = this.checkWeighted.isSelected();
                    break;
                }
                case HARRIS: {
                    this.config.harris.weighted = this.checkWeighted.isSelected();
                }
            }
        } else {
            throw new RuntimeException("Unknown source");
        }
        this.listener.handleChangePointDetector();
    }

    public static interface Listener {
        public void handleChangePointDetector();
    }
}

