/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.gui.BoofSwingUtil;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.controls.ControlPanelDisparityDense;
import boofcv.gui.controls.ControlPanelPointCloud;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ControlPanelDisparityDisplay
extends StandardAlgConfigPanel
implements ChangeListener,
ActionListener {
    public int selectedView;
    public double zoom = 1.0;
    public boolean concurrent = true;
    public boolean recompute = true;
    public int inputScale = 100;
    public int backgroundColorDisparity = 0;
    protected JLabel processingTimeLabel = new JLabel();
    protected JLabel imageSizeLabel = new JLabel();
    protected JSpinner selectZoom = this.spinner(1.0, 0.01, 50.0, 0.1);
    JSpinner inputScaleSpinner = this.spinner(this.inputScale, 5, 100, 10);
    JComboBox viewSelector = this.combo(this.selectedView, "Disparity", "Left", "Right", "View 3D");
    public ControlCustomCloud controlCloud = new ControlCustomCloud();
    JCheckBox checkRecompute = this.checkbox("Recompute", this.recompute);
    JCheckBox checkConcurrent = this.checkbox("concurrent", this.concurrent);
    public ControlPanelDisparityDense controlDisparity;
    Listener listener;

    public ControlPanelDisparityDisplay(int disparityMin, int disparityRange, Class imageType) {
        this.controlDisparity = ControlPanelDisparityDense.createRange(disparityMin, disparityRange, imageType);
        this.controlDisparity.setListener(() -> this.listener.algorithmChanged());
        this.controlCloud.setBorder(BorderFactory.createEmptyBorder());
        this.controlCloud.setCallbackModified(() -> this.listener.changeView3D());
        this.controlCloud.setCallbackBackground(() -> this.listener.changeBackgroundColor());
        this.controlCloud.handleViewChange();
        this.addLabeled(this.processingTimeLabel, "Time (ms)");
        this.addLabeled(this.imageSizeLabel, "Image Size");
        this.addLabeled(this.viewSelector, "View");
        this.addLabeled(this.selectZoom, "Zoom");
        this.add(this.controlCloud);
        this.add(this.controlDisparity);
        this.addLabeled(this.inputScaleSpinner, "Scale Input");
        this.addAlignLeft(this.checkRecompute);
        this.addAlignLeft(this.checkConcurrent);
        this.addVerticalGlue();
        this.setPreferredSize(new Dimension(200, 0));
    }

    public void enableAlgControls(boolean enable) {
        BoofSwingUtil.checkGuiThread();
        BoofSwingUtil.recursiveEnable(this.controlDisparity, enable);
        if (enable) {
            this.controlDisparity.updateControlEnabled();
        }
        this.inputScaleSpinner.setEnabled(enable);
        this.checkRecompute.setEnabled(enable);
        this.checkConcurrent.setEnabled(enable);
    }

    public void setZoom(double _zoom) {
        _zoom = Math.max(0.01, _zoom);
        if ((_zoom = Math.min(50.0, _zoom)) == this.zoom) {
            return;
        }
        this.zoom = _zoom;
        BoofSwingUtil.invokeNowOrLater(() -> this.selectZoom.setValue(this.zoom));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.listener == null) {
            return;
        }
        if (e.getSource() == this.inputScaleSpinner) {
            this.inputScale = ((Number)this.inputScaleSpinner.getValue()).intValue();
            this.listener.changeInputScale();
        } else if (e.getSource() == this.selectZoom) {
            this.zoom = ((Number)this.selectZoom.getValue()).doubleValue();
            this.listener.changeZoom();
        } else {
            throw new RuntimeException("Egads");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.listener == null) {
            return;
        }
        if (e.getSource() == this.viewSelector) {
            this.selectedView = this.viewSelector.getSelectedIndex();
            this.controlCloud.handleViewChange();
            this.listener.disparityGuiChange();
        } else if (e.getSource() == this.checkRecompute) {
            this.recompute = this.checkRecompute.isSelected();
            this.listener.recompute();
        } else if (e.getSource() == this.checkConcurrent) {
            this.concurrent = this.checkConcurrent.isSelected();
            this.listener.recompute();
        }
    }

    public void setImageSize(int width, int height) {
        BoofSwingUtil.invokeNowOrLater(() -> this.imageSizeLabel.setText(width + " x " + height));
    }

    public void setProcessingTimeMS(double ms) {
        BoofSwingUtil.checkGuiThread();
        this.processingTimeLabel.setText(String.format("%7.1f", ms));
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public class ControlCustomCloud
    extends ControlPanelPointCloud {
        private void handleViewChange() {
            this.setColorButtonColor(this.getActiveBackgroundColor());
            boolean view3D = ControlPanelDisparityDisplay.this.selectedView == 3;
            this.comboColorizer.setEnabled(view3D);
            this.sliderOffsetColor.setEnabled(view3D);
            this.sliderPeriodColor.setEnabled(view3D);
            this.sliderSpeed3D.setEnabled(view3D);
            this.bColorBackGround.setEnabled(ControlPanelDisparityDisplay.this.selectedView == 0 || ControlPanelDisparityDisplay.this.selectedView == 3);
        }

        @Override
        public int getActiveBackgroundColor() {
            if (ControlPanelDisparityDisplay.this.selectedView == 0) {
                return ControlPanelDisparityDisplay.this.backgroundColorDisparity;
            }
            if (ControlPanelDisparityDisplay.this.selectedView == 3) {
                return this.backgroundColor3D;
            }
            return this.bColorBackGround.getBackground().getRGB();
        }

        @Override
        public void setColorButtonColor(int colorRGB) {
            if (ControlPanelDisparityDisplay.this.selectedView == 0) {
                ControlPanelDisparityDisplay.this.backgroundColorDisparity = colorRGB;
            } else if (ControlPanelDisparityDisplay.this.selectedView == 3) {
                this.backgroundColor3D = colorRGB;
            } else {
                return;
            }
            this.bColorBackGround.repaint();
        }
    }

    public static interface Listener {
        public void algorithmChanged();

        public void recompute();

        public void disparityGuiChange();

        public void disparityRender();

        public void changeInputScale();

        public void changeView3D();

        public void changeZoom();

        public void changeBackgroundColor();
    }
}

