/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.abst.disparity.StereoDisparitySparse;
import boofcv.abst.sfm.d3.StereoVisualOdometry;
import boofcv.abst.tracker.PointTracker;
import boofcv.factory.sfm.ConfigStereoMonoTrackPnP;
import boofcv.factory.sfm.ConfigVisOdomTrackPnP;
import boofcv.factory.sfm.FactoryVisualOdometry;
import boofcv.gui.controls.ControlPanelDisparitySparse;
import boofcv.gui.controls.ControlPanelPointTrackers;
import boofcv.gui.controls.ControlPanelVisOdomTrackPnP;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import java.awt.BorderLayout;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ControlPanelStereoMonoTrackPnP
extends JPanel {
    ControlPanelVisOdomTrackPnP controlPnpDepth;
    ControlPanelPointTrackers controlTrackers;
    ControlPanelDisparitySparse controlDisparity;

    public ControlPanelStereoMonoTrackPnP(ConfigStereoMonoTrackPnP config, Listener listener) {
        this.setLayout(new BorderLayout());
        this.controlPnpDepth = new ControlPanelVisOdomTrackPnP(listener::changedStereoMonoTrackPnP, config.scene);
        this.controlTrackers = new ControlPanelPointTrackers(listener::changedStereoMonoTrackPnP, config.tracker);
        this.controlDisparity = new ControlPanelDisparitySparse(listener::changedStereoMonoTrackPnP, config.disparity);
        JPanel panelAlgControls = new JPanel(new BorderLayout());
        JTabbedPane tuningTabs = new JTabbedPane();
        tuningTabs.addTab("VO", panelAlgControls);
        tuningTabs.addTab("Tracker", this.controlTrackers);
        tuningTabs.addTab("Stereo", this.controlDisparity);
        panelAlgControls.add("Center", this.controlPnpDepth);
        JPanel panelTuning = new JPanel();
        panelTuning.setLayout(new BoxLayout(panelTuning, 1));
        panelTuning.add(tuningTabs);
        this.add("Center", tuningTabs);
    }

    public <T extends ImageGray<T>> StereoVisualOdometry<T> createVisOdom(Class<T> imageType) {
        PointTracker tracker = this.controlTrackers.createTracker(ImageType.single(imageType));
        StereoDisparitySparse<T> disparity = this.controlDisparity.createAlgorithm(imageType);
        return FactoryVisualOdometry.stereoMonoPnP((ConfigVisOdomTrackPnP)this.controlPnpDepth.config, disparity, tracker, imageType);
    }

    public static interface Listener {
        public void changedStereoMonoTrackPnP();
    }
}

