/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.d3;

import boofcv.gui.BoofSwingUtil;
import boofcv.gui.d3.PointCloudViewerPanelSwing;
import boofcv.struct.Point3dRgbI_F64;
import boofcv.visualize.PointCloudViewer;
import georegression.struct.ConvertFloatType;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F32;
import georegression.struct.se.Se3_F64;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public class PointCloudViewerSwing
implements PointCloudViewer {
    PointCloudViewerPanelSwing panel = new PointCloudViewerPanelSwing(60.0f, 1.0f);

    public void setShowAxis(boolean show) {
    }

    public void setTranslationStep(double step) {
        BoofSwingUtil.invokeNowOrLater(() -> this.panel.setStepSize((float)step));
    }

    public void setDotSize(int pixels) {
        BoofSwingUtil.invokeNowOrLater(() -> this.panel.setDotRadius(pixels));
    }

    public void setClipDistance(double distance) {
        BoofSwingUtil.invokeNowOrLater(() -> {
            this.panel.maxRenderDistance = (float)distance;
        });
    }

    public void setFog(boolean active) {
        BoofSwingUtil.invokeNowOrLater(() -> {
            this.panel.fog = active;
        });
    }

    public void setBackgroundColor(int rgb) {
        BoofSwingUtil.invokeNowOrLater(() -> {
            this.panel.backgroundColor = rgb;
        });
    }

    public void addCloud(List<Point3D_F64> cloudXyz, int[] colorsRgb) {
        if (cloudXyz.size() > colorsRgb.length) {
            throw new IllegalArgumentException("Number of points do not match");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            for (int i = 0; i < cloudXyz.size(); ++i) {
                Point3D_F64 p = cloudXyz.get(i);
                this.panel.addPoint((float)p.x, (float)p.y, (float)p.z, colorsRgb[i]);
            }
        } else {
            SwingUtilities.invokeLater(() -> {
                for (int i = 0; i < cloudXyz.size(); ++i) {
                    Point3D_F64 p = (Point3D_F64)cloudXyz.get(i);
                    this.panel.addPoint((float)p.x, (float)p.y, (float)p.z, colorsRgb[i]);
                }
            });
        }
    }

    public void addCloud(List<Point3D_F64> cloud) {
        if (SwingUtilities.isEventDispatchThread()) {
            for (int i = 0; i < cloud.size(); ++i) {
                Point3D_F64 p = cloud.get(i);
                this.panel.addPoint((float)p.x, (float)p.y, (float)p.z, 0xFF0000);
            }
        } else {
            SwingUtilities.invokeLater(() -> {
                for (int i = 0; i < cloud.size(); ++i) {
                    Point3D_F64 p = (Point3D_F64)cloud.get(i);
                    this.panel.addPoint((float)p.x, (float)p.y, (float)p.z, 0xFF0000);
                }
            });
        }
    }

    public void addCloud(DogArray_F32 cloudXYZ, DogArray_I32 colorRGB) {
        if (cloudXYZ.size / 3 != colorRGB.size) {
            throw new IllegalArgumentException("Number of points do not match");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.panel.addPoints(cloudXYZ.data, colorRGB.data, cloudXYZ.size / 3);
        } else {
            SwingUtilities.invokeLater(() -> this.panel.addPoints(cloudXYZ.data, colorRGB.data, cloudXYZ.size / 3));
        }
    }

    public void addPoint(double x, double y, double z, int rgb) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.panel.addPoint((float)x, (float)y, (float)z, rgb);
        } else {
            SwingUtilities.invokeLater(() -> this.panel.addPoint((float)x, (float)y, (float)z, rgb));
        }
    }

    public void addWireFrame(List<Point3D_F64> vertexes, boolean closed, int rgb, int widthPixels) {
        BoofSwingUtil.invokeNowOrLater(() -> this.panel.addWireFrame(vertexes, closed, rgb, widthPixels));
    }

    public void clearPoints() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.panel.clearCloud();
        } else {
            SwingUtilities.invokeLater(() -> this.panel.clearCloud());
        }
    }

    public void setColorizer(PointCloudViewer.Colorizer colorizer) {
        this.panel.colorizer = colorizer;
    }

    public void removeColorizer() {
        this.panel.colorizer = null;
    }

    public void setCameraHFov(double radians) {
        BoofSwingUtil.invokeNowOrLater(() -> this.panel.setHorizontalFieldOfView((float)radians));
    }

    public void setCameraToWorld(Se3_F64 cameraToWorld) {
        Se3_F64 worldToCamera = cameraToWorld.invert(null);
        Se3_F32 worldToCameraF32 = new Se3_F32();
        ConvertFloatType.convert((Se3_F64)worldToCamera, (Se3_F32)worldToCameraF32);
        BoofSwingUtil.invokeNowOrLater(() -> this.panel.setWorldToCamera(worldToCameraF32));
    }

    public Se3_F64 getCameraToWorld(@Nullable Se3_F64 cameraToWorld) {
        if (cameraToWorld == null) {
            cameraToWorld = new Se3_F64();
        }
        Se3_F32 worldToCamera = this.panel.getWorldToCamera(null);
        ConvertFloatType.convert((Se3_F32)worldToCamera.invert(null), (Se3_F64)cameraToWorld);
        return cameraToWorld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DogArray<Point3dRgbI_F64> copyCloud(@Nullable DogArray<Point3dRgbI_F64> copy) {
        if (copy == null) {
            copy = new DogArray(Point3dRgbI_F64::new);
        } else {
            copy.reset();
        }
        DogArray_F32 cloudXyz = this.panel.getCloudXyz();
        DogArray_I32 cloudColor = this.panel.getCloudColor();
        DogArray_F32 dogArray_F32 = cloudXyz;
        synchronized (dogArray_F32) {
            int N = cloudXyz.size / 3;
            if (N == cloudColor.size) {
                int idxXyz = 0;
                for (int i = 0; i < N; ++i) {
                    Point3dRgbI_F64 p = (Point3dRgbI_F64)copy.grow();
                    p.x = cloudXyz.data[idxXyz++];
                    p.y = cloudXyz.data[idxXyz++];
                    p.z = cloudXyz.data[idxXyz++];
                    p.rgb = cloudColor.data[i];
                }
            } else {
                int idxXyz = 0;
                for (int i = 0; i < N; ++i) {
                    Point3dRgbI_F64 p = (Point3dRgbI_F64)copy.grow();
                    p.x = cloudXyz.data[idxXyz++];
                    p.y = cloudXyz.data[idxXyz++];
                    p.z = cloudXyz.data[idxXyz++];
                    p.rgb = 0;
                }
            }
        }
        return copy;
    }

    public JComponent getComponent() {
        return this.panel;
    }
}

