/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.dialogs;

import boofcv.gui.BoofSwingUtil;
import boofcv.gui.dialogs.FileBrowser;
import boofcv.gui.dialogs.JSpringPanel;
import boofcv.gui.image.ImagePanel;
import boofcv.io.UtilIO;
import boofcv.io.image.UtilImageIO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OpenImageSetDialog
extends JPanel {
    private static final int PREVIEW_LENGTH = 300;
    Listener listener;
    FileBrowser browser;
    ImagePanel preview = new ImagePanel();
    SelectedList selected = new SelectedList();
    int requiredSelect = 1;
    Mode modeSelect = Mode.MINIMUM;
    JDialog dialog;
    File defaultDirectory;
    JButton bOK;
    private final Object lockPreview = new Object();
    PreviewThread previewThread;
    String pendingPreview;

    public OpenImageSetDialog(JDialog dialog, Listener listener, File directory) {
        this.setLayout(new BorderLayout());
        this.listener = listener;
        this.dialog = dialog;
        this.defaultDirectory = directory;
        this.browser = new FileBrowser(directory, null, new BrowserListener());
        this.browser.setSelectionMode(2);
        SelectPanel selectPanel = new SelectPanel();
        this.bOK = BoofSwingUtil.button("OK", e -> this.handleOK());
        this.bOK.setEnabled(false);
        JButton bCancel = BoofSwingUtil.button("Cancel", e -> this.handleCancel());
        JPanel bottomPanel = JSpringPanel.createLockedSides(bCancel, this.bOK, 35);
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.preview.setCentering(true);
        JSplitPane splitSelected = new JSplitPane(0, this.preview, this.selected);
        splitSelected.setDividerLocation(200);
        splitSelected.setResizeWeight(0.0);
        splitSelected.setContinuousLayout(true);
        JSplitPane splitContent = new JSplitPane(1, selectPanel, splitSelected);
        splitContent.setDividerLocation(300);
        splitContent.setResizeWeight(0.0);
        splitContent.setContinuousLayout(true);
        this.add((Component)splitContent, "Center");
        this.add((Component)bottomPanel, "South");
        this.setPreferredSize(new Dimension(600, 400));
    }

    void handleAdd() {
        BoofSwingUtil.checkGuiThread();
        List<File> paths = this.browser.getSelectedFiles();
        for (int i = 0; i < paths.size(); ++i) {
            File f = paths.get(i);
            if (f.isDirectory()) {
                List files = UtilIO.listAll((String)f.getPath());
                Collections.sort(files);
                for (int j = 0; j < files.size(); ++j) {
                    File p = new File((String)files.get(j));
                    if (!p.isFile()) continue;
                    this.selected.addPath(p);
                }
                continue;
            }
            this.selected.addPath(f);
        }
    }

    void handleOK() {
        String[] selected = this.selected.paths.toArray(new String[0]);
        this.listener.selectedImages(selected);
    }

    void handleCancel() {
        this.listener.userCanceled();
    }

    public void handleSelectedUpdate(int count) {
        switch (this.modeSelect) {
            case EXACTLY: {
                this.bOK.setEnabled(count == this.requiredSelect);
                break;
            }
            case MINIMUM: {
                this.bOK.setEnabled(count >= this.requiredSelect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showPreview(String path) {
        Object object = this.lockPreview;
        synchronized (object) {
            if (path == null) {
                this.pendingPreview = null;
            } else if (this.previewThread == null) {
                this.pendingPreview = path;
                this.previewThread = new PreviewThread();
                this.previewThread.start();
            } else {
                this.pendingPreview = path;
            }
        }
    }

    public static String[] showDialog(File directory, Mode mode, int numberOfImages, Window owner) {
        String title = "";
        switch (mode) {
            case EXACTLY: {
                title = "Select exactly " + numberOfImages + " images";
                break;
            }
            case MINIMUM: {
                title = "Select at least " + numberOfImages + " images";
            }
        }
        JDialog dialog = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        DefaultListener listener = new DefaultListener(dialog);
        final OpenImageSetDialog panel = new OpenImageSetDialog(dialog, listener, directory);
        panel.modeSelect = Mode.EXACTLY;
        panel.requiredSelect = numberOfImages;
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                panel.handleCancel();
            }
        });
        dialog.setDefaultCloseOperation(0);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)panel, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
        dialog.dispose();
        if (listener.canceled) {
            return null;
        }
        return listener.images;
    }

    public static void main(String[] args) {
        String[] selected = OpenImageSetDialog.showDialog(new File(""), Mode.EXACTLY, 3, null);
        if (selected == null) {
            System.out.println("Canceled");
        } else {
            for (int i = 0; i < selected.length; ++i) {
                System.out.println(selected[i]);
            }
        }
    }

    private class SelectedList
    extends JSpringPanel
    implements ListSelectionListener {
        JList selectedList;
        JButton bRemove = new JButton("Remove");
        DefaultListModel listModel = new DefaultListModel();
        List<String> paths = new ArrayList<String>();

        public SelectedList() {
            this.selectedList = new JList(this.listModel);
            this.selectedList.setSelectionMode(0);
            this.selectedList.setLayoutOrientation(0);
            this.selectedList.addListSelectionListener(this);
            JScrollPane scrollList = new JScrollPane(this.selectedList);
            scrollList.setVerticalScrollBarPolicy(22);
            this.bRemove.addActionListener(e -> {
                int index = this.selectedList.getSelectedIndex();
                if (index >= 0) {
                    this.listModel.removeElementAt(index);
                    this.paths.remove(index);
                    OpenImageSetDialog.this.handleSelectedUpdate(this.paths.size());
                }
            });
            this.constrainWestNorthEast(scrollList, null, 5, 0);
            this.add(this.bRemove);
            this.layout.putConstraint("HorizontalCenter", (Component)this.bRemove, 0, "HorizontalCenter", (Component)this);
            this.layout.putConstraint("South", (Component)scrollList, -5, "North", (Component)this.bRemove);
            this.layout.putConstraint("South", (Component)this.bRemove, -5, "South", (Component)this);
        }

        public void addPath(File path) {
            BoofSwingUtil.invokeNowOrLater(() -> {
                if (OpenImageSetDialog.this.modeSelect == Mode.EXACTLY && this.paths.size() == OpenImageSetDialog.this.requiredSelect) {
                    return;
                }
                if (!this.paths.contains(path.getPath())) {
                    this.listModel.addElement(path.getName());
                    this.paths.add(path.getPath());
                    OpenImageSetDialog.this.handleSelectedUpdate(this.paths.size());
                }
            });
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int index = this.selectedList.getSelectedIndex();
            if (index >= 0) {
                OpenImageSetDialog.this.showPreview(this.paths.get(index));
            } else {
                OpenImageSetDialog.this.showPreview("");
            }
        }
    }

    public static enum Mode {
        MINIMUM,
        EXACTLY;

    }

    public static interface Listener {
        public void selectedImages(String ... var1);

        public void userCanceled();
    }

    private class BrowserListener
    implements FileBrowser.Listener {
        private BrowserListener() {
        }

        @Override
        public void handleSelectedFile(File file) {
            if (file == null) {
                OpenImageSetDialog.this.showPreview("");
            } else if (file.isFile()) {
                OpenImageSetDialog.this.showPreview(file.getPath());
            } else {
                OpenImageSetDialog.this.showPreview("");
            }
        }

        @Override
        public void handleDoubleClickedFile(File file) {
            OpenImageSetDialog.this.selected.addPath(file);
        }
    }

    private class SelectPanel
    extends JSpringPanel {
        public SelectPanel() {
            JButton bAdd = BoofSwingUtil.button("Add", e -> OpenImageSetDialog.this.handleAdd());
            this.constrainWestNorthEast(OpenImageSetDialog.this.browser, null, 0, 0);
            this.add(bAdd);
            this.layout.putConstraint("HorizontalCenter", (Component)bAdd, 0, "HorizontalCenter", (Component)this);
            this.layout.putConstraint("South", (Component)OpenImageSetDialog.this.browser, 0, "North", (Component)bAdd);
            this.layout.putConstraint("South", (Component)bAdd, -5, "South", (Component)this);
        }
    }

    private class PreviewThread
    extends Thread {
        public PreviewThread() {
            super("Image Preview");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                double scale;
                int h;
                String path;
                Object object = OpenImageSetDialog.this.lockPreview;
                synchronized (object) {
                    if (OpenImageSetDialog.this.pendingPreview == null) {
                        OpenImageSetDialog.this.previewThread = null;
                        return;
                    }
                    path = OpenImageSetDialog.this.pendingPreview;
                    OpenImageSetDialog.this.pendingPreview = null;
                }
                BufferedImage full = UtilImageIO.loadImage((String)path);
                if (full == null) {
                    OpenImageSetDialog.this.preview.setImageRepaint(null);
                    continue;
                }
                int w = full.getWidth();
                if (w > (h = full.getHeight())) {
                    scale = 300.0 / (double)w;
                    h = h * 300 / w;
                    w = 300;
                } else {
                    scale = 300.0 / (double)h;
                    w = w * 300 / h;
                    h = 300;
                }
                BufferedImage small = new BufferedImage(w, h, full.getType());
                Graphics2D g2 = small.createGraphics();
                g2.setTransform(new AffineTransform(scale, 0.0, 0.0, scale, 0.0, 0.0));
                g2.drawImage((Image)full, 0, 0, null);
                OpenImageSetDialog.this.preview.setImageRepaint(small);
            }
        }
    }

    public static class DefaultListener
    implements Listener {
        JDialog dialog;
        public String[] images;
        public boolean canceled = false;

        public DefaultListener(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void selectedImages(String ... images) {
            this.images = images;
            this.dialog.setVisible(false);
        }

        @Override
        public void userCanceled() {
            this.canceled = true;
            this.dialog.setVisible(false);
        }
    }
}

