/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.gui.feature.CompareTwoImagePanel;
import boofcv.gui.feature.VisualizeFeatures;
import georegression.struct.point.Point2D_F64;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseListener;
import java.util.List;

public class AssociationScorePanel<D>
extends CompareTwoImagePanel
implements MouseListener {
    double containmentFraction;
    int maxCircleRadius = 15;
    List<D> leftDesc;
    List<D> rightDesc;
    double[] associationScore;
    ScoreAssociation<D> scorer;
    int indexBest;
    double worst;
    double best;

    public AssociationScorePanel(double containmentFraction) {
        super(20, false);
        if (containmentFraction <= 0.0) {
            throw new IllegalArgumentException("containmentFraction must be more than zero");
        }
        this.containmentFraction = containmentFraction;
    }

    public void setScorer(ScoreAssociation<D> scorer) {
        this.scorer = scorer;
    }

    public void setLocation(List<Point2D_F64> leftPts, List<Point2D_F64> rightPts, List<D> leftDesc, List<D> rightDesc) {
        this.setLocation(leftPts, rightPts);
        this.leftDesc = leftDesc;
        this.rightDesc = rightDesc;
    }

    protected void computeScore(boolean isTargetLeft, int targetIndex) {
        int N = Math.max(this.leftPts.size(), this.rightPts.size());
        if (this.associationScore == null || this.associationScore.length < N) {
            this.associationScore = new double[N];
        }
        if (isTargetLeft) {
            D t = this.leftDesc.get(targetIndex);
            for (int i = 0; i < this.rightDesc.size(); ++i) {
                D d = this.rightDesc.get(i);
                this.associationScore[i] = this.scorer.score(t, d);
            }
        } else {
            D t = this.rightDesc.get(targetIndex);
            for (int i = 0; i < this.leftDesc.size(); ++i) {
                D d = this.leftDesc.get(i);
                this.associationScore[i] = this.scorer.score(t, d);
            }
        }
    }

    @Override
    protected void drawFeatures(Graphics2D g2, double scaleLeft, int leftX, int leftY, double scaleRight, int rightX, int rightY) {
        if (this.leftPts == null || this.rightPts == null) {
            return;
        }
        if (this.selected.isEmpty()) {
            this.drawPoints(g2, this.leftPts, leftX, leftY, scaleLeft);
            this.drawPoints(g2, this.rightPts, rightX, rightY, scaleRight);
            return;
        }
        if (this.selected.size() != 1) {
            System.err.println("Selected more than one feature!");
            return;
        }
        int selectedIndex = (Integer)this.selected.get(0);
        this.computeScore(this.selectedIsLeft, selectedIndex);
        if (this.selectedIsLeft) {
            this.drawCrossHair(g2, (Point2D_F64)this.leftPts.get(selectedIndex), leftX, leftY, scaleLeft);
        } else {
            this.drawCrossHair(g2, (Point2D_F64)this.rightPts.get(selectedIndex), rightX, rightY, scaleRight);
        }
        if (this.selectedIsLeft) {
            this.drawDistribution(g2, this.rightPts, rightX, rightY, scaleRight);
        } else {
            this.drawDistribution(g2, this.leftPts, leftX, leftY, scaleLeft);
        }
    }

    private void drawDistribution(Graphics2D g2, List<Point2D_F64> candidates, int offX, int offY, double scale) {
        Point2D_F64 p;
        this.findStatistics();
        g2.setColor(Color.RED);
        g2.setStroke(new BasicStroke(3.0f));
        double normalizer = this.scorer.getScoreType().isZeroBest() ? this.best * this.containmentFraction : Math.abs(this.best) * Math.exp(-1.0 / this.containmentFraction);
        for (int i = 0; i < candidates.size(); ++i) {
            int r;
            p = candidates.get(i);
            double s = this.associationScore[i];
            double ratio = 1.0 - Math.abs(s - this.best) / normalizer;
            if (ratio < 0.0 || (r = this.maxCircleRadius - (int)((double)this.maxCircleRadius * ratio)) <= 0) continue;
            int x = (int)(p.x * scale + (double)offX);
            int y = (int)(p.y * scale + (double)offY);
            g2.drawOval(x - r, y - r, r * 2 + 1, r * 2 + 1);
        }
        g2.setColor(Color.GREEN);
        g2.setStroke(new BasicStroke(10.0f));
        int w = this.maxCircleRadius * 2 + 1;
        p = candidates.get(this.indexBest);
        int x = (int)(p.x * scale + (double)offX);
        int y = (int)(p.y * scale + (double)offY);
        g2.drawOval(x - this.maxCircleRadius, y - this.maxCircleRadius, w, w);
    }

    private void drawPoints(Graphics2D g2, List<Point2D_F64> points, int startX, int startY, double scale) {
        for (Point2D_F64 p : points) {
            int x1 = (int)(scale * p.x) + startX;
            int y1 = (int)(scale * p.y) + startY;
            VisualizeFeatures.drawPoint(g2, x1, y1, Color.BLUE);
        }
    }

    private void drawCrossHair(Graphics2D g2, Point2D_F64 target, int startX, int startY, double scale) {
        int x = startX + (int)(target.x * scale);
        int y = startY + (int)(target.y * scale);
        int r = 10;
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(11.0f));
        g2.drawLine(x - r, y, x + r, y);
        g2.drawLine(x, y - r, x, y + r);
        g2.setColor(Color.RED);
        g2.setStroke(new BasicStroke(5.0f));
        g2.drawLine(x - r, y, x + r, y);
        g2.drawLine(x, y - r, x, y + r);
    }

    @Override
    protected boolean isValidPoint(int index) {
        return true;
    }

    private void findStatistics() {
        int N = this.selectedIsLeft ? this.rightPts.size() : this.leftPts.size();
        this.indexBest = -1;
        this.worst = -1.7976931348623157E308;
        this.best = Double.MAX_VALUE;
        for (int i = 0; i < N; ++i) {
            double s = this.associationScore[i];
            if (s > this.worst) {
                this.worst = s;
            }
            if (!(s < this.best)) continue;
            this.best = s;
            this.indexBest = i;
        }
    }
}

