/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.settings;

import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.dialogs.JSpringPanel;
import boofcv.gui.settings.GlobalDemoSettings;
import com.github.weisj.darklaf.LafManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GlobalSettingsControls
extends StandardAlgConfigPanel
implements ActionListener {
    GlobalDemoSettings settings = GlobalDemoSettings.SETTINGS.copy();
    JComboBox<String> comboThemes;
    JComboBox<String> comboControl3D;
    JCheckBox checkVerboseRuntime;
    JCheckBox checkVerboseTracking;
    JButton bSave;
    JButton bReset;
    boolean changedTheme;
    JDialog dialog;
    boolean canceled;

    public GlobalSettingsControls() {
        this.comboThemes = this.combo(this.settings.theme.ordinal(), (Object[])GlobalDemoSettings.ThemesUI.values());
        this.comboControl3D = this.combo(this.settings.controls3D.ordinal(), (Object[])GlobalDemoSettings.Controls3D.values());
        this.checkVerboseRuntime = this.checkbox("Verbose Runtime", this.settings.verboseRuntime);
        this.checkVerboseTracking = this.checkbox("Verbose Tracking", this.settings.verboseTracking);
        this.bSave = new JButton("Save");
        this.bReset = new JButton("Reset");
        this.changedTheme = false;
        this.canceled = false;
        this.bSave.addActionListener(e -> this.handleSave());
        this.bReset.addActionListener(e -> this.handleReset());
        this.addLabeled(this.comboThemes, "Themes", "Change the Swing theme");
        this.addLabeled(this.comboControl3D, "Control3D");
        this.addAlignLeft(this.checkVerboseRuntime, "Turn on verbose output to stdout");
        this.addAlignLeft(this.checkVerboseTracking, "Turn on verbose output to stdout");
        this.addVerticalGlue();
        JPanel foo = JSpringPanel.createLockedSides(this.bReset, this.bSave, 30);
        foo.setBorder(BorderFactory.createEmptyBorder(6, 10, 6, 10));
        foo.setPreferredSize(new Dimension(0, 40));
        foo.setMaximumSize(new Dimension(5000, 40));
        this.add(foo);
        this.setPreferredSize(new Dimension(250, 180));
    }

    private void handleSave() {
        GlobalDemoSettings.SETTINGS = this.settings;
        this.settings.save();
        this.dialog.setVisible(false);
    }

    private void handleReset() {
        GlobalDemoSettings.SETTINGS = new GlobalDemoSettings();
        GlobalDemoSettings.SETTINGS.save();
        this.handleCancel();
    }

    private void handleCancel() {
        this.canceled = true;
        this.dialog.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.comboThemes) {
            this.settings.theme = GlobalDemoSettings.ThemesUI.values()[this.comboThemes.getSelectedIndex()];
            this.changedTheme = true;
        } else if (e.getSource() == this.comboControl3D) {
            this.settings.controls3D = GlobalDemoSettings.Controls3D.values()[this.comboControl3D.getSelectedIndex()];
        } else if (e.getSource() == this.checkVerboseRuntime) {
            this.settings.verboseRuntime = this.checkVerboseRuntime.isSelected();
        } else if (e.getSource() == this.checkVerboseTracking) {
            this.settings.verboseTracking = this.checkVerboseTracking.isSelected();
        }
    }

    public void showDialog(JFrame owner, Component parent) {
        this.canceled = false;
        this.dialog = new JDialog((Window)owner, "Demonstration Settings", Dialog.ModalityType.APPLICATION_MODAL);
        try {
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    GlobalSettingsControls.this.handleCancel();
                }
            });
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)this, "Center");
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(parent);
            this.dialog.setVisible(true);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            System.err.println("Handling exception by resetting LAF");
            this.settings.theme = GlobalDemoSettings.ThemesUI.DEFAULT;
            this.settings.changeTheme();
            this.changedTheme = true;
        }
        this.dialog.dispose();
        this.dialog = null;
        if (!this.canceled && this.changedTheme) {
            this.settings.changeTheme();
            LafManager.updateLaf();
            JOptionPane.showMessageDialog(parent, "Restart to ensure the theme renders correctly");
        }
    }

    public static void main(String[] args) {
        GlobalSettingsControls controls = new GlobalSettingsControls();
        controls.showDialog(null, null);
    }
}

