/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.cloud.PointCloudReader;
import boofcv.core.image.ConvertImage;
import boofcv.gui.dialogs.FilePreviewChooser;
import boofcv.gui.dialogs.OpenImageSetDialog;
import boofcv.gui.dialogs.OpenStereoSequencesChooser;
import boofcv.gui.settings.GlobalDemoSettings;
import boofcv.io.image.ConvertImageMisc;
import boofcv.io.image.UtilImageIO;
import boofcv.io.points.PointCloudIO;
import boofcv.misc.BoofLambdas;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.visualize.PointCloudViewer;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.NumberFormatter;
import org.apache.commons.io.FilenameUtils;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class BoofSwingUtil {
    public static final String KEY_RECENT_FILES = "RecentFiles";
    public static final String KEY_PREVIOUS_SELECTION = "PreviouslySelected";
    public static final String KEY_PREVIOUS_DIRECTORY = "PreviousDirectory";
    public static final double MIN_ZOOM = 0.01;
    public static final double MAX_ZOOM = 50.0;

    public static void initializeSwing() {
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.textantialiasing", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Insets insets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        insets.bottom = 0;
        insets.left = 0;
        insets.right = 0;
        UIManager.put("TabbedPane.contentBorderInsets", insets);
        GlobalDemoSettings.SETTINGS.changeTheme();
    }

    public static void setVerboseWithDemoSettings(VerbosePrint v) {
        if (GlobalDemoSettings.SETTINGS.verboseRecursive) {
            v.setVerbose(System.out, BoofMiscOps.hashSet((Object[])new String[]{"recursive"}));
        } else {
            v.setVerbose(null, null);
        }
    }

    public static boolean isRightClick(MouseEvent e) {
        return e.getButton() == 3 || System.getProperty("os.name").contains("Mac OS X") && (e.getModifiers() & 0x10) != 0 && (e.getModifiers() & 2) != 0;
    }

    public static boolean isMiddleMouseButton(MouseEvent e) {
        boolean clicked = SwingUtilities.isMiddleMouseButton(e);
        return clicked |= e.isControlDown() && (e.getModifiersEx() & 0x100) != 0;
    }

    public static double mouseWheelImageZoom(double scale, MouseWheelEvent e) {
        if (e.getWheelRotation() > 0) {
            scale *= (double)e.getWheelRotation() * 1.1;
        } else if (e.getWheelRotation() < 0) {
            scale /= (double)(-e.getWheelRotation()) * 1.1;
        }
        return scale;
    }

    public static void recursiveEnable(JComponent panel, Boolean isEnabled) {
        Component[] components;
        panel.setEnabled(isEnabled);
        for (Component component : components = panel.getComponents()) {
            if (component instanceof JComponent) {
                BoofSwingUtil.recursiveEnable((JComponent)component, isEnabled);
            }
            component.setEnabled(isEnabled);
        }
    }

    public static File ensureSuffix(File f, String suffix) {
        String name = f.getName();
        if (!name.toLowerCase().endsWith(suffix)) {
            name = FilenameUtils.getBaseName((String)name) + suffix;
            f = new File(f.getParent(), name);
        }
        return f;
    }

    public static File saveFileChooser(Component parent, FileTypes ... filters) {
        return BoofSwingUtil.fileChooser(null, parent, false, new File(".").getPath(), null, filters);
    }

    public static String[] openImageSetChooser(Window parent, OpenImageSetDialog.Mode mode, int numberOfImages) {
        File defaultPath;
        Preferences prefs = parent == null ? Preferences.userRoot() : Preferences.userRoot().node(parent.getClass().getSimpleName());
        String previousPath = prefs.get(KEY_PREVIOUS_SELECTION, (defaultPath = BoofSwingUtil.directoryUserHome()).getPath());
        String[] response = OpenImageSetDialog.showDialog(new File(previousPath), mode, numberOfImages, parent);
        if (response != null) {
            prefs.put(KEY_PREVIOUS_SELECTION, new File(response[0]).getParent());
        }
        return response;
    }

    public static OpenStereoSequencesChooser.Selected openStereoChooser(Window parent, @Nullable Class<?> owner, boolean isSequence, boolean justImages) {
        File defaultPath;
        Preferences prefs = owner == null ? Preferences.userRoot() : Preferences.userRoot().node(owner.getSimpleName());
        String previousPath = prefs.get(KEY_PREVIOUS_SELECTION, (defaultPath = BoofSwingUtil.directoryUserHome()).getPath());
        OpenStereoSequencesChooser.Selected response = OpenStereoSequencesChooser.showDialog(parent, isSequence, justImages, new File(previousPath));
        if (response != null) {
            prefs.put(KEY_PREVIOUS_SELECTION, response.left.getParent());
        }
        return response;
    }

    public static String getDefaultPath(Object parent, String key) {
        File defaultPath = BoofSwingUtil.directoryUserHome();
        if (key == null) {
            return defaultPath.getPath();
        }
        Preferences prefs = parent == null ? Preferences.userRoot() : Preferences.userRoot().node(parent.getClass().getSimpleName());
        return prefs.get(key, defaultPath.getPath());
    }

    public static void saveDefaultPath(Object parent, String key, File file) {
        if (key == null) {
            return;
        }
        Preferences prefs = parent == null ? Preferences.userRoot() : Preferences.userRoot().node(parent.getClass().getSimpleName());
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        prefs.put(key, file.getAbsolutePath());
    }

    public static File openFileChooser(String preferenceName, FileTypes ... filters) {
        return BoofSwingUtil.fileChooser(preferenceName, null, true, new File(".").getPath(), null, filters);
    }

    public static File openFilePreview(String preferenceName, FileTypes ... filters) {
        return BoofSwingUtil.fileChooserPreview(preferenceName, null, true, new File(".").getPath(), filters);
    }

    public static File openFileChooser(Component parent, FileTypes ... filters) {
        return BoofSwingUtil.openFileChooser(parent, new File(".").getPath(), filters);
    }

    public static File openFilePreview(Component parent, FileTypes ... filters) {
        return BoofSwingUtil.fileChooserPreview(null, parent, true, new File(".").getPath(), filters);
    }

    public static File openFileChooser(Component parent, String defaultPath, FileTypes ... filters) {
        boolean directories = false;
        boolean images = false;
        block4: for (FileTypes filter : filters) {
            switch (filter) {
                case DIRECTORIES: {
                    directories = true;
                    continue block4;
                }
                case IMAGES: 
                case VIDEOS: {
                    images = true;
                    continue block4;
                }
            }
        }
        if (!directories && images) {
            return BoofSwingUtil.fileChooserPreview(null, parent, true, defaultPath, filters);
        }
        return BoofSwingUtil.fileChooser(null, parent, true, defaultPath, null, filters);
    }

    public static File fileChooser(@Nullable String preferenceName, Component parent, boolean openFile, String defaultPath, @Nullable BoofLambdas.MassageString massageName, FileTypes ... filters) {
        int returnVal;
        File currentDirectory;
        if (preferenceName == null && parent != null) {
            preferenceName = parent.getClass().getSimpleName();
        }
        Preferences prefs = preferenceName == null ? Preferences.userRoot() : Preferences.userRoot().node(preferenceName);
        File previousPath = new File(prefs.get(KEY_PREVIOUS_SELECTION, defaultPath));
        if (massageName != null) {
            previousPath = new File(massageName.process(previousPath.getPath()));
        }
        JFileChooser chooser = new JFileChooser();
        boolean selectDirectories = false;
        for (FileTypes t : filters) {
            FileFilter fileFilter;
            switch (t) {
                case FILES: {
                    fileFilter = new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return true;
                        }

                        @Override
                        public String getDescription() {
                            return "All";
                        }
                    };
                    break;
                }
                case YAML: {
                    fileFilter = new FileNameExtensionFilter("yaml", "yaml", "yml");
                    break;
                }
                case XML: {
                    fileFilter = new FileNameExtensionFilter("xml", "xml");
                    break;
                }
                case IMAGES: {
                    fileFilter = new FileNameExtensionFilter("Images", ImageIO.getReaderFileSuffixes());
                    break;
                }
                case VIDEOS: {
                    fileFilter = new FileNameExtensionFilter("Videos", "mpg", "mp4", "mov", "avi", "wmv");
                    break;
                }
                case DIRECTORIES: {
                    selectDirectories = true;
                    fileFilter = null;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown file type");
                }
            }
            FileFilter ff = fileFilter;
            if (ff == null) break;
            chooser.addChoosableFileFilter(ff);
        }
        if (selectDirectories) {
            if (filters.length == 1) {
                chooser.setFileSelectionMode(1);
            } else {
                chooser.setFileSelectionMode(2);
            }
        }
        if (chooser.getChoosableFileFilters().length > 1) {
            chooser.setFileFilter(chooser.getChoosableFileFilters()[1]);
        }
        if ((currentDirectory = previousPath.getParentFile()) != null && currentDirectory.exists()) {
            chooser.setCurrentDirectory(currentDirectory);
            chooser.setSelectedFile(previousPath);
        } else {
            chooser.setSelectedFile(new File(previousPath.getName()));
        }
        File selected = null;
        int n = returnVal = openFile ? chooser.showOpenDialog(parent) : chooser.showSaveDialog(parent);
        if (returnVal == 0) {
            selected = chooser.getSelectedFile();
            prefs.put(KEY_PREVIOUS_SELECTION, selected.getPath());
        }
        return selected;
    }

    public static File fileChooserPreview(String preferenceName, Component parent, boolean openFile, String defaultPath, FileTypes ... filters) {
        if (preferenceName == null && parent != null) {
            preferenceName = parent.getClass().getSimpleName();
        }
        Preferences prefs = preferenceName == null ? Preferences.userRoot() : Preferences.userRoot().node(preferenceName);
        File previousPath = new File(prefs.get(KEY_PREVIOUS_SELECTION, defaultPath)).getAbsoluteFile();
        FilePreviewChooser chooser = new FilePreviewChooser(openFile);
        block8: for (FileTypes t : filters) {
            FileFilter ff;
            switch (t) {
                case FILES: {
                    ff = new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return true;
                        }

                        @Override
                        public String getDescription() {
                            return "All";
                        }
                    };
                    break;
                }
                case YAML: {
                    ff = new FileNameExtensionFilter("yaml", "yaml", "yml");
                    break;
                }
                case XML: {
                    ff = new FileNameExtensionFilter("xml", "xml");
                    break;
                }
                case IMAGES: {
                    ff = new FileNameExtensionFilter("Images", UtilImageIO.IMAGE_SUFFIXES);
                    break;
                }
                case VIDEOS: {
                    ff = new FileNameExtensionFilter("Videos", "mpg", "mp4", "mov", "avi", "wmv");
                    break;
                }
                case DIRECTORIES: {
                    break block8;
                }
                default: {
                    throw new RuntimeException("Unknown file type");
                }
            }
            chooser.getBrowser().addFileFilter(ff);
        }
        chooser.getBrowser().setSelectedFile(previousPath);
        File selected = chooser.showDialog(parent);
        System.out.println("Chooser file " + selected);
        if (selected != null) {
            prefs.put(KEY_PREVIOUS_SELECTION, selected.getPath());
        }
        return selected;
    }

    public static List<RecentFiles> getListOfRecentFiles(Component parent) {
        return BoofSwingUtil.getListOfRecentFiles(parent.getClass().getSimpleName());
    }

    public static List<RecentFiles> getListOfRecentFiles(String preferenceName) {
        Preferences prefs = Preferences.userRoot().node(preferenceName);
        String encodedString = prefs.get(KEY_RECENT_FILES, "");
        if (encodedString.length() == 0) {
            return new ArrayList<RecentFiles>();
        }
        try {
            ArrayList<RecentFiles> results = new ArrayList<RecentFiles>();
            List decoded = (List)new Yaml().load(encodedString);
            for (Map d : decoded) {
                RecentFiles r = new RecentFiles();
                r.name = d.getOrDefault("name", "DefaultName");
                r.files = (List)d.get("files");
                results.add(r);
            }
            return results;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return new ArrayList<RecentFiles>();
        }
    }

    public static void addToRecentFiles(Component parent, String name, List<String> filePaths) {
        BoofSwingUtil.addToRecentFiles(parent.getClass().getSimpleName(), name, filePaths);
    }

    public static void addToRecentFiles(String preferenceName, String name, List<String> filePaths) {
        List<RecentFiles> files = BoofSwingUtil.getListOfRecentFiles(preferenceName);
        for (int i = 0; i < files.size(); ++i) {
            boolean matched = true;
            RecentFiles list = files.get(i);
            if (list.files.size() != filePaths.size()) {
                matched = false;
            }
            for (int j = 0; j < list.files.size() && matched; ++j) {
                if (list.files.get(j).equals(filePaths.get(j))) continue;
                matched = false;
            }
            if (!matched) continue;
            files.remove(i);
            break;
        }
        if (files.size() >= 10) {
            files.remove(9);
        }
        RecentFiles r = new RecentFiles();
        r.name = name;
        r.files = filePaths;
        files.add(0, r);
        BoofSwingUtil.saveRecentFiles(preferenceName, files);
    }

    public static void saveRecentFiles(String preferenceName, List<RecentFiles> files) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        String encoded = yaml.dump(BoofSwingUtil.encodeForYaml(files));
        Preferences prefs = Preferences.userRoot().node(preferenceName);
        prefs.put(KEY_RECENT_FILES, encoded);
    }

    public static void updateRecentItems(JComponent owner, @Nullable JMenu menuRecent, BoofLambdas.ProcessObject<RecentFiles> function) {
        if (menuRecent == null) {
            return;
        }
        menuRecent.removeAll();
        List<RecentFiles> recentFiles = BoofSwingUtil.getListOfRecentFiles(owner);
        for (RecentFiles info : recentFiles) {
            JMenuItem recentItem = new JMenuItem(info.name);
            recentItem.addActionListener(e -> function.process((Object)info));
            menuRecent.add(recentItem);
        }
        if (recentFiles.size() == 0) {
            return;
        }
        JMenuItem clearItem = new JMenuItem("Clear Recent");
        clearItem.addActionListener(e -> {
            menuRecent.removeAll();
            BoofSwingUtil.saveRecentFiles(owner.getClass().getSimpleName(), new ArrayList<RecentFiles>());
        });
        menuRecent.addSeparator();
        menuRecent.add(clearItem);
    }

    private static List<Map<String, Object>> encodeForYaml(List<RecentFiles> list) {
        ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>();
        for (RecentFiles r : list) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("name", r.name);
            m.put("files", r.files);
            output.add(m);
        }
        return output;
    }

    public static void invokeNowOrLater(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static void checkGuiThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Must be run in UI thread");
        }
    }

    public static void checkNotGuiThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Must NOT be run in UI thread");
        }
    }

    public static double selectZoomToShowAll(JComponent panel, int width, int height) {
        double scale;
        int w = panel.getWidth();
        int h = panel.getHeight();
        if (w == 0) {
            w = panel.getPreferredSize().width;
            h = panel.getPreferredSize().height;
        }
        if ((scale = Math.max((double)width / (double)w, (double)height / (double)h)) > 1.0) {
            return 1.0 / scale;
        }
        return 1.0;
    }

    public static double selectZoomToFitInDisplay(int width, int height) {
        double h;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double w = screenSize.getWidth();
        double scale = Math.max((double)width / w, (double)height / (h = screenSize.getHeight()));
        if (scale > 1.0) {
            return 1.0 / scale;
        }
        return 1.0;
    }

    public static JPanel gridPanel(int cols, Component ... children) {
        return BoofSwingUtil.gridPanel(0, 2, 0, 0, children);
    }

    public static JPanel gridPanel(int rows, int cols, int hgap, int vgap, Component ... children) {
        JPanel panel = new JPanel(new GridLayout(rows, cols, hgap, vgap));
        for (int i = 0; i < children.length; ++i) {
            panel.add(children[i]);
        }
        panel.setMaximumSize(panel.getPreferredSize());
        return panel;
    }

    public static JFormattedTextField createTextField(int current, int min, int max) {
        NumberFormat format = NumberFormat.getInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        if (Integer.MIN_VALUE != min) {
            formatter.setMinimum(Integer.valueOf(min));
        }
        if (Integer.MAX_VALUE != max) {
            formatter.setMaximum(Integer.valueOf(max));
        }
        formatter.setAllowsInvalid(true);
        JFormattedTextField field = new JFormattedTextField(formatter);
        field.setHorizontalAlignment(4);
        field.setValue(current);
        return field;
    }

    public static JFormattedTextField createTextField(double current, double min, double max) {
        NumberFormat format = NumberFormat.getInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Double.class);
        if (!Double.isNaN(min)) {
            formatter.setMinimum(Double.valueOf(min));
        }
        if (!Double.isNaN(max)) {
            formatter.setMaximum(Double.valueOf(max));
        }
        formatter.setAllowsInvalid(true);
        JFormattedTextField field = new JFormattedTextField(formatter);
        field.setHorizontalAlignment(4);
        field.setValue(current);
        return field;
    }

    public static JFormattedTextField createHexTextField(long current) {
        HexFormatter formatter = new HexFormatter();
        formatter.setValueClass(Long.class);
        formatter.setAllowsInvalid(true);
        JFormattedTextField field = new JFormattedTextField(formatter);
        field.setHorizontalAlignment(4);
        field.setValue(current);
        return field;
    }

    public static JComponent wrapBorder(JComponent comp) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)comp, "Center");
        return panel;
    }

    public static JMenuItem createMenuItem(String name, int mnmonic, int accelerator, BoofLambdas.ProcessCall action) {
        JMenuItem item = new JMenuItem(name);
        BoofSwingUtil.setMenuItemKeys(item, mnmonic, accelerator);
        item.addActionListener(e -> action.process());
        return item;
    }

    public static JMenuItem createMenuItem(String name, BoofLambdas.ProcessCall action) {
        JMenuItem item = new JMenuItem(name);
        item.addActionListener(e -> action.process());
        return item;
    }

    public static void setMenuItemKeys(JMenuItem menu, int mnmonic, int accelerator) {
        menu.setMnemonic(mnmonic);
        menu.setAccelerator(KeyStroke.getKeyStroke(accelerator, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    public static void warningDialog(Component component, Exception e) {
        JOptionPane.showMessageDialog(component, e.getMessage());
    }

    public static Graphics2D antialiasing(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return g2;
    }

    public static JButton createButtonIconGUI(String path, int width, int height) {
        return BoofSwingUtil.createButtonIcon("boofcv/gui/" + path, width, height, true);
    }

    public static JButton createButtonIcon(String path, int width, int height, boolean opaque) {
        try {
            BufferedImage b;
            URL url = ClassLoader.getSystemResource(path);
            if (url != null) {
                b = ImageIO.read(url);
                double scale = BoofSwingUtil.computeButtonScale(width, height, b.getWidth(), b.getHeight());
                if (scale != 1.0) {
                    width = (int)((double)b.getWidth() * scale);
                    height = (int)((double)b.getHeight() * scale);
                    BufferedImage a = new BufferedImage(width, height, 2);
                    Graphics2D g2 = a.createGraphics();
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    g2.drawImage(b, 0, 0, width, height, null);
                    b = a;
                }
            } else {
                JButton button = new JButton(path);
                int bWidth = button.getPreferredSize().width;
                int bHeight = button.getPreferredSize().height;
                double scale = BoofSwingUtil.computeButtonScale(width, height, bWidth, bHeight);
                button.setPreferredSize(new Dimension((int)(scale * (double)bWidth), (int)(scale * (double)bHeight)));
                return button;
            }
            JButton button = new JButton(new ImageIcon(b));
            if (!opaque) {
                button.setOpaque(false);
                button.setBackground(new Color(0, 0, 0, 0));
                button.setBorder(new EmptyBorder(0, 0, 0, 0));
            }
            button.setPreferredSize(new Dimension(width, height));
            return button;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static double computeButtonScale(int width, int height, double imageWidth, double imageHeight) {
        double scale = 1.0;
        if (width > 0 || height > 0) {
            scale = width <= 0 ? (double)height / imageHeight : (height <= 0 ? (double)width / imageWidth : Math.min((double)width / imageWidth, (double)height / imageHeight));
        }
        return scale;
    }

    public static JButton button(String name, ActionListener action) {
        JButton b = new JButton(name);
        b.addActionListener(action);
        return b;
    }

    public static JCheckBox checkbox(String name, boolean checked, ActionListener action) {
        JCheckBox b = new JCheckBox(name);
        if (action != null) {
            b.addActionListener(action);
        }
        b.setSelected(checked);
        return b;
    }

    public static File directoryUserHome() {
        String home = System.getProperty("user.home");
        if (home == null) {
            home = "";
        }
        return new File(home);
    }

    public static void savePointCloudDialog(Component owner, String key, PointCloudViewer pcv) {
        String path = BoofSwingUtil.getDefaultPath(owner, key);
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(new File(path, "pointcloud.ply"));
        if (fileChooser.showSaveDialog(owner) == 0) {
            File file = fileChooser.getSelectedFile();
            BoofSwingUtil.saveDefaultPath(owner, key, file);
            DogArray cloud = pcv.copyCloud(null);
            String n = FilenameUtils.getBaseName((String)file.getName()) + ".ply";
            try {
                File f = new File(file.getParent(), n);
                FileOutputStream w = new FileOutputStream(f);
                PointCloudIO.save3D((PointCloudIO.Format)PointCloudIO.Format.PLY, (PointCloudReader)PointCloudReader.wrapF64RGB((List)cloud.toList()), (boolean)true, (OutputStream)w);
                w.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveListSe3Dialog(Component owner, String key, PointCloudViewer pcv) {
        String path = BoofSwingUtil.getDefaultPath(owner, key);
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(new File(path, "pointcloud.ply"));
        if (fileChooser.showSaveDialog(owner) == 0) {
            File file = fileChooser.getSelectedFile();
            BoofSwingUtil.saveDefaultPath(owner, key, file);
            DogArray cloud = pcv.copyCloud(null);
            String n = FilenameUtils.getBaseName((String)file.getName()) + ".ply";
            try {
                File f = new File(file.getParent(), n);
                FileOutputStream w = new FileOutputStream(f);
                PointCloudIO.save3D((PointCloudIO.Format)PointCloudIO.Format.PLY, (PointCloudReader)PointCloudReader.wrapF64RGB((List)cloud.toList()), (boolean)true, (OutputStream)w);
                w.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveDisparityDialog(JComponent owner, String key, ImageGray d) {
        String path = BoofSwingUtil.getDefaultPath(owner, key);
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(new File(path, "disparity.png"));
        fileChooser.setDialogTitle("Save Disparity Image");
        if (fileChooser.showSaveDialog(owner) == 0) {
            GrayF32 disparity;
            File file = fileChooser.getSelectedFile();
            BoofSwingUtil.saveDefaultPath(owner, key, file);
            if (d instanceof GrayF32) {
                disparity = (GrayF32)d;
            } else {
                disparity = new GrayF32(d.width, d.height);
                ConvertImage.convert((GrayU8)((GrayU8)d), (GrayF32)disparity);
            }
            GrayU16 output = new GrayU16(disparity.width, disparity.height);
            ConvertImageMisc.convert_F32_U16((GrayF32)disparity, (int)8, (GrayU16)output);
            file = BoofSwingUtil.ensureSuffix(file, ".png");
            UtilImageIO.saveImage((ImageBase)output, (String)file.getAbsolutePath());
        }
    }

    public static void visualizeCameras(SceneStructureMetric structure, PointCloudViewer viewer) {
        DogArray vertexes = new DogArray(Point3D_F64::new);
        Se3_F64 world_to_view = new Se3_F64();
        Se3_F64 view_to_world = new Se3_F64();
        Se3_F64 tmpSE3 = new Se3_F64();
        double r = 0.1;
        structure.views.forEach(v -> {
            Point3D_F64 p;
            int j;
            structure.getWorldToView(v, world_to_view, tmpSE3).invert(view_to_world);
            vertexes.reset();
            ((Point3D_F64)vertexes.grow()).setTo(-r, -r, 0.0);
            ((Point3D_F64)vertexes.grow()).setTo(r, -r, 0.0);
            ((Point3D_F64)vertexes.grow()).setTo(r, r, 0.0);
            ((Point3D_F64)vertexes.grow()).setTo(-r, r, 0.0);
            for (j = 0; j < vertexes.size; ++j) {
                p = (Point3D_F64)vertexes.get(j);
                SePointOps_F64.transform((Se3_F64)view_to_world, (Point3D_F64)p, (Point3D_F64)p);
            }
            viewer.addWireFrame(vertexes.toList(), true, 0xFF0000, 1);
            vertexes.reset();
            ((Point3D_F64)vertexes.grow()).setTo(0.0, 0.0, 0.0);
            ((Point3D_F64)vertexes.grow()).setTo(0.0, 0.0, r);
            for (j = 0; j < vertexes.size; ++j) {
                p = (Point3D_F64)vertexes.get(j);
                SePointOps_F64.transform((Se3_F64)view_to_world, (Point3D_F64)p, (Point3D_F64)p);
            }
            viewer.addWireFrame(vertexes.toList(), false, 255, 1);
        });
    }

    public static enum FileTypes {
        FILES,
        YAML,
        XML,
        IMAGES,
        VIDEOS,
        DIRECTORIES;

    }

    public static class RecentFiles {
        public String name;
        public List<String> files;
    }

    private static class HexFormatter
    extends DefaultFormatter {
        private HexFormatter() {
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            if (text == null) {
                return 0L;
            }
            try {
                if (text.startsWith("0x")) {
                    text = text.substring(2);
                }
                return Long.valueOf(text, 16);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(text, 0);
            }
        }

        @Override
        public String valueToString(Object value) {
            if (value == null) {
                return "";
            }
            return "0x" + Long.toHexString((Long)value).toUpperCase();
        }
    }
}

