/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.dialogs;

import boofcv.gui.BoofSwingUtil;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.dialogs.JSpringPanel;
import boofcv.gui.image.ImagePanel;
import boofcv.io.calibration.CalibrationIO;
import boofcv.io.image.UtilImageIO;
import boofcv.misc.BoofLambdas;
import boofcv.struct.calib.StereoParameters;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nullable;

public class OpenStereoSequencesChooser
extends JSpringPanel {
    private static final int PREVIEW_PIXELS = 300;
    protected Listener listener;
    JTextField textLeftPath = OpenStereoSequencesChooser.createTextWidget();
    JTextField textRightPath = OpenStereoSequencesChooser.createTextWidget();
    JTextField textCalibrationPath = OpenStereoSequencesChooser.createTextWidget();
    ImagePanel previewLeft = new ImagePanel();
    ImagePanel previewRight = new ImagePanel();
    JPanel leftPathPanel;
    JPanel rightPathPanel;
    JCheckBox cSplit = new JCheckBox("Split", false);
    JButton bCancel = new JButton("Cancel");
    JButton bOK = new JButton("OK");
    File directory;
    StereoParameters stereoParameters;
    boolean justImages;

    public OpenStereoSequencesChooser(JDialog dialog, Listener listener, File directory, boolean justImages) {
        this.listener = listener;
        this.directory = directory;
        this.justImages = justImages;
        JPanel previewPanel = new JPanel();
        previewPanel.setLayout(new BoxLayout(previewPanel, 0));
        previewPanel.add(this.previewLeft);
        previewPanel.add(this.previewRight);
        int ip = 340;
        this.previewLeft.setPreferredSize(new Dimension(ip, ip));
        this.previewRight.setPreferredSize(new Dimension(ip, ip));
        this.cSplit.addActionListener(e -> this.handleSplit());
        this.configureButtons(dialog, listener);
        JPanel buttonPanel = StandardAlgConfigPanel.createHorizontalPanel(this.bCancel, Box.createHorizontalGlue(), this.bOK);
        this.leftPathPanel = this.createPathPanel("Left", this.textLeftPath, this::handleLeftPath);
        this.rightPathPanel = this.createPathPanel("Right", this.textRightPath, this::handleRightPath);
        this.constrainWestNorthEast(this.leftPathPanel, null, 6, 6);
        this.constrainWestNorthEast(this.rightPathPanel, this.leftPathPanel, 6, 6);
        if (!justImages) {
            JPanel calibPanel = this.createPathPanel("Calibration", this.textCalibrationPath, this::handleCalibrationPath);
            this.constrainWestNorthEast(calibPanel, this.rightPathPanel, 6, 6);
            this.constrainWestNorthEast(previewPanel, calibPanel, 6, 6);
        } else {
            this.constrainWestNorthEast(previewPanel, this.rightPathPanel, 6, 6);
        }
        this.constrainWestSouthEast(this.cSplit, buttonPanel, 10, 10);
        this.constrainWestSouthEast(buttonPanel, null, 10, 10);
        this.layout.putConstraint("South", (Component)previewPanel, -5, "North", (Component)this.cSplit);
        this.setPreferredSize(new Dimension(500, 400));
    }

    private void configureButtons(JDialog dialog, Listener listener) {
        this.bCancel.setMaximumSize(this.bCancel.getPreferredSize());
        this.bOK.setMaximumSize(this.bOK.getPreferredSize());
        this.bCancel.setMinimumSize(this.bCancel.getPreferredSize());
        this.bOK.setMinimumSize(this.bOK.getPreferredSize());
        this.bOK.setEnabled(false);
        this.bOK.setDefaultCapable(true);
        SwingUtilities.getRootPane(dialog).setDefaultButton(this.bOK);
        this.bCancel.addActionListener(e -> listener.userCanceled());
        this.bOK.addActionListener(e -> this.handleOK());
    }

    private void handleOK() {
        File left = new File(this.textLeftPath.getText());
        File right = this.cSplit.isSelected() ? null : new File(this.textRightPath.getText());
        File calibration = this.justImages ? null : new File(this.textCalibrationPath.getText());
        this.listener.selectedInputs(left, right, calibration);
    }

    private void handleSplit() {
        if (this.cSplit.isSelected()) {
            this.textRightPath.setText("");
        }
        BoofSwingUtil.recursiveEnable(this.rightPathPanel, !this.cSplit.isSelected());
        this.checkEverythingSet();
    }

    private void handleLeftPath() {
        this.handleSelectSequence(this.textLeftPath, this.previewLeft);
    }

    private void handleRightPath() {
        this.handleSelectSequence(this.textRightPath, this.previewRight);
    }

    private void handleCalibrationPath() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setCurrentDirectory(this.directory);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File selected = fc.getSelectedFile();
        try {
            this.stereoParameters = (StereoParameters)CalibrationIO.load((File)selected);
            this.textCalibrationPath.setText(selected.getPath());
            this.directory = selected.getParentFile();
            this.checkEverythingSet();
        }
        catch (RuntimeException e) {
            BoofSwingUtil.warningDialog(this, e);
        }
    }

    private void checkEverythingSet() {
        boolean allGood;
        boolean bl = allGood = !this.textLeftPath.getText().isEmpty();
        if (!this.cSplit.isSelected()) {
            allGood &= !this.textRightPath.getText().isEmpty();
        }
        if (!this.justImages) {
            allGood &= !this.textCalibrationPath.getText().isEmpty();
        }
        this.bOK.setEnabled(allGood);
    }

    private void handleSelectSequence(JTextField textArea, ImagePanel previewPanel) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(2);
        fc.setCurrentDirectory(this.directory);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File selected = fc.getSelectedFile();
        textArea.setText(selected.getPath());
        this.setPreview(selected, previewPanel);
        this.checkEverythingSet();
        this.directory = selected.getParentFile();
    }

    private void setPreview(File path, ImagePanel previewPanel) {
        BufferedImage preview = null;
        if (path.isDirectory()) {
            File f = this.findFirstImageInDirectory(path);
            if (f != null) {
                preview = UtilImageIO.loadImage((String)f.getAbsolutePath());
            }
        } else {
            preview = UtilImageIO.loadImage((String)path.getAbsolutePath());
        }
        previewPanel.setImageRepaint(preview);
    }

    private File findFirstImageInDirectory(File directory) {
        String first = null;
        File[] files = directory.listFiles();
        if (files == null) {
            return null;
        }
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory() || !UtilImageIO.isImage((File)f) || first != null && first.compareTo(f.getName()) >= 0) continue;
            first = f.getName();
        }
        if (first != null) {
            return new File(directory, first);
        }
        return null;
    }

    void handleCancel() {
        this.listener.userCanceled();
    }

    private JPanel createPathPanel(String name, JTextField text, BoofLambdas.ProcessCall callback) {
        JLabel label = new JLabel(name);
        label.setPreferredSize(new Dimension(100, 30));
        JButton bOpen = new JButton();
        bOpen.setIcon(UIManager.getIcon("FileView.directoryIcon"));
        bOpen.setMaximumSize(bOpen.getPreferredSize());
        bOpen.addActionListener(e -> callback.process());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(label);
        panel.add(text);
        panel.add(Box.createRigidArea(new Dimension(10, 5)));
        panel.add(bOpen);
        return panel;
    }

    private static JTextField createTextWidget() {
        JTextField textArea = new JTextField();
        textArea.setEditable(false);
        return textArea;
    }

    @Nullable
    public static Selected showDialog(Window owner, boolean sequences, boolean justImages, File path) {
        if (!sequences) {
            throw new RuntimeException("Not yet supported");
        }
        JDialog dialog = new JDialog(owner, "Open Stereo Sequence", Dialog.ModalityType.APPLICATION_MODAL);
        DefaultListener listener = new DefaultListener(dialog);
        final OpenStereoSequencesChooser panel = new OpenStereoSequencesChooser(dialog, listener, path, justImages);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                panel.handleCancel();
            }
        });
        dialog.setDefaultCloseOperation(0);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)panel, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
        dialog.dispose();
        if (listener.canceled) {
            return null;
        }
        return listener.selected;
    }

    public static interface Listener {
        public void selectedInputs(File var1, File var2, File var3);

        public void userCanceled();
    }

    public static class DefaultListener
    implements Listener {
        JDialog dialog;
        public boolean canceled = false;
        public final Selected selected = new Selected();

        public DefaultListener(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void selectedInputs(File left, File right, File calibration) {
            this.selected.left = left;
            this.selected.right = right;
            this.selected.calibration = calibration;
            this.dialog.setVisible(false);
        }

        @Override
        public void userCanceled() {
            this.canceled = true;
            this.dialog.setVisible(false);
        }
    }

    public static class Selected {
        public File left;
        @Nullable
        public File right;
        @Nullable
        public File calibration;

        public boolean isSplit() {
            return this.right == null;
        }
    }
}

