/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import georegression.geometry.UtilPoint2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.ddogleg.struct.DogArray_I32;

public abstract class CompareTwoImagePanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private double clickDistance = 20.0;
    protected List<Point2D_F64> leftPts;
    protected List<Point2D_F64> rightPts;
    List<Integer> selected = new ArrayList<Integer>();
    protected boolean selectedIsLeft;
    protected boolean selectRegion;
    protected int borderSize;
    protected BufferedImage leftImage;
    protected BufferedImage rightImage;
    protected double scaleLeft;
    protected double scaleRight;
    protected Point2D_I32 firstClick;
    protected Point2D_I32 mousePosition = new Point2D_I32();

    protected CompareTwoImagePanel(int borderSize, boolean canSelectRegion) {
        this.borderSize = borderSize;
        this.selectRegion = canSelectRegion;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setLocation(List<Point2D_F64> leftPts, List<Point2D_F64> rightPts) {
        this.leftPts = leftPts;
        this.rightPts = rightPts;
        this.selected.clear();
    }

    public void setPreferredSize(int widthLeft, int heightLeft, int widthRight, int heightRight) {
        int width = widthLeft + widthRight + this.borderSize;
        int height = Math.max(heightLeft, heightRight);
        this.setPreferredSize(new Dimension(width, height));
    }

    public synchronized void setImages(BufferedImage leftImage, BufferedImage rightImage) {
        this.leftImage = leftImage;
        this.rightImage = rightImage;
        this.setPreferredSize(leftImage.getWidth(), leftImage.getHeight(), rightImage.getWidth(), rightImage.getHeight());
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.leftImage == null || this.rightImage == null) {
            return;
        }
        this.computeScales();
        Graphics2D g2 = (Graphics2D)g;
        int x1 = (int)(this.scaleLeft * (double)this.leftImage.getWidth());
        int x2 = x1 + this.borderSize;
        int x3 = x2 + (int)(this.scaleRight * (double)this.rightImage.getWidth());
        int y1 = (int)(this.scaleLeft * (double)this.leftImage.getHeight());
        int y2 = (int)(this.scaleRight * (double)this.rightImage.getHeight());
        g2.drawImage(this.leftImage, 0, 0, x1, y1, 0, 0, this.leftImage.getWidth(), this.leftImage.getHeight(), null);
        g2.drawImage(this.rightImage, x2, 0, x3, y2, 0, 0, this.rightImage.getWidth(), this.rightImage.getHeight(), null);
        this.drawFeatures(g2, this.scaleLeft, 0, 0, this.scaleRight, x2, 0);
        if (this.selectRegion && this.firstClick != null) {
            int x0 = this.mousePosition.getX() < this.firstClick.x ? this.mousePosition.getX() : this.firstClick.x;
            x1 = this.mousePosition.getX() >= this.firstClick.x ? this.mousePosition.getX() : this.firstClick.x;
            int y0 = this.mousePosition.getY() < this.firstClick.y ? this.mousePosition.getY() : this.firstClick.y;
            y1 = this.mousePosition.getY() >= this.firstClick.y ? this.mousePosition.getY() : this.firstClick.y;
            g2.setColor(Color.WHITE);
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawRect(x0, y0, x1 - x0, y1 - y0);
            g2.setColor(Color.BLACK);
            g2.setStroke(new BasicStroke(1.0f));
            g2.drawRect(x0, y0, x1 - x0, y1 - y0);
        }
    }

    protected abstract void drawFeatures(Graphics2D var1, double var2, int var4, int var5, double var6, int var8, int var9);

    private void computeScales() {
        double scaleY;
        double scaleX;
        int width = this.getWidth();
        int height = this.getHeight();
        width = (width - this.borderSize) / 2;
        this.scaleRight = 1.0;
        this.scaleLeft = 1.0;
        if (this.leftImage.getWidth() > width || this.leftImage.getHeight() > height) {
            scaleX = (double)width / (double)this.leftImage.getWidth();
            scaleY = (double)height / (double)this.leftImage.getHeight();
            this.scaleLeft = Math.min(scaleX, scaleY);
        }
        if (this.rightImage.getWidth() > width || this.rightImage.getHeight() > height) {
            scaleX = (double)width / (double)this.rightImage.getWidth();
            scaleY = (double)height / (double)this.rightImage.getHeight();
            this.scaleRight = Math.min(scaleX, scaleY);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.firstClick = null;
        this.selected.clear();
        if (e.getClickCount() > 1) {
            this.repaint();
            return;
        }
        int leftEndX = (int)(this.scaleLeft * (double)this.leftImage.getWidth());
        int rightBeginX = leftEndX + this.borderSize;
        if (e.getX() < leftEndX) {
            this.selectedIsLeft = true;
            int x = (int)((double)e.getX() / this.scaleLeft);
            int y = (int)((double)e.getY() / this.scaleLeft);
            this.findBestPoints(x, y, this.leftPts, this.selected);
        } else if (e.getX() >= rightBeginX) {
            this.selectedIsLeft = false;
            int x = (int)((double)(e.getX() - rightBeginX) / this.scaleRight);
            int y = (int)((double)e.getY() / this.scaleRight);
            this.findBestPoints(x, y, this.rightPts, this.selected);
        }
        this.repaint();
    }

    private void findBestPoints(int x, int y, List<Point2D_F64> pts, List<Integer> selected) {
        int i;
        double bestDist = this.clickDistance * this.clickDistance;
        DogArray_I32 bestIndexes = new DogArray_I32(20);
        for (i = 0; i < pts.size(); ++i) {
            if (!this.isValidPoint(i)) continue;
            Point2D_F64 p = pts.get(i);
            double d = UtilPoint2D_F64.distanceSq((double)p.x, (double)p.y, (double)x, (double)y);
            if (d < bestDist) {
                bestDist = d;
                bestIndexes.reset();
                bestIndexes.add(i);
                continue;
            }
            if (!(Math.abs(d - bestDist) < 0.01)) continue;
            bestIndexes.add(i);
        }
        for (i = 0; i < bestIndexes.size(); ++i) {
            selected.add(bestIndexes.get(i));
        }
    }

    protected abstract boolean isValidPoint(int var1);

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.selectRegion) {
            this.firstClick = new Point2D_I32(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        double scale;
        if (!this.selectRegion) {
            return;
        }
        int leftEndX = (int)(this.scaleLeft * (double)this.leftImage.getWidth());
        int rightBeginX = leftEndX + this.borderSize;
        this.selectedIsLeft = e.getX() < leftEndX;
        int x0 = e.getX() < this.firstClick.x ? e.getX() : this.firstClick.x;
        int x1 = e.getX() >= this.firstClick.x ? e.getX() : this.firstClick.x;
        int y0 = e.getY() < this.firstClick.y ? e.getY() : this.firstClick.y;
        int y1 = e.getY() >= this.firstClick.y ? e.getY() : this.firstClick.y;
        double d = scale = this.selectedIsLeft ? this.scaleLeft : this.scaleRight;
        if (this.selectedIsLeft) {
            x0 = (int)((double)x0 / scale);
            x1 = (int)((double)x1 / scale);
        } else {
            x0 = (int)((double)(x0 - rightBeginX) / scale);
            x1 = (int)((double)(x1 - rightBeginX) / scale);
        }
        y0 = (int)((double)y0 / scale);
        y1 = (int)((double)y1 / scale);
        if (this.selectedIsLeft) {
            this.findPointsInRegion(x0, y0, x1, y1, this.leftPts);
        } else {
            this.findPointsInRegion(x0, y0, x1, y1, this.rightPts);
        }
        this.firstClick = null;
        this.repaint();
    }

    private void findPointsInRegion(int x0, int y0, int x1, int y1, List<Point2D_F64> pts) {
        this.selected.clear();
        for (int i = 0; i < pts.size(); ++i) {
            if (!this.isValidPoint(i)) continue;
            Point2D_F64 p = pts.get(i);
            if (!(p.x >= (double)x0) || !(p.x < (double)x1) || !(p.y >= (double)y0) || !(p.y < (double)y1)) continue;
            this.selected.add(i);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.selectRegion) {
            this.mousePosition.x = e.getX();
            this.mousePosition.y = e.getY();
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

