/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.gui.image.SaveImageOnClick;
import boofcv.io.image.ConvertBufferedImage;
import georegression.struct.point.Point2D_F64;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ImageZoomPanel
extends JScrollPane {
    protected BufferedImage img;
    protected ImagePanel panel = new ImagePanel();
    public boolean autoScaleCenterOnSetImage = true;
    private boolean hasImageChanged = false;
    protected double scale = 1.0;
    protected double transX = 0.0;
    protected double transY = 0.0;
    boolean checkEventDispatch = true;
    protected ImageZoomListener listener;

    public ImageZoomPanel(BufferedImage img) {
        this.img = img;
        this.setScale(1.0);
    }

    public ImageZoomPanel() {
        this.getViewport().setView(this.panel);
    }

    public void disableSaveOnClick() {
        this.panel.removeMouseListener(this.panel.mouseListener);
        this.panel.mouseListener = null;
    }

    public void autoScaleAndAlign() {
        this.autoScaleAndAlign(this.img);
    }

    private void autoScaleAndAlign(BufferedImage img) {
        double ratioH;
        double ratioW = (double)this.getWidth() / (double)img.getWidth();
        double scale = Math.min(ratioW, ratioH = (double)this.getHeight() / (double)img.getHeight());
        if (scale >= 1.0) {
            scale = 1.0;
        }
        boolean scaleChange = this.scale != scale;
        this.scale = scale;
        if (scaleChange) {
            if (this.listener != null) {
                this.listener.handleScaleChange(this.scale);
            }
            this.updateSize(img.getWidth(), img.getHeight());
        }
        this.getHorizontalScrollBar().setValue(0);
        this.getVerticalScrollBar().setValue(0);
    }

    public synchronized void setScale(double scale) {
        if (this.scale == scale) {
            return;
        }
        Rectangle r = this.panel.getVisibleRect();
        double centerX = ((double)r.x + (double)r.width / 2.0) / this.scale;
        double centerY = ((double)r.y + (double)r.height / 2.0) / this.scale;
        this.scale = scale;
        if (this.img != null) {
            int w = (int)Math.ceil((double)this.img.getWidth() * scale);
            int h = (int)Math.ceil((double)this.img.getHeight() * scale);
            this.panel.setPreferredSize(new Dimension(w, h));
        }
        this.getViewport().setView(this.panel);
        this.centerView(centerX, centerY);
        ImageZoomListener listener = this.listener;
        if (listener != null) {
            listener.handleScaleChange(this.scale);
        }
    }

    public synchronized void setScaleAndCenter(double scale, double cx, double cy) {
        ImageZoomListener listener;
        boolean scaleChanged = false;
        if (scale != this.scale) {
            scaleChanged = true;
            this.scale = scale;
        }
        if (this.img != null) {
            int w = (int)Math.ceil((double)this.img.getWidth() * scale);
            int h = (int)Math.ceil((double)this.img.getHeight() * scale);
            this.panel.setPreferredSize(new Dimension(w, h));
        }
        this.getViewport().setView(this.panel);
        this.centerView(cx, cy);
        if (scaleChanged && (listener = this.listener) != null) {
            listener.handleScaleChange(this.scale);
        }
    }

    public synchronized void centerView(double cx, double cy) {
        Rectangle r = this.panel.getVisibleRect();
        int x = (int)(cx * this.scale - (double)(r.width / 2));
        int y = (int)(cy * this.scale - (double)(r.height / 2));
        this.getHorizontalScrollBar().setValue(x);
        this.getVerticalScrollBar().setValue(y);
    }

    public synchronized void setImage(BufferedImage image) {
        if (this.checkEventDispatch && this.img != null && !SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Changed image when not in GUI thread?");
        }
        this.hasImageChanged = this.img != image;
        int beforeWidth = -1;
        int beforeHeight = -1;
        if (this.img != null) {
            beforeWidth = this.img.getWidth();
            beforeHeight = this.img.getHeight();
        }
        this.setBufferedImageNoChange(image);
        if (image != null && this.hasImageChanged && beforeWidth != image.getWidth() && beforeHeight != image.getHeight()) {
            this.updateSize(image.getWidth(), image.getHeight());
        }
    }

    public void updateSize(int width, int height) {
        Dimension prev = this.getPreferredSize();
        int w = (int)Math.ceil((double)width * this.scale);
        int h = (int)Math.ceil((double)height * this.scale);
        if (prev.getWidth() != (double)w || prev.getHeight() != (double)h) {
            this.panel.setPreferredSize(new Dimension(w, h));
            this.getViewport().setView(this.panel);
        }
    }

    public synchronized void setBufferedImageNoChange(BufferedImage image) {
        if (this.checkEventDispatch && this.img != null && !SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Changed image when not in GUI thread?");
        }
        this.img = image;
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public Point2D_F64 pixelToPoint(int x, int y) {
        Point2D_F64 ret = new Point2D_F64();
        ret.x = (double)x / this.scale;
        ret.y = (double)y / this.scale;
        return ret;
    }

    protected void paintInPanel(AffineTransform tran, Graphics2D g2) {
    }

    protected void paintOverPanel(Graphics2D g2) {
    }

    public void setScrollbarsVisible(boolean visible) {
        if (visible) {
            this.setVerticalScrollBarPolicy(22);
            this.setHorizontalScrollBarPolicy(32);
        } else {
            this.setVerticalScrollBarPolicy(21);
            this.setHorizontalScrollBarPolicy(31);
        }
        this.repaint();
    }

    public double getScale() {
        return this.scale;
    }

    public ImagePanel getImagePanel() {
        return this.panel;
    }

    public ImageZoomListener getListener() {
        return this.listener;
    }

    public void setListener(ImageZoomListener listener) {
        this.listener = listener;
    }

    public class ImagePanel
    extends JPanel {
        SaveImageOnClick mouseListener;
        BufferedImage buffer;

        public ImagePanel() {
            this.mouseListener = new SaveImageOnClick(ImageZoomPanel.this.getViewport());
            this.buffer = new BufferedImage(1, 1, 2);
            this.addMouseListener(this.mouseListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (ImageZoomPanel.this.img == null) {
                ImageZoomPanel.this.paintOverPanel((Graphics2D)g);
                return;
            }
            if (ImageZoomPanel.this.hasImageChanged) {
                ImageZoomPanel.this.hasImageChanged = false;
                if (ImageZoomPanel.this.autoScaleCenterOnSetImage) {
                    ImageZoomPanel.this.autoScaleAndAlign();
                }
            }
            Graphics2D panelGraphics = (Graphics2D)g;
            int w = ImageZoomPanel.this.getWidth();
            int h = ImageZoomPanel.this.getHeight();
            this.buffer = ConvertBufferedImage.checkDeclare((int)w, (int)h, (BufferedImage)this.buffer, (int)this.buffer.getType());
            Graphics2D bufferGraphics = this.buffer.createGraphics();
            bufferGraphics.setColor(this.getBackground());
            bufferGraphics.fillRect(0, 0, w, h);
            ImageZoomPanel.this.transX = -ImageZoomPanel.this.getHorizontalScrollBar().getValue();
            ImageZoomPanel.this.transY = -ImageZoomPanel.this.getVerticalScrollBar().getValue();
            AffineTransform tran = new AffineTransform(ImageZoomPanel.this.scale, 0.0, 0.0, ImageZoomPanel.this.scale, ImageZoomPanel.this.transX, ImageZoomPanel.this.transY);
            ImageZoomPanel imageZoomPanel = ImageZoomPanel.this;
            synchronized (imageZoomPanel) {
                bufferGraphics.drawImage(ImageZoomPanel.this.img, tran, null);
            }
            AffineTransform orig = bufferGraphics.getTransform();
            tran = new AffineTransform(1.0, 0.0, 0.0, 1.0, ImageZoomPanel.this.transX, ImageZoomPanel.this.transY);
            bufferGraphics.setTransform(tran);
            ImageZoomPanel.this.paintInPanel(tran, bufferGraphics);
            bufferGraphics.setTransform(orig);
            panelGraphics.drawImage((Image)this.buffer, (int)(-ImageZoomPanel.this.transX), (int)(-ImageZoomPanel.this.transY), null);
            ImageZoomPanel.this.paintOverPanel(panelGraphics);
        }
    }

    public static interface ImageZoomListener {
        public void handleScaleChange(double var1);
    }
}

