/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.calibration;

import boofcv.alg.distort.AdjustmentType;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.alg.distort.LensDistortionOps_F32;
import boofcv.alg.geo.RectifyDistortImageOps;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.gui.calibration.DisplayCalibrationPanel;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.border.BorderType;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.DoNothing2Transform2_F32;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.point.Point2D_F64;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrixRMaj;
import org.ejml.ops.ConvertMatrixData;
import org.jetbrains.annotations.Nullable;

public class DisplayPinholeCalibrationPanel
extends DisplayCalibrationPanel {
    int selectedImage;
    @Nullable
    BufferedImage distorted;
    BufferedImage undistorted;
    Planar<GrayF32> origMS = new Planar(GrayF32.class, 1, 1, 3);
    Planar<GrayF32> correctedMS = new Planar(GrayF32.class, 1, 1, 3);
    @Nullable
    ImageDistort<GrayF32, GrayF32> undoRadial;
    int lineY = -1;
    protected Point2Transform2_F32 doNothing;
    protected Point2Transform2_F32 remove_p_to_p = this.doNothing = new DoNothing2Transform2_F32();

    public DisplayPinholeCalibrationPanel() {
        this.panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DisplayPinholeCalibrationPanel.this.panel.requestFocus();
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                Point2D_F64 p = DisplayPinholeCalibrationPanel.this.pixelToPoint(e.getX(), e.getY());
                DisplayPinholeCalibrationPanel.this.centerView(p.x, p.y);
            }
        });
    }

    @Override
    public synchronized void setBufferedImageNoChange(@Nullable BufferedImage image) {
        this.distorted = image;
        this.undoRadialDistortion(this.distorted);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.showUndistorted) {
            this.img = this.undistorted;
            this.pixelTransform = this.remove_p_to_p;
        } else {
            this.img = this.distorted;
            this.pixelTransform = this.doNothing;
        }
        super.paintComponent(g);
    }

    @Override
    protected void paintInPanel(AffineTransform tran, Graphics2D g2) {
        if (this.observation != null && this.observation.size() > this.selectedImage) {
            this.drawFeatures(g2, this.scale);
        }
        if (this.lineY > -1) {
            g2.setColor(Color.RED);
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawLine(0, this.lineY, this.getWidth(), this.lineY);
        }
    }

    public void recomputeRectification() {
        this.undoRadialDistortion(this.distorted);
        this.repaint();
    }

    private void undoRadialDistortion(@Nullable BufferedImage image) {
        if (this.undoRadial == null || image == null) {
            return;
        }
        ConvertBufferedImage.convertFrom((BufferedImage)image, this.origMS, (boolean)true);
        if (this.correctedMS.getNumBands() != this.origMS.getNumBands()) {
            this.correctedMS.setNumberOfBands(this.origMS.getNumBands());
        }
        this.correctedMS.reshape(this.origMS.width, this.origMS.height);
        for (int i = 0; i < this.origMS.getNumBands(); ++i) {
            GrayF32 in = (GrayF32)this.origMS.getBand(i);
            GrayF32 out = (GrayF32)this.correctedMS.getBand(i);
            this.undoRadial.apply((ImageBase)in, (ImageBase)out);
        }
        this.undistorted = ConvertBufferedImage.checkDeclare((int)this.origMS.width, (int)this.origMS.height, (BufferedImage)this.undistorted, (int)image.getType());
        ConvertBufferedImage.convertTo(this.correctedMS, (BufferedImage)this.undistorted, (boolean)true);
    }

    public void setCalibration(CameraPinholeBrown param) {
        CameraPinhole undistorted = new CameraPinhole((CameraPinhole)param);
        this.undoRadial = LensDistortionOps.changeCameraModel((AdjustmentType)AdjustmentType.FULL_VIEW, (BorderType)BorderType.ZERO, (CameraPinhole)param, (CameraPinhole)undistorted, null, (ImageType)ImageType.single(GrayF32.class));
        this.remove_p_to_p = LensDistortionOps_F32.transformChangeModel((AdjustmentType)AdjustmentType.FULL_VIEW, (CameraPinhole)param, (CameraPinhole)undistorted, (boolean)false, null);
        this.undoRadialDistortion(this.distorted);
    }

    public void setCalibration(CameraPinholeBrown param, DMatrixRMaj rect) {
        FMatrixRMaj rect_f32 = new FMatrixRMaj(3, 3);
        ConvertMatrixData.convert((DMatrixRMaj)rect, (FMatrixRMaj)rect_f32);
        this.undoRadial = RectifyDistortImageOps.rectifyImage((CameraPinholeBrown)param, (FMatrixRMaj)rect_f32, (BorderType)BorderType.ZERO, (ImageType)ImageType.single(GrayF32.class));
        this.remove_p_to_p = RectifyImageOps.transformPixelToRect((CameraPinholeBrown)param, (FMatrixRMaj)rect_f32);
    }

    public void setLine(int y) {
        this.lineY = y;
    }

    @Override
    public void clearCalibration() {
        this.undoRadial = null;
    }
}

