/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.abst.fiducial.calib.CalibrationPatterns;
import boofcv.abst.fiducial.calib.ConfigECoCheckMarkers;
import boofcv.abst.fiducial.calib.ConfigGridDimen;
import boofcv.abst.geo.calibration.DetectMultiFiducialCalibration;
import boofcv.abst.geo.calibration.DetectSingleFiducialCalibration;
import boofcv.abst.geo.calibration.MultiToSingleFiducialCalibration;
import boofcv.alg.fiducial.calib.ConfigCalibrationTarget;
import boofcv.factory.fiducial.ConfigHammingChessboard;
import boofcv.factory.fiducial.ConfigHammingGrid;
import boofcv.factory.fiducial.ConfigHammingMarker;
import boofcv.factory.fiducial.FactoryFiducialCalibration;
import boofcv.factory.fiducial.HammingDictionary;
import boofcv.gui.BoofSwingUtil;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.controls.JCheckBoxValue;
import boofcv.gui.controls.JSpinnerNumber;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CalibrationTargetPanel
extends StandardAlgConfigPanel {
    JComboBox<CalibrationPatterns> comboType;
    JPanel panelTarget = new JPanel();
    Listener listener;
    public CalibrationPatterns selected = CalibrationPatterns.CHESSBOARD;
    public ConfigGridDimen configChessboard = new ConfigGridDimen(8, 6, 1.0);
    public ConfigECoCheckMarkers configECoCheck = ConfigECoCheckMarkers.singleShape((int)9, (int)7, (int)1, (double)1.0);
    public ConfigGridDimen configSquare = new ConfigGridDimen(7, 5, 1.0, 0.2);
    public ConfigGridDimen configCircle = new ConfigGridDimen(15, 10, 1.0, 1.5);
    public ConfigGridDimen configCircleHex = new ConfigGridDimen(15, 15, 1.0, 1.5);
    public ConfigHammingChessboard configHammingChess = ConfigHammingChessboard.create((HammingDictionary)HammingDictionary.ARUCO_MIP_25h7, (int)8, (int)6, (double)1.0);
    public ConfigHammingGrid configHammingGrid = ConfigHammingGrid.create((HammingDictionary)HammingDictionary.ARUCO_MIP_25h7, (int)7, (int)5, (double)1.0, (double)0.2);

    public CalibrationTargetPanel(Listener listener) {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.listener = listener;
        this.comboType = new JComboBox<CalibrationPatterns>(CalibrationTargetPanel.supportedPatterns());
        this.comboType.addActionListener(this);
        this.comboType.setMaximumSize(this.comboType.getPreferredSize());
        this.panelTarget.setLayout(new BorderLayout());
        this.panelTarget.setPreferredSize(new Dimension(250, 180));
        this.panelTarget.setMaximumSize(this.panelTarget.getPreferredSize());
        this.changeTargetPanel();
        this.addLabeled(this.comboType, "Target Type");
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        this.addAlignCenter(this.panelTarget);
    }

    private static CalibrationPatterns[] supportedPatterns() {
        CalibrationPatterns[] ret = new CalibrationPatterns[CalibrationPatterns.values().length - 2];
        System.arraycopy(CalibrationPatterns.values(), 0, ret, 0, ret.length);
        return ret;
    }

    public void setConfigurationTo(ConfigCalibrationTarget target) {
        BoofSwingUtil.checkGuiThread();
        this.selected = Objects.requireNonNull(target.type);
        switch (this.selected) {
            case CHESSBOARD: {
                this.configChessboard.setTo(target.grid);
                break;
            }
            case SQUARE_GRID: {
                this.configSquare.setTo(target.grid);
                break;
            }
            case CIRCLE_GRID: {
                this.configCircle.setTo(target.grid);
                break;
            }
            case CIRCLE_HEXAGONAL: {
                this.configCircleHex.setTo(target.grid);
                break;
            }
            case ECOCHECK: {
                this.configECoCheck.setTo(target.ecocheck);
                break;
            }
            default: {
                throw new RuntimeException("Target type not yet supported");
            }
        }
        this.comboType.setSelectedIndex(this.selected.ordinal());
    }

    public ConfigCalibrationTarget createConfigCalibrationTarget() {
        ConfigCalibrationTarget ret = new ConfigCalibrationTarget();
        ret.type = this.selected;
        switch (this.selected) {
            case CHESSBOARD: {
                ret.grid.setTo(this.configChessboard);
                break;
            }
            case SQUARE_GRID: {
                ret.grid.setTo(this.configSquare);
                break;
            }
            case CIRCLE_GRID: {
                ret.grid.setTo(this.configCircle);
                break;
            }
            case CIRCLE_HEXAGONAL: {
                ret.grid.setTo(this.configCircleHex);
                break;
            }
            case ECOCHECK: {
                ret.ecocheck.setTo(this.configECoCheck);
                break;
            }
            default: {
                throw new RuntimeException("Target type not yet supported");
            }
        }
        return ret;
    }

    public DetectSingleFiducialCalibration createSingleTargetDetector() {
        MultiToSingleFiducialCalibration multiToSingleFiducialCalibration;
        switch (this.selected) {
            case CHESSBOARD: {
                multiToSingleFiducialCalibration = FactoryFiducialCalibration.chessboardX(null, (ConfigGridDimen)this.configChessboard);
                break;
            }
            case ECOCHECK: {
                multiToSingleFiducialCalibration = new MultiToSingleFiducialCalibration((DetectMultiFiducialCalibration)FactoryFiducialCalibration.ecocheck(null, (ConfigECoCheckMarkers)this.configECoCheck));
                break;
            }
            case SQUARE_GRID: {
                multiToSingleFiducialCalibration = FactoryFiducialCalibration.squareGrid(null, (ConfigGridDimen)this.configSquare);
                break;
            }
            case CIRCLE_GRID: {
                multiToSingleFiducialCalibration = FactoryFiducialCalibration.circleRegularGrid(null, (ConfigGridDimen)this.configCircle);
                break;
            }
            case CIRCLE_HEXAGONAL: {
                multiToSingleFiducialCalibration = FactoryFiducialCalibration.circleHexagonalGrid(null, (ConfigGridDimen)this.configCircleHex);
                break;
            }
            default: {
                throw new RuntimeException("Target type not yet supported.");
            }
        }
        return multiToSingleFiducialCalibration;
    }

    public void updateParameters() {
        ConfigGridDimen configGridDimen;
        switch (this.selected) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case CHESSBOARD: {
                configGridDimen = this.configChessboard;
                break;
            }
            case ECOCHECK: {
                configGridDimen = this.configECoCheck;
                break;
            }
            case SQUARE_GRID: {
                configGridDimen = this.configSquare;
                break;
            }
            case CIRCLE_GRID: {
                configGridDimen = this.configCircle;
                break;
            }
            case CIRCLE_HEXAGONAL: {
                configGridDimen = this.configCircleHex;
                break;
            }
            case HAMMING_CHESSBOARD: {
                configGridDimen = this.configHammingChess;
                break;
            }
            case HAMMING_GRID: {
                configGridDimen = this.configHammingGrid;
            }
        }
        ConfigGridDimen c = configGridDimen;
        this.listener.calibrationParametersChanged(this.selected, c);
    }

    @Override
    public void controlChanged(Object source) {
        if (source == this.comboType) {
            this.selected = (CalibrationPatterns)this.comboType.getSelectedItem();
            this.changeTargetPanel();
            this.updateParameters();
        }
    }

    public void changeTargetPanel() {
        StandardAlgConfigPanel standardAlgConfigPanel;
        switch (this.selected) {
            case CHESSBOARD: {
                standardAlgConfigPanel = new ChessPanel();
                break;
            }
            case ECOCHECK: {
                standardAlgConfigPanel = new EcoCheckPanel();
                break;
            }
            case SQUARE_GRID: {
                standardAlgConfigPanel = new SquareGridPanel();
                break;
            }
            case CIRCLE_GRID: {
                standardAlgConfigPanel = new CircleGridPanel();
                break;
            }
            case CIRCLE_HEXAGONAL: {
                standardAlgConfigPanel = new CircleHexPanel();
                break;
            }
            case HAMMING_CHESSBOARD: {
                standardAlgConfigPanel = new HammingChessPanel();
                break;
            }
            case HAMMING_GRID: {
                standardAlgConfigPanel = new HammingGridPanel();
                break;
            }
            default: {
                throw new RuntimeException("Unknown");
            }
        }
        StandardAlgConfigPanel p = standardAlgConfigPanel;
        this.panelTarget.removeAll();
        this.panelTarget.add("Center", p);
        this.panelTarget.validate();
        this.panelTarget.repaint();
    }

    public void updateConfig(ConfigCalibrationTarget config) {
        config.type = this.selected;
        switch (this.selected) {
            case CHESSBOARD: {
                config.grid.setTo(this.configChessboard);
                break;
            }
            case ECOCHECK: {
                config.ecocheck.setTo(this.configECoCheck);
                break;
            }
            case SQUARE_GRID: {
                config.grid.setTo(this.configSquare);
                break;
            }
            case CIRCLE_GRID: {
                config.grid.setTo(this.configCircle);
                break;
            }
            case CIRCLE_HEXAGONAL: {
                config.grid.setTo(this.configCircleHex);
                break;
            }
            case HAMMING_CHESSBOARD: {
                config.hammingChess.setTo(this.configHammingChess);
                break;
            }
            case HAMMING_GRID: {
                config.hammingGrid.setTo(this.configHammingGrid);
                break;
            }
            default: {
                throw new RuntimeException("Target type not yet supported.");
            }
        }
    }

    public Object getActiveConfig() {
        ConfigGridDimen configGridDimen;
        switch (this.selected) {
            case CHESSBOARD: {
                configGridDimen = this.configChessboard;
                break;
            }
            case ECOCHECK: {
                configGridDimen = this.configECoCheck;
                break;
            }
            case SQUARE_GRID: {
                configGridDimen = this.configSquare;
                break;
            }
            case CIRCLE_GRID: {
                configGridDimen = this.configCircle;
                break;
            }
            case CIRCLE_HEXAGONAL: {
                configGridDimen = this.configCircleHex;
                break;
            }
            case HAMMING_CHESSBOARD: {
                configGridDimen = this.configHammingChess;
                break;
            }
            case HAMMING_GRID: {
                configGridDimen = this.configHammingGrid;
                break;
            }
            default: {
                throw new RuntimeException("Target type not yet supported.");
            }
        }
        return configGridDimen;
    }

    public static interface Listener {
        public void calibrationParametersChanged(CalibrationPatterns var1, Object var2);
    }

    private class ChessPanel
    extends StandardAlgConfigPanel
    implements ChangeListener {
        JSpinner sRows;
        JSpinner sCols;
        JSpinner sWidth;

        public ChessPanel() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.sRows = this.spinner(CalibrationTargetPanel.this.configChessboard.numRows, 1, 1000, 1);
            this.sCols = this.spinner(CalibrationTargetPanel.this.configChessboard.numCols, 1, 1000, 1);
            this.sWidth = this.spinner(CalibrationTargetPanel.this.configChessboard.shapeSize, 0.0, 1000000.0, 1.0);
            this.addLabeled(this.sRows, "Rows", "Number of square rows");
            this.addLabeled(this.sCols, "Cols", "Number of square columns");
            this.addLabeled(this.sWidth, "Square Width", "How wide each square is");
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == this.sRows) {
                CalibrationTargetPanel.this.configChessboard.numRows = ((Number)this.sRows.getValue()).intValue();
            } else if (e.getSource() == this.sCols) {
                CalibrationTargetPanel.this.configChessboard.numCols = ((Number)this.sCols.getValue()).intValue();
            } else if (e.getSource() == this.sWidth) {
                CalibrationTargetPanel.this.configChessboard.shapeSize = ((Number)this.sWidth.getValue()).doubleValue();
            }
            CalibrationTargetPanel.this.updateParameters();
        }
    }

    private class EcoCheckPanel
    extends StandardAlgConfigPanel
    implements ChangeListener {
        JSpinner sRows;
        JSpinner sCols;
        JSpinner sWidth;
        JSpinner sMarkers;
        JComboBox<String> comboErrorLevel;
        JComboBox<String> comboChecksum;

        public EcoCheckPanel() {
            this.setBorder(BorderFactory.createEmptyBorder());
            ConfigECoCheckMarkers.MarkerShape shape = (ConfigECoCheckMarkers.MarkerShape)CalibrationTargetPanel.this.configECoCheck.markerShapes.get(0);
            this.sRows = this.spinner(shape.numRows, 1, 1000, 1);
            this.sCols = this.spinner(shape.numCols, 1, 1000, 1);
            this.sWidth = this.spinner(shape.squareSize, 0.0, 1000000.0, 1.0);
            this.sMarkers = this.spinner(CalibrationTargetPanel.this.configECoCheck.firstTargetDuplicated, 1, 1000, 1);
            this.comboErrorLevel = this.combo(CalibrationTargetPanel.this.configECoCheck.errorCorrectionLevel, "0", "1", "2", "3", "4", "5", "6", "7", "8", "9");
            this.comboChecksum = this.combo(CalibrationTargetPanel.this.configECoCheck.checksumBits, "0", "1", "2", "3", "4", "5", "6", "7", "8");
            this.addLabeled(this.sRows, "Rows", "Number of square rows");
            this.addLabeled(this.sCols, "Cols", "Number of square columns");
            this.addLabeled(this.sWidth, "Square Width", "How wide each square is");
            this.addLabeled(this.sMarkers, "Count", "Number of unique markers");
            this.addLabeled(this.comboErrorLevel, "Error Level", "Amount of error correction. 0 = none. 10 = max.");
            this.addLabeled(this.comboChecksum, "Checksum", "Bits for checksum. 0 = none. 8 = max.");
        }

        @Override
        public void controlChanged(Object source) {
            ConfigECoCheckMarkers.MarkerShape shape = (ConfigECoCheckMarkers.MarkerShape)CalibrationTargetPanel.this.configECoCheck.markerShapes.get(0);
            if (source == this.sRows) {
                shape.numRows = ((Number)this.sRows.getValue()).intValue();
            } else if (source == this.sCols) {
                shape.numCols = ((Number)this.sCols.getValue()).intValue();
            } else if (source == this.sWidth) {
                shape.squareSize = ((Number)this.sWidth.getValue()).doubleValue();
            } else if (source == this.sMarkers) {
                CalibrationTargetPanel.this.configECoCheck.firstTargetDuplicated = ((Number)this.sMarkers.getValue()).intValue();
            } else if (source == this.comboErrorLevel) {
                CalibrationTargetPanel.this.configECoCheck.errorCorrectionLevel = this.comboErrorLevel.getSelectedIndex();
            } else if (source == this.comboChecksum) {
                CalibrationTargetPanel.this.configECoCheck.checksumBits = this.comboChecksum.getSelectedIndex();
            }
            CalibrationTargetPanel.this.updateParameters();
        }
    }

    private class SquareGridPanel
    extends StandardAlgConfigPanel
    implements ChangeListener {
        JSpinner sRows;
        JSpinner sCols;
        JSpinner sWidth;
        JSpinner sSpace;

        public SquareGridPanel() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.sRows = this.spinner(CalibrationTargetPanel.this.configSquare.numRows, 1, 1000, 1);
            this.sCols = this.spinner(CalibrationTargetPanel.this.configSquare.numCols, 1, 1000, 1);
            this.sWidth = this.spinner(CalibrationTargetPanel.this.configSquare.shapeSize, 0.0, 1000000.0, 1.0);
            this.sSpace = this.spinner(CalibrationTargetPanel.this.configSquare.shapeDistance, 0.0, 1000000.0, 1.0);
            this.addLabeled(this.sRows, "Rows", "Number of square rows");
            this.addLabeled(this.sCols, "Cols", "Number of square columns");
            this.addLabeled(this.sWidth, "Square Width", "How wide each square is");
            this.addLabeled(this.sSpace, "Space Width", "Space between squares");
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == this.sRows) {
                CalibrationTargetPanel.this.configSquare.numRows = ((Number)this.sRows.getValue()).intValue();
            } else if (e.getSource() == this.sCols) {
                CalibrationTargetPanel.this.configSquare.numCols = ((Number)this.sCols.getValue()).intValue();
            } else if (e.getSource() == this.sWidth) {
                CalibrationTargetPanel.this.configSquare.shapeSize = ((Number)this.sWidth.getValue()).doubleValue();
            } else if (e.getSource() == this.sSpace) {
                CalibrationTargetPanel.this.configSquare.shapeDistance = ((Number)this.sSpace.getValue()).doubleValue();
            }
            CalibrationTargetPanel.this.updateParameters();
        }
    }

    private class CircleGridPanel
    extends StandardAlgConfigPanel
    implements ChangeListener {
        JSpinner sRows;
        JSpinner sCols;
        JSpinner sDiam;
        JSpinner sDist;

        public CircleGridPanel() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.sRows = this.spinner(CalibrationTargetPanel.this.configCircle.numRows, 1, 1000, 1);
            this.sCols = this.spinner(CalibrationTargetPanel.this.configCircle.numCols, 1, 1000, 1);
            this.sDiam = this.spinner(CalibrationTargetPanel.this.configCircle.shapeSize, 0.0, 1000000.0, 1.0);
            this.sDist = this.spinner(CalibrationTargetPanel.this.configCircle.shapeDistance, 0.0, 1000000.0, 1.0);
            this.addLabeled(this.sRows, "Rows");
            this.addLabeled(this.sCols, "Cols");
            this.addLabeled(this.sDiam, "Circle Diameter");
            this.addLabeled(this.sDist, "Center Distance");
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == this.sRows) {
                CalibrationTargetPanel.this.configCircle.numRows = ((Number)this.sRows.getValue()).intValue();
            } else if (e.getSource() == this.sCols) {
                CalibrationTargetPanel.this.configCircle.numCols = ((Number)this.sCols.getValue()).intValue();
            } else if (e.getSource() == this.sDiam) {
                CalibrationTargetPanel.this.configCircle.shapeSize = ((Number)this.sDiam.getValue()).doubleValue();
            } else if (e.getSource() == this.sDist) {
                CalibrationTargetPanel.this.configCircle.shapeDistance = ((Number)this.sDist.getValue()).doubleValue();
            }
            CalibrationTargetPanel.this.updateParameters();
        }
    }

    private class CircleHexPanel
    extends StandardAlgConfigPanel
    implements ChangeListener {
        JSpinner sRows;
        JSpinner sCols;
        JSpinner sDiam;
        JSpinner sDist;

        public CircleHexPanel() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.sRows = this.spinner(CalibrationTargetPanel.this.configCircleHex.numRows, 1, 1000, 1);
            this.sCols = this.spinner(CalibrationTargetPanel.this.configCircleHex.numCols, 1, 1000, 1);
            this.sDiam = this.spinner(CalibrationTargetPanel.this.configCircleHex.shapeSize, 0.0, 1000000.0, 1.0);
            this.sDist = this.spinner(CalibrationTargetPanel.this.configCircleHex.shapeDistance, 0.0, 1000000.0, 1.0);
            this.addLabeled(this.sRows, "Rows");
            this.addLabeled(this.sCols, "Cols");
            this.addLabeled(this.sDiam, "Circle Diameter");
            this.addLabeled(this.sDist, "Center Distance");
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == this.sRows) {
                CalibrationTargetPanel.this.configCircleHex.numRows = ((Number)this.sRows.getValue()).intValue();
            } else if (e.getSource() == this.sCols) {
                CalibrationTargetPanel.this.configCircleHex.numCols = ((Number)this.sCols.getValue()).intValue();
            } else if (e.getSource() == this.sDiam) {
                CalibrationTargetPanel.this.configCircleHex.shapeSize = ((Number)this.sDiam.getValue()).doubleValue();
            } else if (e.getSource() == this.sDist) {
                CalibrationTargetPanel.this.configCircleHex.shapeDistance = ((Number)this.sDist.getValue()).doubleValue();
            }
            CalibrationTargetPanel.this.updateParameters();
        }
    }

    private class HammingChessPanel
    extends StandardAlgConfigPanel
    implements ChangeListener {
        JSpinnerNumber sRows;
        JSpinnerNumber sCols;
        JSpinnerNumber sWidth;
        JSpinnerNumber sScale;
        JComboBox<?> cDict;
        JSpinnerNumber sOffset;
        JCheckBoxValue cEven;

        public HammingChessPanel() {
            this.sRows = this.spinnerWrap(CalibrationTargetPanel.this.configHammingChess.numRows, 1, 1000, 1);
            this.sCols = this.spinnerWrap(CalibrationTargetPanel.this.configHammingChess.numCols, 1, 1000, 1);
            this.sWidth = this.spinnerWrap(CalibrationTargetPanel.this.configHammingChess.squareSize, 0.0, 1000000.0, 1.0);
            this.sScale = this.spinnerWrap(CalibrationTargetPanel.this.configHammingChess.markerScale, 0.0, 1.0, 0.02);
            this.cDict = this.combo(CalibrationTargetPanel.this.configHammingChess.markers.dictionary.ordinal(), HammingDictionary.allPredefined());
            this.sOffset = this.spinnerWrap(CalibrationTargetPanel.this.configHammingChess.markerOffset, 0, 200, 1);
            this.cEven = this.checkboxWrap("Even pattern", CalibrationTargetPanel.this.configHammingChess.chessboardEven);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.sScale.spinner.setPreferredSize(this.sRows.spinner.getPreferredSize());
            this.sScale.spinner.setMaximumSize(this.sRows.spinner.getMaximumSize());
            this.addLabeled(this.sRows.spinner, "Rows", "Number of square rows");
            this.addLabeled(this.sCols.spinner, "Cols", "Number of square columns");
            this.addAlignCenter(this.cEven.check, "Chessboard is an even or odd pattern");
            this.addLabeled(this.sWidth.spinner, "Square Width", "How wide each square is");
            this.addLabeled(this.sScale.spinner, "Marker Scale", "Relative size of markers");
            this.addLabeled(this.cDict, "Dictionary", "Encoding dictionary");
            this.addLabeled(this.sOffset.spinner, "Marker Offset", "Index of the first marker");
        }

        @Override
        public void controlChanged(Object source) {
            if (source == this.sRows.spinner) {
                this.sRows.updateValue();
                CalibrationTargetPanel.this.configHammingChess.numRows = this.sRows.value.intValue();
            } else if (source == this.sCols.spinner) {
                this.sCols.updateValue();
                CalibrationTargetPanel.this.configHammingChess.numCols = this.sCols.value.intValue();
            } else if (source == this.cEven.check) {
                this.cEven.updateValue();
                CalibrationTargetPanel.this.configHammingChess.chessboardEven = this.cEven.value;
            } else if (source == this.sWidth.spinner) {
                this.sWidth.updateValue();
                CalibrationTargetPanel.this.configHammingChess.squareSize = this.sWidth.value.doubleValue();
            } else if (source == this.sScale.spinner) {
                this.sScale.updateValue();
                CalibrationTargetPanel.this.configHammingChess.markerScale = this.sScale.value.doubleValue();
            } else if (source == this.cDict) {
                HammingDictionary dictionary = HammingDictionary.valueOf((String)((String)this.cDict.getSelectedItem()));
                CalibrationTargetPanel.this.configHammingChess.markers.setTo(ConfigHammingMarker.loadDictionary((HammingDictionary)dictionary));
            } else if (source == this.sOffset.spinner) {
                this.sOffset.updateValue();
                CalibrationTargetPanel.this.configHammingChess.markerOffset = this.sOffset.value.intValue();
            }
            CalibrationTargetPanel.this.updateParameters();
        }
    }

    private class HammingGridPanel
    extends StandardAlgConfigPanel
    implements ChangeListener {
        JSpinnerNumber sRows;
        JSpinnerNumber sCols;
        JSpinnerNumber sWidth;
        JSpinnerNumber sSpace;
        JComboBox<?> cDict;
        JSpinnerNumber sOffset;

        public HammingGridPanel() {
            this.sRows = this.spinnerWrap(CalibrationTargetPanel.this.configHammingGrid.numRows, 1, 1000, 1);
            this.sCols = this.spinnerWrap(CalibrationTargetPanel.this.configHammingGrid.numCols, 1, 1000, 1);
            this.sWidth = this.spinnerWrap(CalibrationTargetPanel.this.configHammingGrid.squareSize, 0.0, 1000000.0, 1.0);
            this.sSpace = this.spinnerWrap(CalibrationTargetPanel.this.configHammingGrid.spaceToSquare, 0.0, 1.0, 0.02);
            this.cDict = this.combo(CalibrationTargetPanel.this.configHammingGrid.markers.dictionary.ordinal(), HammingDictionary.allPredefined());
            this.sOffset = this.spinnerWrap(CalibrationTargetPanel.this.configHammingGrid.markerOffset, 0, 200, 1);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.sSpace.spinner.setPreferredSize(this.sRows.spinner.getPreferredSize());
            this.sSpace.spinner.setMaximumSize(this.sRows.spinner.getMaximumSize());
            this.addLabeled(this.sRows.spinner, "Rows", "Number of square rows");
            this.addLabeled(this.sCols.spinner, "Cols", "Number of square columns");
            this.addLabeled(this.sWidth.spinner, "Square Width", "How wide each square is");
            this.addLabeled(this.sSpace.spinner, "Space", "Space between squares in units of squares");
            this.addLabeled(this.cDict, "Dictionary", "Encoding dictionary");
            this.addLabeled(this.sOffset.spinner, "Marker Offset", "Index of the first marker");
        }

        @Override
        public void controlChanged(Object source) {
            if (source == this.sRows.spinner) {
                this.sRows.updateValue();
                CalibrationTargetPanel.this.configHammingGrid.numRows = this.sRows.value.intValue();
            } else if (source == this.sCols.spinner) {
                this.sCols.updateValue();
                CalibrationTargetPanel.this.configHammingGrid.numCols = this.sCols.value.intValue();
            } else if (source == this.sWidth.spinner) {
                this.sWidth.updateValue();
                CalibrationTargetPanel.this.configHammingGrid.squareSize = this.sWidth.value.doubleValue();
            } else if (source == this.sSpace.spinner) {
                this.sSpace.updateValue();
                CalibrationTargetPanel.this.configHammingGrid.spaceToSquare = this.sSpace.value.doubleValue();
            } else if (source == this.cDict) {
                HammingDictionary dictionary = HammingDictionary.valueOf((String)((String)this.cDict.getSelectedItem()));
                CalibrationTargetPanel.this.configHammingGrid.markers.setTo(ConfigHammingMarker.loadDictionary((HammingDictionary)dictionary));
            } else if (source == this.sOffset.spinner) {
                this.sOffset.updateValue();
                CalibrationTargetPanel.this.configHammingGrid.markerOffset = this.sOffset.value.intValue();
            }
            CalibrationTargetPanel.this.updateParameters();
        }
    }
}

