/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.factory.geo.EnumPNP;
import boofcv.factory.sfm.ConfigVisOdomTrackPnP;
import boofcv.gui.StandardAlgConfigPanel;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JSpinner;

public class ControlPanelVisOdomTrackPnP
extends StandardAlgConfigPanel {
    public final ConfigVisOdomTrackPnP config;
    private final EnumPNP[] VALUES_PNP = new EnumPNP[]{EnumPNP.P3P_GRUNERT, EnumPNP.P3P_FINSTERWALDER, EnumPNP.EPNP};
    private final JSpinner spinRansacIter;
    private final JSpinner spinRansacTol;
    private final JSpinner spinRefinePnP;
    private final JComboBox<String> comboPnpType;
    private final JSpinner spinBundleMaxIter;
    private final JSpinner spinBundleFeatFrame;
    private final JSpinner spinBundleMinObs;
    private final JSpinner spinDropOutliers;
    private final JSpinner spinMaxKeyFrames;
    private final JSpinner spinKeyCoverage;
    private final Listener listener;

    public ControlPanelVisOdomTrackPnP(Listener listener, ConfigVisOdomTrackPnP config_) {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.listener = listener;
        this.config = config_ == null ? new ConfigVisOdomTrackPnP() : config_;
        this.spinRansacIter = this.spinner(this.config.ransac.iterations, 0, 9999, 1);
        this.spinRansacTol = this.spinner(this.config.ransac.inlierThreshold, 0.0, 50.0, 0.2);
        this.spinRefinePnP = this.spinner(this.config.refineIterations, 0, 999, 1);
        this.comboPnpType = this.combo(this.config.pnp.ordinal(), this.VALUES_PNP);
        this.spinBundleMaxIter = this.spinner(this.config.bundleConverge.maxIterations, 0, 999, 1);
        this.spinBundleFeatFrame = this.spinner(this.config.bundleMaxFeaturesPerFrame, 0, 999, 1);
        this.spinBundleMinObs = this.spinner(this.config.bundleMinObservations, 2, 50, 1);
        this.spinDropOutliers = this.spinner(this.config.dropOutlierTracks, 0, 999, 1);
        this.spinMaxKeyFrames = this.spinner(this.config.maxKeyFrames, 2, 999, 1);
        this.spinKeyCoverage = this.spinner(this.config.keyframes.geoMinCoverage, 0.0, 1.0, 0.05, "0.0E0", 8);
        StandardAlgConfigPanel panelPnP = new StandardAlgConfigPanel();
        panelPnP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "PnP"));
        panelPnP.addLabeled(this.spinRansacIter, "RANSAC Iter", "Maximum RANSAC iterations");
        panelPnP.addLabeled(this.spinRansacTol, "Inlier Tol", "RANSAC inlier tolerance");
        panelPnP.addLabeled(this.spinRefinePnP, "Refine Iter", "Non-linear refinement iterations for PNP");
        panelPnP.addAlignCenter(this.comboPnpType);
        this.comboPnpType.setToolTipText("PNP solution to use in RANSAC");
        StandardAlgConfigPanel panelBundle = new StandardAlgConfigPanel();
        panelBundle.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Bundle"));
        panelBundle.addLabeled(this.spinBundleMaxIter, "Iteration", "Bundle Adjustment Iterations. 0 = disable");
        panelBundle.addLabeled(this.spinBundleFeatFrame, "Feat Frame", "Maximum number of features per frame. 0 = disable");
        panelBundle.addLabeled(this.spinBundleMinObs, "Min Obs", "Minimum observations for a track. 3 is minimum for max stability.");
        StandardAlgConfigPanel panelMaintenance = new StandardAlgConfigPanel();
        panelMaintenance.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Maintenance"));
        panelMaintenance.addLabeled(this.spinMaxKeyFrames, "Key Frames", "Number of key frames");
        panelMaintenance.addLabeled(this.spinDropOutliers, "Drop Outliers", "Discards features which are outliers for this many frames. 0 = disable");
        panelMaintenance.addLabeled(this.spinKeyCoverage, "Key Coverage", "If tracks cover less than this fraction of the image a new keyframe is forced");
        this.add(ControlPanelVisOdomTrackPnP.fillHorizontally(panelPnP));
        this.add(ControlPanelVisOdomTrackPnP.fillHorizontally(panelBundle));
        this.add(ControlPanelVisOdomTrackPnP.fillHorizontally(panelMaintenance));
    }

    @Override
    public void controlChanged(Object source) {
        if (this.spinRansacIter == source) {
            this.config.ransac.iterations = (Integer)this.spinRansacIter.getValue();
        } else if (this.spinRansacTol == source) {
            this.config.ransac.inlierThreshold = (Double)this.spinRansacTol.getValue();
        } else if (this.spinRefinePnP == source) {
            this.config.refineIterations = (Integer)this.spinRefinePnP.getValue();
        } else if (this.spinBundleMaxIter == source) {
            this.config.bundleConverge.maxIterations = (Integer)this.spinBundleMaxIter.getValue();
        } else if (this.spinBundleFeatFrame == source) {
            this.config.bundleMaxFeaturesPerFrame = (Integer)this.spinBundleFeatFrame.getValue();
        } else if (this.spinBundleMinObs == source) {
            this.config.bundleMinObservations = (Integer)this.spinBundleMinObs.getValue();
        } else if (this.spinDropOutliers == source) {
            this.config.dropOutlierTracks = (Integer)this.spinDropOutliers.getValue();
        } else if (this.spinKeyCoverage == source) {
            this.config.keyframes.geoMinCoverage = (Double)this.spinKeyCoverage.getValue();
        } else if (this.spinMaxKeyFrames == source) {
            this.config.maxKeyFrames = (Integer)this.spinMaxKeyFrames.getValue();
        } else if (this.comboPnpType == source) {
            this.config.pnp = this.VALUES_PNP[this.comboPnpType.getSelectedIndex()];
        }
        this.listener.changedVisOdomDepthPnP();
    }

    public static interface Listener {
        public void changedVisOdomDepthPnP();
    }
}

