/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.struct.image.GrayU8;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImageBinaryPanel
extends JPanel {
    protected BufferedImage img;
    protected GrayU8 binaryImage;

    public ImageBinaryPanel(GrayU8 binaryImage) {
        this.binaryImage = binaryImage;
        this.img = new BufferedImage(binaryImage.getWidth(), binaryImage.getHeight(), 10);
        VisualizeBinaryData.renderBinary(binaryImage, false, this.img);
        this.setPreferredSize(new Dimension(binaryImage.getWidth(), binaryImage.getHeight()));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
    }

    protected ImageBinaryPanel() {
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        if (this.img != null) {
            g.drawImage(this.img, 0, 0, this);
        }
    }

    public synchronized void setBinaryImage(GrayU8 binaryImage) {
        this.binaryImage = binaryImage;
        VisualizeBinaryData.renderBinary(binaryImage, false, this.img);
    }

    public BufferedImage getImage() {
        return this.img;
    }
}

