/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.mesh;

import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.mesh.MeshViewerPanel;
import boofcv.gui.mesh.Swing3dCameraControl;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextArea;

public class MeshViewerPreferencePanel
extends StandardAlgConfigPanel {
    JComboBox<String> comboControls;
    JCheckBox checkHide;
    JTextArea textArea = new JTextArea();
    MeshViewerPanel panel;

    public MeshViewerPreferencePanel(MeshViewerPanel panel) {
        this.panel = panel;
        this.checkHide = this.checkbox("Show Help", panel.helpButtonActive);
        this.comboControls = this.combo(0, new ArrayList<String>(panel.controls.keySet()).toArray());
        this.textArea.setEditable(false);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textArea.setFont(new Font("monospaced", 0, 12));
        this.setHelpText();
        this.addLabeled(this.comboControls, "Controls");
        this.addAlignLeft(this.checkHide);
        this.addAlignCenter(this.textArea);
        this.setPreferredSize(new Dimension(300, 400));
    }

    private void setHelpText() {
        Swing3dCameraControl control = Objects.requireNonNull(this.panel.controls.get((String)this.comboControls.getSelectedItem()));
        Object text = "h   Set view to home\nj   Cycle colorization\nk   Show depth image\n";
        text = (String)text + "\n" + control.getHelpText();
        this.textArea.setText((String)text);
    }

    @Override
    public void controlChanged(Object source) {
        if (source == this.comboControls) {
            String selected = (String)this.comboControls.getSelectedItem();
            this.panel.setActiveControl(selected);
            this.setHelpText();
        } else if (source == this.checkHide) {
            this.panel.helpButtonActive = this.checkHide.isSelected();
            this.panel.repaint();
        }
    }
}

