/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.struct.feature.TupleDesc;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Objects;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class TupleDescPanel
extends JPanel {
    @Nullable
    TupleDesc desc;

    public TupleDesc getDesc() {
        return Objects.requireNonNull(this.desc);
    }

    public void setDescription(@Nullable TupleDesc desc) {
        this.desc = desc;
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        @Nullable TupleDesc desc = this.desc;
        if (desc == null) {
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            int h = this.getHeight();
            int w = this.getWidth();
            int m = h / 2;
            int[] x = new int[desc.size()];
            int[] y = new int[desc.size()];
            double max = 0.0;
            for (int i = 0; i < desc.size(); ++i) {
                double d = desc.getDouble(i);
                if (!(max < Math.abs(d))) continue;
                max = Math.abs(d);
            }
            double stepX = 1.0 / (double)desc.size();
            for (int i = 0; i < desc.size(); ++i) {
                x[i] = (int)((double)(w * i) * stepX);
                y[i] = (int)((double)m * desc.getDouble(i) / max + (double)m);
            }
            g2.setColor(Color.GRAY);
            g2.drawLine(0, m, w, m);
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.RED);
            g2.drawPolyline(x, y, x.length);
            g2.setColor(Color.BLACK);
            String s = String.format("%4.1e", max);
            g2.drawString(s, 0, 20);
            g2.setColor(Color.BLUE);
            for (int i = 0; i < desc.size(); ++i) {
                int r = 1;
                w = r * 2 + 1;
                g2.fillOval(x[i] - r, y[i] - r, w, w);
            }
        }
    }
}

