/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.mesh;

import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.mesh.MeshViewerPanel;
import boofcv.gui.mesh.Swing3dCameraControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JTextArea;

public class MeshViewerPreferencePanel
extends StandardAlgConfigPanel {
    JComboBox<String> comboControls;
    JCheckBox checkHide;
    JTextArea textArea = new JTextArea();
    MeshViewerPanel panel;
    protected final JButton bColorBackGround = new JButton();

    public MeshViewerPreferencePanel(MeshViewerPanel panel) {
        this.panel = panel;
        this.checkHide = this.checkbox("Show Help", panel.helpButtonActive);
        this.comboControls = this.combo(0, new ArrayList<String>(panel.controls.keySet()).toArray());
        this.textArea.setEditable(false);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textArea.setFont(new Font("monospaced", 0, 12));
        this.bColorBackGround.setPreferredSize(new Dimension(24, 24));
        this.bColorBackGround.setMinimumSize(this.bColorBackGround.getPreferredSize());
        this.bColorBackGround.setMaximumSize(this.bColorBackGround.getPreferredSize());
        this.bColorBackGround.setBorder(BorderFactory.createLineBorder(Color.BLACK, 4));
        this.bColorBackGround.setIcon(new FlatIcon());
        this.bColorBackGround.setToolTipText("Click to change the background color");
        this.bColorBackGround.addActionListener(e -> {
            Color newColor = JColorChooser.showDialog(this, "Background Color", new Color(panel.getRenderBackgroundColor()));
            if (newColor == null) {
                return;
            }
            this.bColorBackGround.repaint();
            panel.setRenderBackgroundColor(newColor.getRGB());
            panel.requestRender();
        });
        this.setHelpText();
        this.addLabeled(this.comboControls, "Controls");
        this.addLabeled(this.bColorBackGround, "Background");
        this.addAlignLeft(this.checkHide);
        this.addAlignCenter(this.textArea);
        this.setPreferredSize(new Dimension(300, 400));
    }

    private void setHelpText() {
        Swing3dCameraControl control = Objects.requireNonNull(this.panel.controls.get((String)this.comboControls.getSelectedItem()));
        Object text = "h   Set view to home\nj   Cycle colorization\nk   Show depth image\n";
        text = (String)text + "\n" + control.getHelpText();
        this.textArea.setText((String)text);
    }

    @Override
    public void controlChanged(Object source) {
        if (source == this.comboControls) {
            String selected = (String)this.comboControls.getSelectedItem();
            this.panel.setActiveControl(selected);
            this.setHelpText();
        } else if (source == this.checkHide) {
            this.panel.helpButtonActive = this.checkHide.isSelected();
            this.panel.repaint();
        }
    }

    private class FlatIcon
    implements Icon {
        private FlatIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(new Color(MeshViewerPreferencePanel.this.panel.getRenderBackgroundColor()));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }

        @Override
        public int getIconWidth() {
            return 20;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }
    }
}

