/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.settings;

import com.github.weisj.darklaf.DarkLaf;
import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.theme.DarculaTheme;
import com.github.weisj.darklaf.theme.IntelliJTheme;
import com.github.weisj.darklaf.theme.SolarizedLightTheme;
import com.github.weisj.darklaf.theme.Theme;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import mdlaf.MaterialLookAndFeel;
import mdlaf.themes.JMarsDarkTheme;
import mdlaf.themes.MaterialLiteTheme;
import mdlaf.themes.MaterialOceanicTheme;
import mdlaf.themes.MaterialTheme;

public class GlobalDemoSettings
implements Cloneable {
    public static GlobalDemoSettings SETTINGS = new GlobalDemoSettings();
    private static String KEY_THEME = "theme";
    private static String KEY_CONTROLS3D = "controls3D";
    private static String KEY_VERBOSE_RUNTIME = "verboseRuntime";
    private static String KEY_VERBOSE_TRACKING = "verboseTracking";
    private static String KEY_VERBOSE_RECURSIVE = "verboseRecursive";
    public ThemesUI theme = ThemesUI.DEFAULT;
    public Controls3D controls3D = Controls3D.WASD;
    public boolean verboseRuntime = false;
    public boolean verboseTracking = false;
    public boolean verboseRecursive = false;

    public void load() {
        Preferences prefs = Preferences.userRoot().node(GlobalDemoSettings.class.getCanonicalName());
        try {
            this.theme = ThemesUI.valueOf(prefs.get(KEY_THEME, this.theme.name()));
            this.controls3D = Controls3D.valueOf(prefs.get(KEY_CONTROLS3D, this.controls3D.name()));
            this.verboseRuntime = prefs.getBoolean(KEY_VERBOSE_RUNTIME, this.verboseRuntime);
            this.verboseTracking = prefs.getBoolean(KEY_VERBOSE_TRACKING, this.verboseTracking);
            this.verboseRecursive = prefs.getBoolean(KEY_VERBOSE_RECURSIVE, this.verboseRecursive);
        }
        catch (RuntimeException e) {
            this.save();
            e.printStackTrace();
        }
    }

    public void save() {
        Preferences prefs = Preferences.userRoot().node(GlobalDemoSettings.class.getCanonicalName());
        prefs.put(KEY_THEME, this.theme.name());
        prefs.put(KEY_CONTROLS3D, this.controls3D.name());
        prefs.putBoolean(KEY_VERBOSE_RUNTIME, this.verboseRuntime);
        prefs.putBoolean(KEY_VERBOSE_TRACKING, this.verboseTracking);
        prefs.putBoolean(KEY_VERBOSE_RECURSIVE, this.verboseRecursive);
        try {
            prefs.sync();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public void changeTheme() {
        MaterialLookAndFeel selectedInstance = null;
        String selectedName = null;
        LafManager.enableLogging((boolean)false);
        switch (this.theme) {
            case DEFAULT: {
                if (System.getProperty("os.name").contains("Mac OS X")) {
                    selectedName = UIManager.getSystemLookAndFeelClassName();
                    break;
                }
                selectedName = UIManager.getCrossPlatformLookAndFeelClassName();
                break;
            }
            case DARKULA: {
                LafManager.setTheme((Theme)new DarculaTheme());
                selectedName = DarkLaf.class.getCanonicalName();
                break;
            }
            case INTELLIJ: {
                LafManager.setTheme((Theme)new IntelliJTheme());
                selectedName = DarkLaf.class.getCanonicalName();
                break;
            }
            case SOLARIZED: {
                LafManager.setTheme((Theme)new SolarizedLightTheme());
                selectedName = DarkLaf.class.getCanonicalName();
                break;
            }
            case MARS_DARK: {
                selectedInstance = new MaterialLookAndFeel((MaterialTheme)new JMarsDarkTheme());
                break;
            }
            case MATERIAL_LITE: {
                selectedInstance = new MaterialLookAndFeel((MaterialTheme)new MaterialLiteTheme());
                break;
            }
            case MATERIAL_OCEANIC: {
                selectedInstance = new MaterialLookAndFeel((MaterialTheme)new MaterialOceanicTheme());
                break;
            }
            default: {
                System.err.println("BUG! Unknown Look and Feel " + this.theme);
                return;
            }
        }
        try {
            if (selectedInstance == null) {
                UIManager.setLookAndFeel(selectedName);
            } else {
                UIManager.setLookAndFeel((LookAndFeel)selectedInstance);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    public GlobalDemoSettings copy() {
        GlobalDemoSettings ret = new GlobalDemoSettings();
        ret.theme = this.theme;
        ret.verboseRuntime = this.verboseRuntime;
        ret.verboseTracking = this.verboseTracking;
        return ret;
    }

    public ThemesUI getTheme() {
        return this.theme;
    }

    public Controls3D getControls3D() {
        return this.controls3D;
    }

    public boolean isVerboseRuntime() {
        return this.verboseRuntime;
    }

    public boolean isVerboseTracking() {
        return this.verboseTracking;
    }

    public boolean isVerboseRecursive() {
        return this.verboseRecursive;
    }

    public void setTheme(ThemesUI theme) {
        this.theme = theme;
    }

    public void setControls3D(Controls3D controls3D) {
        this.controls3D = controls3D;
    }

    public void setVerboseRuntime(boolean verboseRuntime) {
        this.verboseRuntime = verboseRuntime;
    }

    public void setVerboseTracking(boolean verboseTracking) {
        this.verboseTracking = verboseTracking;
    }

    public void setVerboseRecursive(boolean verboseRecursive) {
        this.verboseRecursive = verboseRecursive;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalDemoSettings)) {
            return false;
        }
        GlobalDemoSettings other = (GlobalDemoSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isVerboseRuntime() != other.isVerboseRuntime()) {
            return false;
        }
        if (this.isVerboseTracking() != other.isVerboseTracking()) {
            return false;
        }
        if (this.isVerboseRecursive() != other.isVerboseRecursive()) {
            return false;
        }
        ThemesUI this$theme = this.getTheme();
        ThemesUI other$theme = other.getTheme();
        if (this$theme == null ? other$theme != null : !((Object)((Object)this$theme)).equals((Object)other$theme)) {
            return false;
        }
        Controls3D this$controls3D = this.getControls3D();
        Controls3D other$controls3D = other.getControls3D();
        return !(this$controls3D == null ? other$controls3D != null : !((Object)((Object)this$controls3D)).equals((Object)other$controls3D));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GlobalDemoSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isVerboseRuntime() ? 79 : 97);
        result = result * 59 + (this.isVerboseTracking() ? 79 : 97);
        result = result * 59 + (this.isVerboseRecursive() ? 79 : 97);
        ThemesUI $theme = this.getTheme();
        result = result * 59 + ($theme == null ? 43 : ((Object)((Object)$theme)).hashCode());
        Controls3D $controls3D = this.getControls3D();
        result = result * 59 + ($controls3D == null ? 43 : ((Object)((Object)$controls3D)).hashCode());
        return result;
    }

    public String toString() {
        return "GlobalDemoSettings(theme=" + this.getTheme() + ", controls3D=" + this.getControls3D() + ", verboseRuntime=" + this.isVerboseRuntime() + ", verboseTracking=" + this.isVerboseTracking() + ", verboseRecursive=" + this.isVerboseRecursive() + ")";
    }

    static {
        SETTINGS.load();
    }

    public static enum ThemesUI {
        DEFAULT("Default"),
        DARKULA("Darkula"),
        INTELLIJ("IntelliJ"),
        SOLARIZED("Solarized"),
        MARS_DARK("Mars Dark"),
        MATERIAL_LITE("Material Lite"),
        MATERIAL_OCEANIC("Material Oceanic");

        final String name;

        private ThemesUI(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Controls3D {
        WASD,
        MOUSE;

    }
}

