/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.gui.BoofSwingUtil;
import boofcv.gui.StandardAlgConfigPanel;
import javax.swing.JLabel;
import javax.swing.JSpinner;

public abstract class BaseImageControlPanel
extends StandardAlgConfigPanel {
    public JSpinner selectZoom;
    public JLabel processingTimeLabel = new JLabel();
    public JLabel imageSizeLabel = new JLabel();
    public int selectedView = 0;
    public double zoom = 1.0;

    public void setZoom(double _zoom) {
        _zoom = Math.max(0.01, _zoom);
        if ((_zoom = Math.min(50.0, _zoom)) == this.zoom) {
            return;
        }
        this.zoom = _zoom;
        BoofSwingUtil.invokeNowOrLater(() -> this.selectZoom.setValue(this.zoom));
    }

    public void setImageSize(int width, int height) {
        BoofSwingUtil.invokeNowOrLater(() -> this.imageSizeLabel.setText(width + " x " + height));
    }

    public void setProcessingTimeS(double seconds) {
        this.processingTimeLabel.setText(String.format("%7.1f", seconds * 1000.0));
    }

    public void setProcessingTimeMS(double ms) {
        BoofSwingUtil.checkGuiThread();
        this.processingTimeLabel.setText(String.format("%7.1f", ms));
    }
}

