/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.describe.DescribePointRadiusAngle;
import boofcv.abst.feature.describe.DescriptorInfo;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.factory.feature.associate.ConfigAssociate;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.describe.ConfigDescribeRegion;
import boofcv.factory.feature.describe.FactoryDescribePointRadiusAngle;
import boofcv.factory.feature.detdesc.ConfigDetectDescribe;
import boofcv.factory.feature.detdesc.FactoryDetectDescribe;
import boofcv.factory.feature.detect.interest.ConfigDetectInterestPoint;
import boofcv.factory.feature.detect.interest.FactoryInterestPoint;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.controls.JConfigLength;
import boofcv.gui.feature.ControlPanelAssociateGreedy;
import boofcv.gui.feature.ControlPanelAssociateNearestNeighbor;
import boofcv.gui.feature.ControlPanelDescribeBrief;
import boofcv.gui.feature.ControlPanelDescribeSift;
import boofcv.gui.feature.ControlPanelDescribeTemplate;
import boofcv.gui.feature.ControlPanelFastHessian;
import boofcv.gui.feature.ControlPanelPointDetector;
import boofcv.gui.feature.ControlPanelSiftDetector;
import boofcv.gui.feature.ControlPanelSurfDescribe;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public abstract class ControlPanelDetDescAssocBase
extends StandardAlgConfigPanel {
    protected JComboBox<String> comboDetect;
    protected JComboBox<String> comboDescribe;
    protected JComboBox<String> comboAssociate;
    public ConfigDetectDescribe configDetDesc = new ConfigDetectDescribe();
    public ConfigAssociate configAssociate = new ConfigAssociate();
    public ControlPanelSiftDetector controlDetectSift;
    public ControlPanelFastHessian controlDetectFastHessian;
    public ControlPanelPointDetector controlDetectPoint;
    public ControlPanelSurfDescribe.Speed controlDescSurfFast;
    public ControlPanelSurfDescribe.Stability controlDescSurfStable;
    public ControlPanelDescribeSift controlDescSift;
    public ControlPanelDescribeBrief controlDescBrief;
    public ControlPanelDescribeTemplate controlDescTemplate;
    public ControlPanelAssociateGreedy controlAssocGreedy;
    public ControlPanelAssociateNearestNeighbor controlAssocNN;
    public JConfigLength controlAssocMaxDistance;
    public boolean associateWithPixels = false;
    public StandardAlgConfigPanel panelAssociate2D = new StandardAlgConfigPanel();

    protected ControlPanelDetDescAssocBase() {
    }

    protected ControlPanelDetDescAssocBase(ConfigDetectDescribe configDetDesc, ConfigAssociate configAssociate) {
        this.configDetDesc = configDetDesc;
        this.configAssociate = configAssociate;
    }

    public void initializeControlsGUI() {
        this.comboDetect = this.combo(this.configDetDesc.typeDetector.ordinal(), ConfigDetectInterestPoint.Type.values());
        this.comboDescribe = this.combo(this.configDetDesc.typeDescribe.ordinal(), ConfigDescribeRegion.Type.values());
        this.comboAssociate = this.associateWithPixels ? this.combo(this.configAssociate.type.ordinal(), ConfigAssociate.AssociationType.GREEDY) : this.combo(this.configAssociate.type.ordinal(), ConfigAssociate.AssociationType.values());
        this.controlDetectSift = new ControlPanelSiftDetector(this.configDetDesc.scaleSpaceSift, this.configDetDesc.detectSift, this::handleControlsUpdated);
        this.controlDetectFastHessian = new ControlPanelFastHessian(this.configDetDesc.detectFastHessian, this::handleControlsUpdated);
        this.controlDetectPoint = new ControlPanelPointDetector(this.configDetDesc.detectPoint, this::handleControlsUpdated);
        this.controlDescSurfFast = new ControlPanelSurfDescribe.Speed(this.configDetDesc.describeSurfFast, this::handleControlsUpdated);
        this.controlDescSurfStable = new ControlPanelSurfDescribe.Stability(this.configDetDesc.describeSurfStability, this::handleControlsUpdated);
        this.controlDescSift = new ControlPanelDescribeSift(this.configDetDesc.describeSift, this::handleControlsUpdated);
        this.controlDescBrief = new ControlPanelDescribeBrief(this.configDetDesc.describeBrief, this::handleControlsUpdated);
        this.controlDescTemplate = new ControlPanelDescribeTemplate(this.configDetDesc.describeTemplate, this::handleControlsUpdated);
        this.controlAssocGreedy = new ControlPanelAssociateGreedy(this.configAssociate.greedy, this::handleControlsUpdated);
        this.controlAssocNN = new ControlPanelAssociateNearestNeighbor(this.configAssociate.nearestNeighbor, this::handleControlsUpdated);
        this.controlAssocMaxDistance = this.configLength(this.configAssociate.maximumDistancePixels, 0.0, 2000.0, this::handleControlsUpdated);
        this.panelAssociate2D.addLabeled(this.controlAssocMaxDistance, "Max Dist", "Maximum distance two features can be to be associated");
        this.panelAssociate2D.add(this.controlAssocGreedy);
        this.controlDetectSift.setBorder(BorderFactory.createEmptyBorder());
        this.controlDetectFastHessian.setBorder(BorderFactory.createEmptyBorder());
        this.controlDetectPoint.setBorder(BorderFactory.createEmptyBorder());
        this.controlDescSurfFast.setBorder(BorderFactory.createEmptyBorder());
        this.controlDescSurfStable.setBorder(BorderFactory.createEmptyBorder());
        this.controlDescSift.setBorder(BorderFactory.createEmptyBorder());
        this.controlDescBrief.setBorder(BorderFactory.createEmptyBorder());
        this.controlDescTemplate.setBorder(BorderFactory.createEmptyBorder());
        this.controlAssocGreedy.setBorder(BorderFactory.createEmptyBorder());
        this.controlAssocNN.setBorder(BorderFactory.createEmptyBorder());
        this.panelAssociate2D.setBorder(BorderFactory.createEmptyBorder());
    }

    protected abstract void handleControlsUpdated();

    public JPanel getDetectorPanel() {
        StandardAlgConfigPanel standardAlgConfigPanel;
        switch (this.configDetDesc.typeDetector) {
            case FAST_HESSIAN: {
                standardAlgConfigPanel = this.controlDetectFastHessian;
                break;
            }
            case SIFT: {
                standardAlgConfigPanel = this.controlDetectSift;
                break;
            }
            case POINT: {
                standardAlgConfigPanel = this.controlDetectPoint;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown");
            }
        }
        return standardAlgConfigPanel;
    }

    public JPanel getDescriptorPanel() {
        StandardAlgConfigPanel standardAlgConfigPanel;
        switch (this.configDetDesc.typeDescribe) {
            case SURF_FAST: 
            case SURF_COLOR_FAST: {
                standardAlgConfigPanel = this.controlDescSurfFast;
                break;
            }
            case SURF_STABLE: 
            case SURF_COLOR_STABLE: {
                standardAlgConfigPanel = this.controlDescSurfStable;
                break;
            }
            case SIFT: {
                standardAlgConfigPanel = this.controlDescSift;
                break;
            }
            case BRIEF: {
                standardAlgConfigPanel = this.controlDescBrief;
                break;
            }
            case TEMPLATE: {
                standardAlgConfigPanel = this.controlDescTemplate;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown: " + this.configDetDesc.typeDescribe);
            }
        }
        return standardAlgConfigPanel;
    }

    public JPanel getAssociatePanel() {
        StandardAlgConfigPanel standardAlgConfigPanel;
        if (this.associateWithPixels) {
            return this.panelAssociate2D;
        }
        switch (this.configAssociate.type) {
            case GREEDY: {
                standardAlgConfigPanel = this.controlAssocGreedy;
                break;
            }
            case KD_TREE: 
            case RANDOM_FOREST: {
                standardAlgConfigPanel = this.controlAssocNN;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown");
            }
        }
        return standardAlgConfigPanel;
    }

    public <T extends ImageGray<T>, D extends ImageGray<D>> DetectDescribePoint<T, ?> createDetectDescribe(Class<T> imageType) {
        return FactoryDetectDescribe.generic((ConfigDetectDescribe)this.configDetDesc, imageType);
    }

    public <T extends ImageGray<T>, D extends ImageGray<D>> InterestPointDetector<T> createDetector(Class<T> imageType) {
        ConfigDetectInterestPoint c = new ConfigDetectInterestPoint();
        c.type = this.configDetDesc.typeDetector;
        c.fastHessian = this.configDetDesc.detectFastHessian;
        c.point = this.configDetDesc.detectPoint;
        c.scaleSpaceSift = this.configDetDesc.scaleSpaceSift;
        c.sift = this.configDetDesc.detectSift;
        return FactoryInterestPoint.generic((ConfigDetectInterestPoint)c, imageType, null);
    }

    public <T extends ImageGray<T>, TD extends TupleDesc<TD>> DescribePointRadiusAngle<T, TD> createDescriptor(Class<T> imageType) {
        return this.createDescriptor(ImageType.single(imageType));
    }

    public <T extends ImageBase<T>, TD extends TupleDesc<TD>> DescribePointRadiusAngle<T, TD> createDescriptor(ImageType<T> imageType) {
        ConfigDescribeRegion c = new ConfigDescribeRegion();
        c.type = this.configDetDesc.typeDescribe;
        c.brief = this.configDetDesc.describeBrief;
        c.surfFast = this.configDetDesc.describeSurfFast;
        c.surfStability = this.configDetDesc.describeSurfStability;
        c.scaleSpaceSift = this.configDetDesc.scaleSpaceSift;
        c.template = this.configDetDesc.describeTemplate;
        return FactoryDescribePointRadiusAngle.generic((ConfigDescribeRegion)c, imageType);
    }

    public AssociateDescription createAssociate(DescriptorInfo descriptor) {
        if (this.configAssociate.type != ConfigAssociate.AssociationType.GREEDY && !TupleDesc_F64.class.isAssignableFrom(descriptor.getDescriptionType())) {
            JOptionPane.showMessageDialog(this, "Requires TupleDesc_F64 description type");
            this.configAssociate.type = ConfigAssociate.AssociationType.GREEDY;
        }
        return FactoryAssociation.generic((ConfigAssociate)this.configAssociate, (DescriptorInfo)descriptor);
    }

    public AssociateDescription2D createAssociate2(DescriptorInfo descriptor) {
        this.configAssociate.maximumDistancePixels.setTo(this.controlAssocMaxDistance.getValue());
        if (this.configAssociate.type != ConfigAssociate.AssociationType.GREEDY && !TupleDesc_F64.class.isAssignableFrom(descriptor.getDescriptionType())) {
            JOptionPane.showMessageDialog(this, "Requires TupleDesc_F64 description type");
            this.configAssociate.type = ConfigAssociate.AssociationType.GREEDY;
        }
        return FactoryAssociation.generic2((ConfigAssociate)this.configAssociate, (DescriptorInfo)descriptor);
    }
}

