/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public class JSpringPanel
extends JPanel {
    public SpringLayout layout = new SpringLayout();

    public JSpringPanel() {
        this.setLayout(this.layout);
    }

    public JPanel createCenterStretched(JComponent left, JComponent right) {
        JPanel panel = new JPanel();
        SpringLayout layout = new SpringLayout();
        panel.setLayout(layout);
        panel.add(left);
        panel.add(right);
        layout.putConstraint("North", (Component)left, 0, "North", (Component)panel);
        layout.putConstraint("North", (Component)right, 0, "North", (Component)panel);
        layout.putConstraint("South", (Component)left, 0, "South", (Component)panel);
        layout.putConstraint("South", (Component)right, 0, "South", (Component)panel);
        layout.putConstraint("West", (Component)left, 0, "West", (Component)panel);
        layout.putConstraint("East", (Component)left, -4, "HorizontalCenter", (Component)panel);
        layout.putConstraint("West", (Component)right, 4, "HorizontalCenter", (Component)panel);
        layout.putConstraint("East", (Component)right, 0, "East", (Component)panel);
        panel.setPreferredSize(new Dimension(0, 25));
        return panel;
    }

    public static JPanel createLockedSides(JComponent left, JComponent right, int height) {
        JPanel panel = new JPanel();
        SpringLayout layout = new SpringLayout();
        panel.setLayout(layout);
        panel.add(left);
        panel.add(right);
        layout.putConstraint("North", (Component)left, 0, "North", (Component)panel);
        layout.putConstraint("North", (Component)right, 0, "North", (Component)panel);
        layout.putConstraint("South", (Component)left, 0, "South", (Component)panel);
        layout.putConstraint("South", (Component)right, 0, "South", (Component)panel);
        layout.putConstraint("West", (Component)left, 0, "West", (Component)panel);
        layout.putConstraint("East", (Component)right, 0, "East", (Component)panel);
        panel.setPreferredSize(new Dimension(0, height));
        return panel;
    }

    public void constrainWestNorthEast(JComponent target, @Nullable Component above, int offsetTop, int offsetSides) {
        this.add(target);
        if (above == null) {
            this.layout.putConstraint("North", (Component)target, offsetTop, "North", (Component)this);
        } else {
            this.layout.putConstraint("North", (Component)target, offsetTop, "South", above);
        }
        this.layout.putConstraint("West", (Component)target, offsetSides, "West", (Component)this);
        this.layout.putConstraint("East", (Component)target, -offsetSides, "East", (Component)this);
    }

    public void constrainWestNorthEast(JComponent targetLeft, JComponent targetRight, @Nullable Component above, int offsetTop, int spaceLR, int offsetSides) {
        this.add(targetLeft);
        this.add(targetRight);
        if (above == null) {
            this.layout.putConstraint("North", (Component)targetLeft, offsetTop, "North", (Component)this);
            this.layout.putConstraint("North", (Component)targetRight, offsetTop, "North", (Component)this);
        } else {
            this.layout.putConstraint("North", (Component)targetLeft, offsetTop, "South", above);
            this.layout.putConstraint("North", (Component)targetRight, offsetTop, "South", above);
        }
        this.layout.putConstraint("West", (Component)targetLeft, offsetSides, "West", (Component)this);
        this.layout.putConstraint("West", (Component)targetRight, spaceLR, "East", (Component)targetLeft);
        this.layout.putConstraint("East", (Component)targetRight, -offsetSides, "East", (Component)this);
    }

    public void constrainWestNorth(JComponent targetLeft, JComponent targetRight, @Nullable Component above, int offsetTop, int spaceLR, int offsetSides) {
        this.add(targetLeft);
        this.add(targetRight);
        if (above == null) {
            this.layout.putConstraint("North", (Component)targetLeft, offsetTop, "North", (Component)this);
            this.layout.putConstraint("North", (Component)targetRight, offsetTop, "North", (Component)this);
        } else {
            this.layout.putConstraint("North", (Component)targetLeft, offsetTop, "South", above);
            this.layout.putConstraint("North", (Component)targetRight, offsetTop, "South", above);
        }
        this.layout.putConstraint("West", (Component)targetLeft, offsetSides, "West", (Component)this);
        this.layout.putConstraint("West", (Component)targetRight, spaceLR, "East", (Component)targetLeft);
    }

    public void constrainWestNorth(JComponent target, Component above, int offsetTop, int offsetLeft) {
        this.add(target);
        if (above == null) {
            this.layout.putConstraint("North", (Component)target, offsetTop, "North", (Component)this);
        } else {
            this.layout.putConstraint("North", (Component)target, offsetTop, "South", above);
        }
        this.layout.putConstraint("West", (Component)target, offsetLeft, "West", (Component)this);
    }

    public void constrainWestSouthEast(JComponent target, @Nullable Component below, int offsetBelow, int offsetSides) {
        this.add(target);
        if (below == null) {
            this.layout.putConstraint("South", (Component)target, -offsetBelow, "South", (Component)this);
        } else {
            this.layout.putConstraint("South", (Component)target, -offsetBelow, "North", below);
        }
        this.layout.putConstraint("West", (Component)target, offsetSides, "West", (Component)this);
        this.layout.putConstraint("East", (Component)target, -offsetSides, "East", (Component)this);
    }

    public JSpinner spinner(int initial, int minimum, int maximum, int stepSize) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(initial, minimum, maximum, stepSize));
        spinner.setMaximumSize(spinner.getPreferredSize());
        spinner.addChangeListener((ChangeListener)((Object)this));
        return spinner;
    }

    public JSpinner spinner(double initial, double minimum, double maximum, double stepSize) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(initial, minimum, maximum, stepSize));
        spinner.setMaximumSize(spinner.getPreferredSize());
        spinner.addChangeListener((ChangeListener)((Object)this));
        return spinner;
    }

    public void constrainTopCenter(JComponent target, @Nullable JComponent top, int padTop) {
        this.add(target);
        if (top == null) {
            this.layout.putConstraint("North", (Component)target, padTop, "North", (Component)this);
        } else {
            this.layout.putConstraint("North", (Component)target, padTop, "South", (Component)top);
        }
        this.layout.putConstraint("HorizontalCenter", (Component)target, 0, "HorizontalCenter", (Component)this);
    }

    public void constrainTopStretchH(JComponent target, @Nullable JComponent top, int padTop) {
        this.add(target);
        if (top == null) {
            this.layout.putConstraint("North", (Component)target, padTop, "North", (Component)this);
        } else {
            this.layout.putConstraint("North", (Component)target, padTop, "South", (Component)top);
        }
        this.layout.putConstraint("West", (Component)target, 5, "West", (Component)this);
        this.layout.putConstraint("East", (Component)target, -5, "East", (Component)this);
    }

    public void constrainBottomCenter(JComponent target, JComponent bottom, int padV) {
        this.add(target);
        this.constraintSouth(target, null, bottom, padV);
        this.layout.putConstraint("HorizontalCenter", (Component)target, 0, "HorizontalCenter", (Component)this);
    }

    public void constrainBottomStretchH(JComponent target, JComponent bottom, int padV) {
        this.add(target);
        this.constraintSouth(target, null, bottom, padV);
        this.layout.putConstraint("West", (Component)target, 5, "West", (Component)this);
        this.layout.putConstraint("East", (Component)target, -5, "East", (Component)this);
    }

    public void constrainStretchHV(JComponent target, @Nullable JComponent top, JComponent bottom, int padV) {
        this.add(target);
        if (top == null) {
            this.layout.putConstraint("North", (Component)target, padV, "North", (Component)this);
        } else {
            this.layout.putConstraint("North", (Component)target, padV, "South", (Component)top);
        }
        this.constraintSouth(target, top, bottom, padV);
        this.layout.putConstraint("West", (Component)target, 5, "West", (Component)this);
        this.layout.putConstraint("East", (Component)target, -5, "East", (Component)this);
    }

    public void constraintSouth(JComponent target, @Nullable JComponent top, @Nullable JComponent bottom, int padV) {
        if (bottom == null) {
            this.layout.putConstraint("South", (Component)target, -padV, "South", (Component)this);
        } else {
            Spring a = Spring.sum(Spring.constant(-padV), this.layout.getConstraint("North", bottom));
            Spring b = top == null ? Spring.sum(Spring.height(target), this.layout.getConstraint("North", this)) : Spring.sum(Spring.height(target), this.layout.getConstraint("South", top));
            this.layout.getConstraints(target).setConstraint("South", Spring.max(a, b));
        }
    }
}

