/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.abst.feature.describe.ConfigSiftScaleSpace;
import boofcv.gui.StandardAlgConfigPanel;
import javax.swing.JSpinner;

public class ControlPanelSiftScaleSpace
extends StandardAlgConfigPanel {
    public final ConfigSiftScaleSpace config;
    private final JSpinner spinnerSigma0;
    private final JSpinner spinnerNumScales;
    private final JSpinner spinnerNumOctaves;
    private final Listener listener;

    public ControlPanelSiftScaleSpace(ConfigSiftScaleSpace config, Listener listener) {
        this.config = config;
        this.listener = listener;
        this.spinnerSigma0 = this.spinner((double)config.sigma0, 0.0, 1000.0, 0.5, "0.0E0", 8);
        this.spinnerNumScales = this.spinner(config.numScales, 1, 100, 1);
        this.spinnerNumOctaves = this.spinner(config.lastOctave - config.firstOctave, 1, 100, 1);
        this.addLabeled(this.spinnerSigma0, "Sigma0", "Sigma of first level in image pyramid");
        this.addLabeled(this.spinnerNumScales, "Scales", "Number of scales in each octave. Number of images will be scales + 2");
        this.addLabeled(this.spinnerNumOctaves, "Octaves", "Number of octaves");
    }

    @Override
    public void controlChanged(Object source) {
        if (source == this.spinnerSigma0) {
            this.config.sigma0 = ((Number)this.spinnerSigma0.getValue()).floatValue();
        } else if (source == this.spinnerNumScales) {
            this.config.numScales = ((Number)this.spinnerNumScales.getValue()).intValue();
        } else if (source == this.spinnerNumOctaves) {
            int offset = ((Number)this.spinnerNumOctaves.getValue()).intValue();
            this.config.lastOctave = this.config.firstOctave + offset;
        }
        this.listener.handleScaleSpaceChange();
    }

    @FunctionalInterface
    public static interface Listener {
        public void handleScaleSpaceChange();
    }
}

