/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.gui.BoofSwingUtil;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ScaleOptions;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.ImageBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListDisplayPanel
extends JPanel
implements ListSelectionListener {
    final List<JComponent> panels = new ArrayList<JComponent>();
    private JPanel bodyPanel;
    private JList listPanel;
    DefaultListModel listModel = new DefaultListModel();
    JScrollPane scroll;
    private int bodyWidth;
    private int bodyHeight;

    public ListDisplayPanel() {
        this.setLayout(new BorderLayout());
        this.listPanel = new JList(this.listModel);
        this.listPanel.setSelectionMode(0);
        this.listPanel.setSelectedIndex(0);
        this.listPanel.addListSelectionListener(this);
        this.scroll = new JScrollPane(this.listPanel);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.bodyPanel = new JPanel();
        this.bodyPanel.setLayout(new BorderLayout());
        this.bodyPanel.add((Component)this.scroll, "West");
        this.add(this.bodyPanel);
    }

    public ListDisplayPanel(String ... names) {
        this();
        for (String n : names) {
            this.addItem(new JPanel(), n);
        }
    }

    public synchronized void reset() {
        this.panels.clear();
        if (SwingUtilities.isEventDispatchThread()) {
            this.listModel.removeAllElements();
        } else {
            SwingUtilities.invokeLater(() -> this.listModel.removeAllElements());
        }
    }

    public int getListWidth() {
        return (int)this.listPanel.getPreferredSize().getWidth();
    }

    public ImagePanel addImage(ImageBase image, String name) {
        BufferedImage buff = ConvertBufferedImage.convertTo((ImageBase)image, null, (boolean)true);
        return this.addImage(buff, name, ScaleOptions.DOWN);
    }

    public ImagePanel addImage(BufferedImage image, String name) {
        return this.addImage(image, name, ScaleOptions.DOWN);
    }

    public ImagePanel addImage(BufferedImage image, String name, ScaleOptions scaling) {
        BoofMiscOps.checkTrue((image != null ? 1 : 0) != 0, (String)"image is null. Does the file not exist?");
        ImagePanel panel = new ImagePanel(image, scaling);
        this.addItem(panel, name);
        return panel;
    }

    public void addImage(String name, BufferedImage image) {
        this.addImage(image, name, ScaleOptions.DOWN);
    }

    public synchronized void addItem(JComponent panel, String name) {
        Dimension panelD = panel.getPreferredSize();
        int adjustedWidth = panelD.width + 70;
        boolean sizeChanged = this.bodyWidth != adjustedWidth || this.bodyHeight != panelD.height;
        this.bodyWidth = Math.max(this.bodyWidth, adjustedWidth);
        this.bodyHeight = (int)Math.max((double)this.bodyHeight, panelD.getHeight());
        BoofSwingUtil.invokeNowOrLater(() -> {
            Component old;
            this.panels.add(panel);
            this.listModel.addElement(name);
            if (this.listModel.size() == 1) {
                this.listPanel.setSelectedIndex(0);
            }
            Dimension d = this.listPanel.getMinimumSize();
            this.listPanel.setPreferredSize(new Dimension(10 + d.width + this.scroll.getVerticalScrollBar().getWidth(), d.height));
            if (sizeChanged && (old = ((BorderLayout)this.bodyPanel.getLayout()).getLayoutComponent("Center")) != null) {
                old.setPreferredSize(new Dimension(this.bodyWidth, this.bodyHeight));
            }
            this.validate();
        });
    }

    public void addItem(String name, JComponent panel) {
        this.addItem(panel, name);
    }

    public void setItem(int index, JComponent panel) {
        BoofSwingUtil.invokeNowOrLater(() -> {
            Component old;
            this.panels.set(index, panel);
            int w = 0;
            int h = 0;
            for (int i = 0; i < this.panels.size(); ++i) {
                JComponent p = this.panels.get(i);
                w = Math.max(w, p.getWidth());
                h = Math.max(h, p.getWidth());
            }
            boolean sizeChanged = this.bodyWidth != w || this.bodyHeight != h;
            this.bodyWidth = w;
            this.bodyHeight = h;
            Dimension d = this.listPanel.getMinimumSize();
            this.listPanel.setPreferredSize(new Dimension(d.width + this.scroll.getVerticalScrollBar().getWidth(), d.height));
            if (sizeChanged && (old = ((BorderLayout)this.bodyPanel.getLayout()).getLayoutComponent("Center")) != null) {
                old.setPreferredSize(new Dimension(this.bodyWidth, this.bodyHeight));
            }
            this.validate();
            if (this.listPanel.getSelectedIndex() == index) {
                this.changeBodyPanel(index);
            }
        });
    }

    @Override
    public synchronized void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int index = this.listPanel.getSelectedIndex();
        if (index >= 0) {
            this.changeBodyPanel(index);
        }
    }

    protected void changeBodyPanel(int index) {
        this.removeCenterBody();
        JComponent p = this.panels.get(index);
        p.setPreferredSize(new Dimension(this.bodyWidth, this.bodyHeight));
        this.bodyPanel.add((Component)p, "Center");
        this.bodyPanel.validate();
        this.bodyPanel.repaint();
    }

    private void removeCenterBody() {
        Component old = ((BorderLayout)this.bodyPanel.getLayout()).getLayoutComponent("Center");
        if (old != null) {
            this.bodyPanel.remove(old);
        }
    }

    public JComponent getBodyPanel() {
        return this.bodyPanel;
    }
}

