/*
 * Copyright (c) 2021, Peter Abeles. All Rights Reserved.
 *
 * This file is part of BoofCV (http://boofcv.org).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package boofcv.gui.calibration;

import java.awt.image.BufferedImage;

/**
 * Used to specify a set of stereo images. The set has a fixed sized and O(1) time to switch images. Images
 * are returned as a {@link BufferedImage}.
 *
 * @author Peter Abeles
 */
public interface StereoImageSet {

	void setSelected( int index );

	int size();

	String getLeftName();

	String getRightName();

	BufferedImage loadLeft();

	BufferedImage loadRight();
}
