/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.alg.misc.PixelMath;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.flow.ImageFlow;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_F64;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;

public class VisualizeOpticalFlow {
    Line2D.Double line = new Line2D.Double();
    public double maxVelocity = 0.0;
    public int red;
    public int green;
    public int blue;
    Stroke strokeLine = new BasicStroke(5.0f);
    double logBase = 0.0;
    double logScale = 25.0;
    double maxLog = Math.log(this.logScale + this.logBase);

    public static void colorizeDirection(ImageFlow flowImage, BufferedImage out) {
        int[] tableSine = new int[360];
        int[] tableCosine = new int[360];
        for (int i = 0; i < 360; ++i) {
            double angle = (double)i * Math.PI / 180.0;
            tableSine[i] = (int)(255.0 * (Math.sin(angle) + 1.0) / 2.0);
            tableCosine[i] = (int)(255.0 * (Math.cos(angle) + 1.0) / 2.0);
        }
        for (int y = 0; y < flowImage.height; ++y) {
            for (int x = 0; x < flowImage.width; ++x) {
                ImageFlow.D f = flowImage.unsafe_get(x, y);
                if (!f.isValid()) {
                    out.setRGB(x, y, 255);
                    continue;
                }
                double angle = Math.atan2(f.y, f.x);
                int degree = (int)(180.0 + angle * 179.999 / Math.PI);
                int r = tableSine[degree];
                int g = tableCosine[degree];
                out.setRGB(x, y, r << 16 | g << 8);
            }
        }
    }

    public static void magnitudeAbs(ImageFlow flowImage, BufferedImage out) {
        GrayF32 magnitude = new GrayF32(flowImage.width, flowImage.height);
        float max = 0.0f;
        for (int y = 0; y < flowImage.height; ++y) {
            for (int x = 0; x < flowImage.width; ++x) {
                ImageFlow.D f = flowImage.unsafe_get(x, y);
                if (!f.isValid()) {
                    out.setRGB(x, y, 255);
                    continue;
                }
                float m = Math.max(Math.abs(f.x), Math.abs(f.y));
                if (m > max) {
                    max = m;
                }
                magnitude.unsafe_set(x, y, m);
            }
        }
        PixelMath.multiply((GrayF32)magnitude, (float)(255.0f / max), (GrayF32)magnitude);
        ConvertBufferedImage.convertTo((GrayF32)magnitude, (BufferedImage)out);
    }

    public static void magnitudeAbs(ImageFlow flowImage, float maxValue, BufferedImage out) {
        GrayF32 magnitude = new GrayF32(flowImage.width, flowImage.height);
        for (int y = 0; y < flowImage.height; ++y) {
            for (int x = 0; x < flowImage.width; ++x) {
                ImageFlow.D f = flowImage.unsafe_get(x, y);
                if (!f.isValid()) {
                    out.setRGB(x, y, 255);
                    continue;
                }
                float m = Math.max(Math.abs(f.x), Math.abs(f.y));
                magnitude.unsafe_set(x, y, m);
            }
        }
        PixelMath.multiply((GrayF32)magnitude, (float)(255.0f / maxValue), (GrayF32)magnitude);
        PixelMath.boundImage((GrayF32)magnitude, (float)0.0f, (float)255.0f);
        ConvertBufferedImage.convertTo((GrayF32)magnitude, (BufferedImage)out);
    }

    public static void colorized(ImageFlow flowImage, float maxValue, BufferedImage out) {
        int[] tableSine = new int[360];
        int[] tableCosine = new int[360];
        for (int i = 0; i < 360; ++i) {
            double angle = (double)i * Math.PI / 180.0;
            tableSine[i] = (int)(255.0 * (Math.sin(angle) + 1.0) / 2.0);
            tableCosine[i] = (int)(255.0 * (Math.cos(angle) + 1.0) / 2.0);
        }
        for (int y = 0; y < flowImage.height; ++y) {
            for (int x = 0; x < flowImage.width; ++x) {
                ImageFlow.D f = flowImage.unsafe_get(x, y);
                if (!f.isValid()) {
                    out.setRGB(x, y, 85);
                    continue;
                }
                float m = Math.max(Math.abs(f.x), Math.abs(f.y)) / maxValue;
                if (m > 1.0f) {
                    m = 1.0f;
                }
                double angle = Math.atan2(f.y, f.x);
                int degree = (int)(180.0 + angle * 179.999 / Math.PI);
                int r = (int)(m * (float)tableSine[degree]);
                int g = (int)(m * (float)tableCosine[degree]);
                out.setRGB(x, y, r << 16 | g << 8);
            }
        }
    }

    public void drawLine(double x1, double y1, double x2, double y2, Graphics2D g2) {
        g2.setColor(this.createColor());
        this.line.x1 = x1;
        this.line.y1 = y1;
        this.line.x2 = x2;
        this.line.y2 = y2;
        g2.setStroke(this.strokeLine);
        g2.draw(this.line);
    }

    public Color createColor() {
        return new Color(this.red, this.green, this.blue);
    }

    public void computeColor(Point2D_F64 p, Point2D_F64 prev, boolean log) {
        if (prev == null) {
            this.blue = 0;
            this.red = 0;
            this.green = 255;
        } else if (log) {
            this.computeColorLog(p.x - prev.x, p.y - prev.y);
        } else {
            this.computeColor(p.x - prev.x, p.y - prev.y);
        }
    }

    public void computeColor(double dx, double dy) {
        this.green = 0;
        this.blue = 0;
        this.red = 0;
        if (dx > 0.0) {
            this.red = Math.min(255, (int)(255.0 * dx / this.maxVelocity));
        } else {
            this.green = Math.min(255, (int)(-255.0 * dx / this.maxVelocity));
        }
        if (dy > 0.0) {
            this.blue = Math.min(255, (int)(255.0 * dy / this.maxVelocity));
        } else {
            int v = Math.min(255, (int)(-255.0 * dy / this.maxVelocity));
            this.red += v;
            this.green += v;
            if (this.red > 255) {
                this.red = 255;
            }
            if (this.green > 255) {
                this.green = 255;
            }
        }
    }

    public void computeColorLog(double dx, double dy) {
        this.green = 0;
        this.blue = 0;
        this.red = 0;
        if (dx > 0.0) {
            this.red = Math.max(0, (int)(255.0 * Math.log(this.logBase + this.logScale * dx / this.maxVelocity) / this.maxLog));
        } else {
            this.green = Math.max(0, (int)(255.0 * Math.log(this.logBase - this.logScale * dx / this.maxVelocity) / this.maxLog));
        }
        if (dy > 0.0) {
            this.blue = Math.max(0, (int)(255.0 * Math.log(this.logBase + this.logScale * dy / this.maxVelocity) / this.maxLog));
        } else {
            int v = Math.max(0, (int)(255.0 * Math.log(this.logBase - this.logScale * dy / this.maxVelocity) / this.maxLog));
            this.red += v;
            this.green += v;
            if (this.red > 255) {
                this.red = 255;
            }
            if (this.green > 255) {
                this.green = 255;
            }
        }
    }
}

