/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.struct.image.GrayS32;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Objects;
import java.util.Random;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class ImageBinaryLabeledPanel
extends JPanel
implements MouseListener {
    @Nullable
    protected BufferedImage img;
    protected GrayS32 labelImage;
    int[] colors;

    public ImageBinaryLabeledPanel(GrayS32 labelImage, int maxValues, long randSeed) {
        this();
        this.labelImage = labelImage;
        this.img = new BufferedImage(labelImage.getWidth(), labelImage.getHeight(), 1);
        this.setPreferredSize(new Dimension(labelImage.getWidth(), labelImage.getHeight()));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        Random rand = new Random(randSeed);
        this.colors = BinaryImageOps.selectRandomColors((int)maxValues, (Random)rand);
        VisualizeBinaryData.renderLabeled(labelImage, this.colors, this.img);
    }

    protected ImageBinaryLabeledPanel() {
        this.addMouseListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.img != null) {
            g.drawImage(this.img, 0, 0, this);
        }
    }

    public void setImage(GrayS32 binaryImage) {
        this.labelImage = binaryImage;
    }

    public BufferedImage getImage() {
        return Objects.requireNonNull(this.img);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.labelImage.isInBounds(e.getX(), e.getY())) {
            int val = this.labelImage.get(e.getX(), e.getY());
            System.out.println("Label at (" + e.getX() + "," + e.getY() + ") = " + val);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

