/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.alg.misc.ImageStatistics;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.gui.image.ShowImages;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.image.GrayF32;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;

public class BoofLogo
extends JPanel {
    public static final String NAME = "BOOFCV";
    public static final int MAX_RADIUS = 40;
    public int radius = 40;
    public boolean reverse = false;

    public BoofLogo() {
        this.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension(620, 300));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int order = 1;
        double sigma = FactoryKernelGaussian.sigmaForRadius((double)this.radius, (int)order);
        Kernel1D_F32 kerX = (Kernel1D_F32)FactoryKernelGaussian.derivativeK(Kernel1D_F32.class, (int)order, (double)sigma, (int)(2 * this.radius));
        Kernel1D_F32 kerY = (Kernel1D_F32)FactoryKernelGaussian.derivativeK(Kernel1D_F32.class, (int)order, (double)sigma, (int)this.radius);
        GrayF32 kernel = new GrayF32(kerX.width, kerY.width);
        int index = 0;
        for (int i = 0; i < kernel.height; ++i) {
            for (int j = 0; j < kernel.width; ++j) {
                kernel.data[index++] = kerY.data[i] * kerX.data[j];
            }
        }
        float max = ImageStatistics.maxAbs((GrayF32)kernel);
        BufferedImage image = new BufferedImage(kernel.width, kernel.height, 1);
        for (int y = 0; y < kernel.height; ++y) {
            for (int x = 0; x < kernel.width; ++x) {
                int rgb;
                int inv255;
                float v = kernel.get(x, y);
                if (v > 0.0f) {
                    inv255 = (int)(200.0f * (1.0f - v / max)) + 55;
                    rgb = 0xFF0000 | inv255 << 8 | inv255;
                } else {
                    inv255 = (int)(200.0f * (1.0f + v / max)) + 55;
                    rgb = inv255 << 16 | inv255 << 8 | inv255;
                }
                image.setRGB(x, y, rgb);
            }
        }
        double w = Math.min(this.getWidth(), this.getHeight());
        double s = w / (double)kernel.height;
        double tx = (int)(((double)this.getWidth() - s * (double)kernel.width) / 2.0);
        AffineTransform adjustment = new AffineTransform(s, 0.0, 0.0, s, tx, 0.0);
        g2.drawImage(image, adjustment, null);
        Font font = new Font("Serif", 1, (int)(w * 0.4));
        FontMetrics metrics = g2.getFontMetrics(font);
        Rectangle2D r = metrics.getStringBounds(NAME, null);
        tx = (double)(this.getWidth() / 2) - r.getCenterX();
        double ty = (double)((int)w / 2) - r.getCenterY();
        g2.setFont(font);
        g2.setColor(Color.BLACK);
        g2.drawString(NAME, (float)tx, (float)ty);
    }

    public void animate(long period) {
        this.radius = 1;
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                BoofLogo.this.radius = BoofLogo.this.radius + (BoofLogo.this.reverse ? -1 : 1);
                if (BoofLogo.this.radius <= 0) {
                    BoofLogo.this.radius = 1;
                    BoofLogo.this.reverse = false;
                } else if (BoofLogo.this.radius >= 40) {
                    BoofLogo.this.reverse = true;
                }
                BoofLogo.this.repaint();
            }
        }, 0L, period / 40L);
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public static void main(String[] args) {
        BoofLogo logo = new BoofLogo();
        logo.animate(4000L);
        ShowImages.showWindow(logo, "Logo", true);
    }
}

