/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.abst.scene.ImageClassifier;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ScaleOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImageClassificationPanel
extends JPanel
implements ListSelectionListener {
    JTextArea textArea = new JTextArea();
    JScrollPane listScroll;
    private JList listPanel;
    JLayeredPane centerPanel;
    private ImagePanel centerImage = new ImagePanel();
    DefaultListModel listModel = new DefaultListModel();
    final List<Image> results = new ArrayList<Image>();

    public ImageClassificationPanel() {
        super(new BorderLayout());
        this.listPanel = new JList(this.listModel);
        this.listPanel.setSelectionMode(0);
        this.listPanel.setSelectedIndex(0);
        this.listPanel.addListSelectionListener(this);
        this.listScroll = new JScrollPane(this.listPanel);
        this.listScroll.setVerticalScrollBarPolicy(22);
        this.listScroll.setHorizontalScrollBarPolicy(31);
        this.centerPanel = new JLayeredPane();
        this.centerPanel.setPreferredSize(new Dimension(600, 600));
        this.centerPanel.add((Component)this.textArea, 0);
        this.centerPanel.add((Component)this.centerImage, 1);
        this.centerImage.setScaling(ScaleOptions.DOWN);
        this.centerImage.setOpaque(true);
        this.textArea.setFont(new Font("Courier New", 1, 16));
        this.textArea.setLineWrap(false);
        this.textArea.setOpaque(true);
        this.textArea.setForeground(Color.BLACK);
        this.textArea.setBackground(new Color(255, 255, 255, 125));
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.listScroll, "West");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImage(BufferedImage image, String name, List<ImageClassifier.Score> scores, List<String> categories) {
        List<Image> list = this.results;
        synchronized (list) {
            Image a = new Image();
            a.image = image;
            a.name = name;
            for (ImageClassifier.Score score : scores) {
                a.results.add(String.format("%6.2f %s", score.score, categories.get(score.category)));
            }
            this.results.add(a);
            SwingUtilities.invokeLater(() -> {
                this.listModel.addElement(a.name);
                if (this.listModel.size() == 1) {
                    this.listPanel.setSelectedIndex(0);
                }
                Dimension d = this.listPanel.getMinimumSize();
                this.listPanel.setPreferredSize(new Dimension(d.width + this.listScroll.getVerticalScrollBar().getWidth(), d.height));
                this.validate();
            });
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int index = this.listPanel.getSelectedIndex();
        if (index >= 0) {
            Image selected;
            List<Image> list = this.results;
            synchronized (list) {
                selected = this.results.get(index);
            }
            SwingUtilities.invokeLater(() -> {
                Object text = "";
                int N = Math.min(5, selected.results.size());
                for (String s : selected.results.subList(0, N)) {
                    text = (String)text + s + "\n";
                }
                this.textArea.setText((String)text);
                Dimension tp = this.textArea.getPreferredSize();
                this.textArea.setBounds(0, 0, tp.width, tp.height);
                int w = Math.min(selected.image.getWidth(), this.centerPanel.getWidth());
                int h = Math.min(selected.image.getHeight(), this.centerPanel.getHeight());
                this.centerImage.setBounds(0, 0, w, h);
                this.centerImage.setImageRepaint(selected.image);
            });
        }
    }

    private static class Image {
        BufferedImage image;
        String name;
        List<String> results = new ArrayList<String>();

        private Image() {
        }
    }
}

