/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.abst.disparity.StereoDisparitySparse;
import boofcv.factory.disparity.ConfigDisparityBM;
import boofcv.factory.disparity.DisparityError;
import boofcv.factory.disparity.FactoryStereoDisparity;
import boofcv.factory.transform.census.CensusVariants;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.image.ShowImages;
import boofcv.struct.image.ImageGray;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class ControlPanelDisparitySparse
extends StandardAlgConfigPanel {
    private static String[] ERRORS_BLOCK = new String[]{"SAD", "Census", "NCC"};
    public final ConfigDisparityBM config;
    JComboBox<String> comboError;
    JTabbedPane tabbedPane = new JTabbedPane();
    ControlsBlockMatching controlBM;
    ControlsSAD controlSad;
    ControlsCensus controlCensus;
    ControlsNCC controlNCC;
    boolean ignoreChanges = false;
    Listener listener;

    public ControlPanelDisparitySparse(Listener listener, ConfigDisparityBM config) {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.config = config;
        this.listener = listener;
        this.comboError = this.combo(e -> this.handleErrorSelected(false), config.errorType.ordinal(), (Object[])ERRORS_BLOCK);
        this.controlBM = new ControlsBlockMatching();
        this.controlSad = new ControlsSAD();
        this.controlCensus = new ControlsCensus();
        this.controlNCC = new ControlsNCC();
        this.tabbedPane.addTab("Disparity", this.controlBM);
        this.tabbedPane.addTab("Error", this.getErrorControl(this.comboError.getSelectedIndex()));
        this.tabbedPane.setBorder(BorderFactory.createEmptyBorder());
        this.addLabeled(this.comboError, "Error");
        this.add(this.tabbedPane);
    }

    public void broadcastChange() {
        Listener listener = this.listener;
        if (listener == null) {
            return;
        }
        if (this.ignoreChanges) {
            return;
        }
        listener.handleSparseDisparityChange();
    }

    public <T extends ImageGray<T>> StereoDisparitySparse<T> createAlgorithm(Class<T> imageType) {
        return FactoryStereoDisparity.sparseRectifiedBM((ConfigDisparityBM)this.config, imageType);
    }

    public int getDisparityMin() {
        return this.config.disparityMin;
    }

    public int getDisparityRange() {
        return this.config.disparityRange;
    }

    private void handleErrorSelected(boolean force) {
        int previousIdx = this.config.errorType.ordinal();
        if (!force && previousIdx == this.comboError.getSelectedIndex()) {
            return;
        }
        int selectedIdx = this.comboError.getSelectedIndex();
        if (!force) {
            this.ignoreChanges = true;
        }
        int activeTab = this.tabbedPane.getSelectedIndex();
        this.config.errorType = DisparityError.values()[selectedIdx];
        this.controlCensus.update();
        this.controlNCC.update();
        Component c = this.getErrorControl(selectedIdx);
        this.tabbedPane.removeTabAt(1);
        this.tabbedPane.insertTab("Error", null, c, null, 1);
        this.tabbedPane.setSelectedIndex(activeTab);
        if (!force) {
            SwingUtilities.invokeLater(() -> {
                this.ignoreChanges = false;
                this.broadcastChange();
            });
        }
    }

    private Component getErrorControl(int selectedIdx) {
        StandardAlgConfigPanel c;
        switch (selectedIdx) {
            case 0: {
                c = this.controlSad;
                break;
            }
            case 1: {
                c = this.controlCensus;
                break;
            }
            case 2: {
                c = this.controlNCC;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown");
            }
        }
        return c;
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public static void main(String[] args) {
        ControlPanelDisparitySparse controls = new ControlPanelDisparitySparse(() -> {}, new ConfigDisparityBM());
        ShowImages.showWindow(controls, "Controls");
    }

    public static interface Listener {
        public void handleSparseDisparityChange();
    }

    public class ControlsBlockMatching
    extends StandardAlgConfigPanel {
        JSpinner spinnerDisparityMin;
        JSpinner spinnerDisparityRange;
        JSpinner radiusXSpinner;
        JSpinner radiusYSpinner;
        JSpinner spinnerError;
        JSpinner spinnerReverse;
        JSpinner spinnerTexture;
        JCheckBox subpixelToggle;

        ControlsBlockMatching() {
            this.spinnerDisparityMin = this.spinner(ControlPanelDisparitySparse.this.config.disparityMin, 0, 1000, 5);
            this.spinnerDisparityRange = this.spinner(ControlPanelDisparitySparse.this.config.disparityRange, 1, 254, 5);
            this.radiusXSpinner = this.spinner(ControlPanelDisparitySparse.this.config.regionRadiusX, 0, 50, 1);
            this.radiusYSpinner = this.spinner(ControlPanelDisparitySparse.this.config.regionRadiusY, 0, 50, 1);
            this.spinnerError = this.spinner(ControlPanelDisparitySparse.this.config.maxPerPixelError, -1.0, 80.0, 5.0);
            this.spinnerReverse = this.spinner(ControlPanelDisparitySparse.this.config.validateRtoL, -1, 50, 1);
            this.spinnerTexture = this.spinner(ControlPanelDisparitySparse.this.config.texture, 0.0, 1.0, 0.05, 1, 3);
            this.subpixelToggle = this.checkbox("Subpixel", ControlPanelDisparitySparse.this.config.subpixel, "Subpixel Disparity Estimate");
            this.setBorder(BorderFactory.createEmptyBorder());
            this.addLabeled(this.spinnerDisparityMin, "Min Disp.", "Minimum disparity value considered. (Pixels)");
            this.addLabeled(this.spinnerDisparityRange, "Range Disp.", "Range of disparity values searched. (Pixels)");
            this.addLabeled(this.radiusXSpinner, "Radius X", "Block Width. (Pixels)");
            this.addLabeled(this.radiusYSpinner, "Radius Y", "Block Height. (Pixels)");
            this.addLabeled(this.spinnerError, "Max Error", "Maximum allowed matching error");
            this.addLabeled(this.spinnerTexture, "Texture", "Texture validation. 0 = disabled. 1 = most strict.");
            this.addLabeled(this.spinnerReverse, "Reverse", "Reverse Validation Tolerance. -1 = disable. (Pixels)");
            this.addAlignLeft(this.subpixelToggle);
        }

        @Override
        public void controlChanged(Object source) {
            if (source == this.spinnerDisparityMin) {
                ControlPanelDisparitySparse.this.config.disparityMin = ((Number)this.spinnerDisparityMin.getValue()).intValue();
            } else if (source == this.spinnerDisparityRange) {
                ControlPanelDisparitySparse.this.config.disparityRange = ((Number)this.spinnerDisparityRange.getValue()).intValue();
            } else if (source == this.spinnerError) {
                ControlPanelDisparitySparse.this.config.maxPerPixelError = ((Number)this.spinnerError.getValue()).intValue();
            } else if (source == this.radiusXSpinner) {
                ControlPanelDisparitySparse.this.config.regionRadiusX = ((Number)this.radiusXSpinner.getValue()).intValue();
            } else if (source == this.radiusYSpinner) {
                ControlPanelDisparitySparse.this.config.regionRadiusY = ((Number)this.radiusYSpinner.getValue()).intValue();
            } else if (source == this.spinnerTexture) {
                ControlPanelDisparitySparse.this.config.texture = ((Number)this.spinnerTexture.getValue()).doubleValue();
            } else if (source == this.subpixelToggle) {
                ControlPanelDisparitySparse.this.config.subpixel = this.subpixelToggle.isSelected();
            } else if (source == this.spinnerReverse) {
                ControlPanelDisparitySparse.this.config.validateRtoL = ((Number)this.spinnerReverse.getValue()).intValue();
            } else {
                throw new RuntimeException("Unknown");
            }
            ControlPanelDisparitySparse.this.broadcastChange();
        }
    }

    static class ControlsSAD
    extends StandardAlgConfigPanel {
        ControlsSAD() {
        }
    }

    class ControlsCensus
    extends StandardAlgConfigPanel {
        JComboBox<String> comboVariant;

        public ControlsCensus() {
            this.comboVariant = this.combo(ControlPanelDisparitySparse.this.config.configCensus.variant.ordinal(), CensusVariants.values());
            this.setBorder(BorderFactory.createEmptyBorder());
            this.addLabeled(this.comboVariant, "Variant");
        }

        public void update() {
            this.comboVariant.setSelectedIndex(ControlPanelDisparitySparse.this.config.configCensus.variant.ordinal());
        }

        @Override
        public void controlChanged(Object source) {
            if (source != this.comboVariant) {
                throw new RuntimeException("Unknown");
            }
            ControlPanelDisparitySparse.this.config.configCensus.variant = CensusVariants.values()[this.comboVariant.getSelectedIndex()];
            ControlPanelDisparitySparse.this.broadcastChange();
        }
    }

    class ControlsNCC
    extends StandardAlgConfigPanel {
        JSpinner spinnerEps;

        ControlsNCC() {
            this.spinnerEps = this.spinner(ControlPanelDisparitySparse.this.config.configNCC.eps, 0.0, 1.0, 0.001, "0.0E0", 10);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.addLabeled(this.spinnerEps, "EPS");
        }

        public void update() {
            this.spinnerEps.setValue(ControlPanelDisparitySparse.this.config.configNCC.eps);
        }

        @Override
        public void controlChanged(Object source) {
            if (source != this.spinnerEps) {
                throw new RuntimeException("Unknown");
            }
            ControlPanelDisparitySparse.this.config.configNCC.eps = ((Number)this.spinnerEps.getValue()).doubleValue();
            ControlPanelDisparitySparse.this.broadcastChange();
        }
    }
}

